/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.osspecific;

import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.Plugin;
import artofillusion.PreferencesWindow;
import artofillusion.RecentFiles;
import artofillusion.Scene;
import artofillusion.TitleWindow;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.CommandEvent;
import buoy.event.MouseClickedEvent;
import buoy.widget.BFrame;
import buoy.widget.BMenu;
import buoy.widget.BMenuBar;
import buoy.widget.BMenuItem;
import buoy.widget.BSeparator;
import buoy.widget.MenuWidget;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JFrame;

public class MacOSPlugin
implements Plugin,
InvocationHandler {
    private boolean isMacOSX;
    private boolean usingAppMenu;
    static /* synthetic */ Class class$artofillusion$RecentFiles;

    public void processMessage(int message, Object[] args) {
        if (message == 0) {
            String os = ((String)System.getProperties().get("os.name")).toLowerCase();
            if (!os.startsWith("mac os x")) {
                return;
            }
            this.isMacOSX = true;
            ModellingApp.addWindow((EditingWindow)new MacMenuBarWindow());
            ModellingApp.defaultFont = new Font("Application", 0, 11);
            ModellingApp.standardDialogInsets = 3;
            try {
                Class<?> appClass = Class.forName("com.apple.eawt.Application");
                Object app = appClass.getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
                appClass.getMethod("setEnabledAboutMenu", Boolean.TYPE).invoke(app, Boolean.TRUE);
                appClass.getMethod("setEnabledPreferencesMenu", Boolean.TYPE).invoke(app, Boolean.TRUE);
                Class<?> listenerClass = Class.forName("com.apple.eawt.ApplicationListener");
                Object proxy = Proxy.newProxyInstance(appClass.getClassLoader(), new Class[]{listenerClass}, (InvocationHandler)this);
                appClass.getMethod("addApplicationListener", listenerClass).invoke(app, proxy);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.usingAppMenu = true;
        } else if (message == 2) {
            if (!this.usingAppMenu) {
                return;
            }
            LayoutWindow win = (LayoutWindow)args[0];
            this.removeMenuItem((BFrame)win, Translate.text((String)"menu.file"), Translate.text((String)"menu.quit"));
            this.removeMenuItem((BFrame)win, Translate.text((String)"menu.edit"), Translate.text((String)"menu.preferences"));
        }
    }

    private void removeMenuItem(BFrame frame, String menu, String item) {
        BMenuBar bar = frame.getMenuBar();
        for (int i = 0; i < bar.getChildCount(); ++i) {
            BMenu m = bar.getChild(i);
            if (!m.getText().equals(menu)) continue;
            for (int j = 0; j < m.getChildCount(); ++j) {
                MenuWidget w = m.getChild(j);
                if (!(w instanceof BMenuItem) || !((BMenuItem)w).getText().equals(item)) continue;
                m.remove((Widget)w);
                if (j > 0 && m.getChild(j - 1) instanceof BSeparator) {
                    m.remove((Widget)m.getChild(j - 1));
                }
                return;
            }
            return;
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) {
        boolean handled = true;
        if ("handleAbout".equals(method.getName())) {
            TitleWindow win = new TitleWindow();
            win.addEventLink(MouseClickedEvent.class, (Object)win, "dispose");
        } else if ("handlePreferences".equals(method.getName())) {
            BFrame f = new BFrame();
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            f.setBounds(new Rectangle(0, 0, d.width, d.height));
            UIUtilities.centerWindow((WindowWidget)f);
            new PreferencesWindow(f);
            f.dispose();
        } else if ("handleQuit".equals(method.getName())) {
            ModellingApp.quit();
            handled = false;
        } else if ("handleOpenFile".equals(method.getName())) {
            try {
                Method getFilename = args[0].getClass().getMethod("getFilename", new Class[0]);
                String path = (String)getFilename.invoke(args[0], new Object[0]);
                ModellingApp.newWindow((Scene)new Scene(new File(path), true));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            return null;
        }
        try {
            Method setHandled = args[0].getClass().getMethod("setHandled", Boolean.TYPE);
            setHandled.invoke(args[0], handled);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private class MacMenuBarWindow
    extends BFrame
    implements EditingWindow {
        public MacMenuBarWindow() {
            ((JFrame)this.getComponent()).setUndecorated(true);
            this.setBackground(new Color(0, 0, 0, 0));
            BMenuBar menubar = new BMenuBar();
            this.setMenuBar(menubar);
            BMenu file = Translate.menu((String)"file");
            menubar.add(file);
            file.add((MenuWidget)Translate.menuItem((String)"new", (Object)((Object)this), (String)"actionPerformed"));
            file.add((MenuWidget)Translate.menuItem((String)"open", (Object)((Object)this), (String)"actionPerformed"));
            final BMenu recentMenu = Translate.menu((String)"openRecent");
            RecentFiles.createMenu((BMenu)recentMenu);
            file.add((MenuWidget)recentMenu);
            Preferences.userNodeForPackage(class$artofillusion$RecentFiles == null ? (class$artofillusion$RecentFiles = MacOSPlugin.class$("artofillusion.RecentFiles")) : class$artofillusion$RecentFiles).addPreferenceChangeListener(new PreferenceChangeListener(){

                public void preferenceChange(PreferenceChangeEvent ev) {
                    RecentFiles.createMenu((BMenu)recentMenu);
                }
            });
            this.pack();
            this.setBounds(new Rectangle(-1000, -1000, 0, 0));
            this.setVisible(true);
        }

        public ToolPalette getToolPalette() {
            return null;
        }

        public void setTool(EditingTool tool) {
        }

        public void setHelpText(String text) {
        }

        public BFrame getFrame() {
            return this;
        }

        public void updateImage() {
        }

        public void updateMenus() {
        }

        public void setUndoRecord(UndoRecord command) {
        }

        public void setModified() {
        }

        public Scene getScene() {
            return null;
        }

        public ViewerCanvas getView() {
            return null;
        }

        public boolean confirmClose() {
            this.dispose();
            return true;
        }

        private void actionPerformed(CommandEvent ev) {
            String command = ev.getActionCommand();
            if (command.equals("new")) {
                ModellingApp.newWindow();
            } else if (command.equals("open")) {
                ModellingApp.openScene((BFrame)this);
            } else if (command.equals("quit")) {
                ModellingApp.quit();
            }
        }
    }
}

