/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.util;

public class ThreadManager {
    private int numIndices;
    private int nextIndex;
    private int numWaiting;
    private Thread[] thread;
    private Task task;
    private Object controller;
    private boolean controllerWaiting;

    public ThreadManager() {
        this(0, null);
    }

    public ThreadManager(int numIndices, Task task) {
        this.numIndices = numIndices;
        this.task = task;
        this.nextIndex = numIndices;
        this.controller = new Object();
        this.controllerWaiting = false;
    }

    private void createThreads() {
        this.thread = new Thread[Runtime.getRuntime().availableProcessors()];
        for (int i = 0; i < this.thread.length; ++i) {
            this.thread[i] = new Thread("Worker thread " + (i + 1)){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                int index = ThreadManager.this.nextIndex();
                                ThreadManager.this.task.execute(index);
                            }
                        }
                        catch (InterruptedException ex) {
                            ThreadManager.this.task.cleanup();
                            return;
                        }
                        catch (Exception ex) {
                            ThreadManager.this.cancel();
                            ex.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            this.thread[i].start();
        }
    }

    public synchronized void setNumIndices(int numIndices) {
        this.numIndices = numIndices;
        this.nextIndex = numIndices;
    }

    public synchronized void setTask(Task task) {
        this.task = task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this;
        synchronized (object) {
            this.controllerWaiting = false;
            this.nextIndex = 0;
            this.numWaiting = 0;
        }
        if (this.thread == null) {
            this.createThreads();
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
        object = this.controller;
        synchronized (object) {
            try {
                this.controllerWaiting = true;
                this.controller.wait();
            }
            catch (InterruptedException ex) {
                this.finish();
            }
        }
    }

    public synchronized void cancel() {
        this.nextIndex = this.numIndices;
    }

    public void finish() {
        if (this.thread != null) {
            if (this.thread.length > 1) {
                for (int i = 0; i < this.thread.length; ++i) {
                    this.thread[i].interrupt();
                }
            } else {
                this.task.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int nextIndex() throws InterruptedException {
        while (this.nextIndex >= this.numIndices) {
            ++this.numWaiting;
            if (this.numWaiting == this.thread.length) {
                while (!this.controllerWaiting) {
                    this.wait(1L);
                }
                Object object = this.controller;
                synchronized (object) {
                    this.controller.notify();
                }
            }
            this.wait();
        }
        return this.nextIndex++;
    }

    public static interface Task {
        public void execute(int var1);

        public void cleanup();
    }
}

