/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ui.InfiniteDragListener;
import artofillusion.ui.ValueChecker;
import artofillusion.ui.ValueField;
import buoy.event.MouseDraggedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.event.RepaintEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WidgetEvent;
import buoy.widget.CustomWidget;
import buoy.widget.RowContainer;
import buoy.xml.IconResource;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class ValueSelector
extends RowContainer {
    private final ValueField field;
    private final CustomWidget adjuster;
    private double minimum;
    private double maximum;
    private double increment;
    private int lastX;
    private final InfiniteDragListener drag;
    private static Cursor BLANK_CURSOR;
    private static Icon DIAL_IMAGE;
    private static Icon KNOB_IMAGE;

    public ValueSelector(double value, double min, double max, double increment) {
        this.minimum = min;
        this.maximum = max;
        this.increment = increment;
        this.field = new ValueField(value, 0);
        this.add(this.field);
        this.field.setValueChecker(new ValueChecker(){

            public boolean isValid(double val) {
                return val >= ValueSelector.this.minimum && val <= ValueSelector.this.maximum;
            }
        });
        this.field.addEventLink(ValueChangedEvent.class, (Object)this, "dispatchValueChanged");
        this.adjuster = new CustomWidget();
        this.adjuster.addEventLink(RepaintEvent.class, (Object)this, "paintDial");
        this.adjuster.setPreferredSize(new Dimension(DIAL_IMAGE.getIconWidth(), DIAL_IMAGE.getIconHeight()));
        this.add(this.adjuster);
        this.drag = new InfiniteDragListener(this.adjuster);
        this.drag.addEventLink(MousePressedEvent.class, (Object)this, "mousePressed");
        this.drag.addEventLink(MouseDraggedEvent.class, (Object)this, "mouseDragged");
        this.drag.addEventLink(MouseReleasedEvent.class, (Object)this, "mouseReleased");
    }

    public double getValue() {
        return this.field.getValue();
    }

    public void setValue(double value) {
        this.field.setValue(value);
        this.adjuster.repaint();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.field.setEnabled(enabled);
        this.drag.setEnabled(enabled);
    }

    private void mousePressed(MousePressedEvent ev) {
        this.lastX = ev.getX();
        this.setCursor(BLANK_CURSOR);
    }

    private void mouseDragged(MouseDraggedEvent ev) {
        if (Double.isNaN(this.field.getValue())) {
            return;
        }
        double scale = ev.isAltDown() ? 10.0 : 1.0;
        double value = this.field.getValue() + scale * this.increment * (double)(ev.getX() - this.lastX);
        if (value < this.minimum) {
            value = this.minimum;
        }
        if (value > this.maximum) {
            value = this.maximum;
        }
        this.field.setValue(value);
        this.lastX = ev.getX();
        this.dispatchValueChanged(ev);
        this.adjuster.repaint();
    }

    private void mouseReleased(MouseReleasedEvent ev) {
        this.setCursor(null);
        if (!Double.isNaN(this.field.getValue())) {
            this.dispatchValueChanged(ev);
        }
    }

    private void dispatchValueChanged(WidgetEvent originalEvent) {
        if (originalEvent.getWidget() == this.field) {
            this.adjuster.repaint();
        }
        this.dispatchEvent(new ValueChangedEvent(this, originalEvent instanceof MouseDraggedEvent));
    }

    private void paintDial(RepaintEvent ev) {
        DIAL_IMAGE.paintIcon(this.adjuster.getComponent(), ev.getGraphics(), 0, 0);
        if (!Double.isNaN(this.field.getValue()) && this.isEnabled()) {
            double angle = 0.015707963267948967 * this.field.getValue() / this.increment;
            int x = 8 + (int)Math.round(4.0 * Math.sin(angle));
            int y = 8 - (int)Math.round(4.0 * Math.cos(angle));
            KNOB_IMAGE.paintIcon(this.adjuster.getComponent(), ev.getGraphics(), x, y);
        }
    }

    static {
        try {
            BufferedImage image = new BufferedImage(1, 1, 3);
            BLANK_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(), "");
            DIAL_IMAGE = new IconResource("artofillusion/Icons/dial.png");
            KNOB_IMAGE = new IconResource("artofillusion/Icons/dialKnob.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

