/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ui.ValueChecker;
import buoy.widget.BTextField;
import java.awt.Color;
import javax.swing.JTextField;

public class ValueField
extends BTextField {
    private double value = Double.NaN;
    private int constraints;
    private int decimalPlaces = 3;
    private boolean validEventsOnly = true;
    private ValueChecker check;
    public static final int NONE = 0;
    public static final int NONNEGATIVE = 1;
    public static final int NONZERO = 2;
    public static final int POSITIVE = 3;
    public static final int INTEGER = 4;

    public ValueField(double value, int constraints) {
        this(value, constraints, 5);
    }

    public ValueField(float value, int constraints) {
        this((double)value, constraints, 5);
    }

    public ValueField(float value, int constraints, int columns) {
        this((double)value, constraints, columns);
    }

    public ValueField(double value, int constraints, int columns) {
        super(columns);
        this.constraints = constraints;
        this.setValue(value);
    }

    public void setValueChecker(ValueChecker vc) {
        this.check = vc;
    }

    public ValueChecker getValueChecker() {
        return this.check;
    }

    public boolean isTextValid() {
        double val = this.value;
        try {
            val = (this.constraints & 4) != 0 ? (double)Integer.parseInt(this.getText()) : new Double(this.getText());
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return this.isValid(val);
    }

    public boolean isValid(double val) {
        if (val < 0.0 && (this.constraints & 1) != 0) {
            return false;
        }
        if (val == 0.0 && (this.constraints & 2) != 0) {
            return false;
        }
        return this.check == null || this.check.isValid(val);
    }

    public void checkIfValid() {
        this.setTextColor(this.isValid(this.value));
    }

    private void setTextColor(boolean valid) {
        ((JTextField)this.getComponent()).setForeground(valid ? Color.black : Color.red);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void textChanged() {
        boolean suppress;
        double val = this.value;
        double oldVal = this.value;
        try {
            val = (this.constraints & 4) != 0 ? (double)Integer.parseInt(this.getText()) : new Double(this.getText());
        }
        catch (NumberFormatException ex) {
            this.setTextColor(false);
            return;
        }
        if (!this.isTextValid()) {
            this.setTextColor(false);
            suppress = this.validEventsOnly;
        } else {
            this.value = val;
            this.setTextColor(true);
            suppress = val == oldVal;
        }
        try {
            if (suppress) {
                ++this.suppressEvents;
            }
            super.textChanged();
        }
        finally {
            if (suppress) {
                --this.suppressEvents;
            }
        }
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double val) {
        if (val == this.value) {
            return;
        }
        String text = this.convertNumberToString(val);
        if (text.equals(this.convertNumberToString(this.value))) {
            return;
        }
        this.value = val;
        this.setText(text);
    }

    private String convertNumberToString(double val) {
        if (Double.isNaN(val)) {
            return "";
        }
        if ((this.constraints & 4) != 0) {
            return Integer.toString((int)val);
        }
        if (val == 0.0 || val == -0.0) {
            return "0.0";
        }
        int digits = (int)Math.floor(Math.log(Math.abs(val)) / Math.log(10.0));
        double scale = Math.pow(10.0, digits < 0 ? (double)(this.decimalPlaces - 1 - digits) : (double)this.decimalPlaces);
        return Double.toString((double)Math.round(val * scale) / scale);
    }

    public void setMinDecimalPlaces(int decimals) {
        this.decimalPlaces = decimals;
    }

    public void sendValidEventsOnly(boolean validOnly) {
        this.validEventsOnly = validOnly;
    }
}

