/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.PluginRegistry;
import artofillusion.ViewerCanvas;
import artofillusion.math.RGBColor;
import artofillusion.ui.ToolButton;
import artofillusion.ui.Translate;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ThemeManager {
    private static ThemeInfo selectedTheme;
    private static ThemeInfo defaultTheme;
    private static ColorSet selectedColorSet;
    private static ThemeInfo[] themeList;
    private static Map themeIdMap;
    private static DocumentBuilderFactory documentBuilderFactory;
    static /* synthetic */ Class class$artofillusion$ui$DefaultToolButton;
    static /* synthetic */ Class class$org$w3c$dom$Node;

    public static ThemeInfo getSelectedTheme() {
        return selectedTheme;
    }

    public static void setSelectedTheme(ThemeInfo theme) {
        selectedTheme = theme;
        ThemeManager.setSelectedColorSet(theme.colorSets[0]);
        ThemeManager.applyButtonProperties();
    }

    public static ColorSet getSelectedColorSet() {
        return selectedColorSet;
    }

    public static void setSelectedColorSet(ColorSet colorSet) {
        selectedColorSet = colorSet;
        ThemeManager.applyThemeColors();
    }

    public static List getThemes() {
        return Collections.unmodifiableList(Arrays.asList(themeList));
    }

    public static ThemeInfo getDefaultTheme() {
        return defaultTheme;
    }

    private static void applyThemeColors() {
        ColorSet set = selectedColorSet;
        ViewerCanvas.backgroundColor = new Color(set.viewerBackground.getRed(), set.viewerBackground.getGreen(), set.viewerBackground.getBlue());
        ViewerCanvas.lineColor = new Color(set.viewerLine.getRed(), set.viewerLine.getGreen(), set.viewerLine.getBlue());
        ViewerCanvas.handleColor = new Color(set.viewerHandle.getRed(), set.viewerHandle.getGreen(), set.viewerHandle.getBlue());
        ViewerCanvas.highlightColor = new Color(set.viewerHighlight.getRed(), set.viewerHighlight.getGreen(), set.viewerHighlight.getBlue());
        ViewerCanvas.specialHighlightColor = new Color(set.viewerSpecialHighlight.getRed(), set.viewerSpecialHighlight.getGreen(), set.viewerSpecialHighlight.getBlue());
        ViewerCanvas.disabledColor = new Color(set.viewerDisabled.getRed(), set.viewerDisabled.getGreen(), set.viewerDisabled.getBlue());
        Color viewerSurface = new Color(set.viewerSurface.getRed(), set.viewerSurface.getGreen(), set.viewerSurface.getBlue());
        Color viewerTransparent = new Color(set.viewerTransparent.getRed(), set.viewerTransparent.getGreen(), set.viewerTransparent.getBlue());
        ViewerCanvas.surfaceColor = viewerSurface;
        ViewerCanvas.surfaceRGBColor = new RGBColor((double)viewerSurface.getRed() / 255.0, (double)viewerSurface.getGreen() / 255.0, (double)viewerSurface.getBlue() / 255.0);
        ViewerCanvas.transparentColor = new RGBColor((double)viewerTransparent.getRed() / 255.0, (double)viewerTransparent.getGreen() / 255.0, (double)viewerTransparent.getBlue() / 255.0);
    }

    private static void applyButtonProperties() {
        if (ThemeManager.selectedTheme.buttonProperties != null) {
            Class buttonClass = ThemeManager.selectedTheme.buttonClass;
            try {
                Method m = buttonClass.getMethod("setProperties", Object.class);
                m.invoke((Object)buttonClass, ThemeManager.selectedTheme.buttonProperties);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private static URL getIconURL(String name) {
        ThemeInfo source = selectedTheme;
        ThemeInfo defaultSource = defaultTheme;
        int colon = name.indexOf(58);
        if (colon > -1) {
            defaultSource = (ThemeInfo)themeIdMap.get(name.substring(0, colon));
            name = name.substring(colon + 1);
        }
        URL url = null;
        url = source.resource.getClassLoader().getResource(source.pathRoot + name + ".png");
        if (url == null) {
            url = source.resource.getClassLoader().getResource(source.pathRoot + name + ".gif");
        }
        if (url == null && defaultSource != null) {
            url = defaultSource.resource.getClassLoader().getResource(defaultSource.pathRoot + name + ".png");
        }
        if (url == null && defaultSource != null) {
            url = defaultSource.resource.getClassLoader().getResource(defaultSource.pathRoot + name + ".gif");
        }
        return url;
    }

    public static ToolButton getToolButton(Object owner, String iconName, String selectedIconName) {
        Class buttonClass = ThemeManager.selectedTheme.buttonClass;
        try {
            Constructor contructor = buttonClass.getConstructor(Object.class, String.class, String.class);
            return (ToolButton)contructor.newInstance(owner, iconName, selectedIconName);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static ImageIcon getIcon(String iconName) {
        URL url = ThemeManager.getIconURL(iconName);
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    public static Color getAppBackgroundColor() {
        return ThemeManager.selectedColorSet.appBackground;
    }

    public static Color getPaletteBackgroundColor() {
        return ThemeManager.selectedColorSet.paletteBackground;
    }

    public static Color getDockableBarColor1() {
        return ThemeManager.selectedColorSet.dockableBarColor1;
    }

    public static Color getDockableBarColor2() {
        return ThemeManager.selectedColorSet.dockableBarColor2;
    }

    public static Color getDockableTitleColor() {
        return ThemeManager.selectedColorSet.dockableTitleColor;
    }

    public static Color getTextColor() {
        return ThemeManager.selectedColorSet.textColor;
    }

    public static void initThemes() {
        int i;
        if (themeList != null) {
            throw new IllegalStateException("The themes have already been initialized.");
        }
        themeIdMap = new HashMap();
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        List resources = PluginRegistry.getResources("UITheme");
        ArrayList<ThemeInfo> list = new ArrayList<ThemeInfo>();
        for (i = 0; i < resources.size(); ++i) {
            try {
                ThemeInfo themeInfo = new ThemeInfo((PluginRegistry.PluginResource)resources.get(i));
                list.add(themeInfo);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        themeList = list.toArray(new ThemeInfo[list.size()]);
        for (i = 0; i < themeList.length; ++i) {
            themeIdMap.put(ThemeManager.themeList[i].resource.getId(), themeList[i]);
        }
        defaultTheme = (ThemeInfo)themeIdMap.get("default");
        ThemeManager.setSelectedTheme(defaultTheme);
    }

    private static int getIntegerValueFromNode(Node node) {
        String s;
        if (node != null && (s = ThemeManager.getAttribute(node, "value")) != null) {
            return Integer.parseInt(s);
        }
        return 0;
    }

    private static Color getColorFromNode(Node node) {
        if (node == null) {
            return new Color(0, 0, 0);
        }
        String s = ThemeManager.getAttribute(node, "R");
        int r = 0;
        if (s != null) {
            r = Integer.valueOf(s);
        }
        int g = 0;
        s = ThemeManager.getAttribute(node, "G");
        if (s != null) {
            g = Integer.valueOf(s);
        }
        int b = 0;
        s = ThemeManager.getAttribute(node, "B");
        if (s != null) {
            b = Integer.valueOf(s);
        }
        return new Color(r, g, b);
    }

    public static int getPaletteMargin() {
        return ThemeManager.selectedTheme.paletteMargin;
    }

    public static int getButtonMargin() {
        return ThemeManager.selectedTheme.buttonMargin;
    }

    private static Node getNodeFromNodeList(NodeList nl, String nodeName) {
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals(nodeName)) continue;
            return n;
        }
        return null;
    }

    private static String getAttribute(Node node, String name) {
        NamedNodeMap nm = node.getAttributes();
        if (nm == null) {
            return null;
        }
        Node nn = nm.getNamedItem(name);
        if (nn == null) {
            return null;
        }
        return nn.getNodeValue();
    }

    public static class ThemeInfo {
        private final String name;
        public final String author;
        public final String description;
        public final Class buttonClass;
        public final Object buttonProperties;
        public final int buttonMargin;
        public final int paletteMargin;
        private final ColorSet[] colorSets;
        public final boolean classicToolBarButtons;
        public final PluginRegistry.PluginResource resource;
        public final String pathRoot;
        public final boolean selectable;

        private ThemeInfo(PluginRegistry.PluginResource resource) throws IOException, SAXException, ParserConfigurationException {
            int i;
            InputStream is = resource.getInputStream();
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            Document document = builder.parse(is);
            is.close();
            Element rootNode = document.getDocumentElement();
            NodeList themeNodeList = rootNode.getChildNodes();
            this.resource = resource;
            String root = resource.getName();
            root = root.lastIndexOf(47) > -1 ? root.substring(0, root.lastIndexOf(47) + 1) : "";
            this.pathRoot = root;
            Node node = ThemeManager.getNodeFromNodeList(themeNodeList, "name");
            this.name = node != null ? node.getFirstChild().getNodeValue() : "";
            node = ThemeManager.getNodeFromNodeList(themeNodeList, "author");
            this.author = node != null ? node.getFirstChild().getNodeValue() : "";
            node = ThemeManager.getNodeFromNodeList(themeNodeList, "description");
            this.description = node != null ? node.getFirstChild().getNodeValue() : "";
            node = ThemeManager.getNodeFromNodeList(themeNodeList, "selectable");
            this.selectable = node != null ? Boolean.valueOf(node.getFirstChild().getNodeValue()) : true;
            node = ThemeManager.getNodeFromNodeList(themeNodeList, "button");
            if (node != null) {
                String className = ThemeManager.getAttribute(node, "class");
                Object properties = null;
                Class cls = class$artofillusion$ui$DefaultToolButton == null ? (class$artofillusion$ui$DefaultToolButton = ThemeManager.class$("artofillusion.ui.DefaultToolButton")) : class$artofillusion$ui$DefaultToolButton;
                try {
                    cls = resource.getClassLoader().loadClass(className);
                    Method m = cls.getMethod("readPropertiesFromXMLNode", class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = ThemeManager.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node);
                    properties = m.invoke((Object)className, node);
                }
                catch (NoSuchMethodException ex) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.buttonClass = cls;
                this.buttonProperties = properties;
                String s = ThemeManager.getAttribute(node, "useintoolbars");
                this.classicToolBarButtons = s != null ? !Boolean.valueOf(s).booleanValue() : false;
            } else {
                this.buttonClass = class$artofillusion$ui$DefaultToolButton == null ? (class$artofillusion$ui$DefaultToolButton = ThemeManager.class$("artofillusion.ui.DefaultToolButton")) : class$artofillusion$ui$DefaultToolButton;
                this.buttonProperties = null;
                this.classicToolBarButtons = false;
            }
            node = ThemeManager.getNodeFromNodeList(themeNodeList, "palettemargin");
            this.paletteMargin = ThemeManager.getIntegerValueFromNode(node);
            node = ThemeManager.getNodeFromNodeList(themeNodeList, "buttonmargin");
            this.buttonMargin = ThemeManager.getIntegerValueFromNode(node);
            int count = 0;
            for (i = 0; i < themeNodeList.getLength(); ++i) {
                node = themeNodeList.item(i);
                if (node.getNodeName() != "colorset") continue;
                ++count;
            }
            this.colorSets = new ColorSet[count];
            count = 0;
            for (i = 0; i < themeNodeList.getLength(); ++i) {
                node = themeNodeList.item(i);
                if (node.getNodeName() != "colorset") continue;
                this.colorSets[count++] = new ColorSet(node);
            }
        }

        public String getName() {
            return Translate.text(this.name);
        }

        public ColorSet[] getColorSets() {
            return (ColorSet[])this.colorSets.clone();
        }
    }

    public static class ColorSet {
        public final Color appBackground;
        public final Color paletteBackground;
        public final Color viewerBackground;
        public final Color viewerLine;
        public final Color viewerHandle;
        public final Color viewerHighlight;
        public final Color viewerSpecialHighlight;
        public final Color viewerDisabled;
        public final Color viewerSurface;
        public final Color viewerTransparent;
        public final Color dockableBarColor1;
        public final Color dockableBarColor2;
        public final Color dockableTitleColor;
        public final Color textColor;
        private final String name;

        private ColorSet(Node node) {
            this.name = ThemeManager.getAttribute(node, "name");
            NodeList list = node.getChildNodes();
            node = ThemeManager.getNodeFromNodeList(list, "applicationbackground");
            this.appBackground = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "palettebackground");
            this.paletteBackground = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "viewerbackground");
            this.viewerBackground = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "viewerline");
            this.viewerLine = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "viewerhandle");
            this.viewerHandle = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "viewerhighlight");
            this.viewerHighlight = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "viewerspecialhighlight");
            this.viewerSpecialHighlight = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "viewerdisabled");
            this.viewerDisabled = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "viewersurface");
            this.viewerSurface = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "viewertransparent");
            this.viewerTransparent = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "dockablebarcolor1");
            this.dockableBarColor1 = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "dockablebarcolor2");
            this.dockableBarColor2 = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "dockabletitlecolor");
            this.dockableTitleColor = ThemeManager.getColorFromNode(node);
            node = ThemeManager.getNodeFromNodeList(list, "textcolor");
            this.textColor = ThemeManager.getColorFromNode(node);
        }

        public String getName() {
            return Translate.text(this.name);
        }
    }
}

