/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.script;

import buoy.event.KeyTypedEvent;
import buoy.widget.BOutline;
import buoy.widget.BScrollPane;
import buoy.widget.BTextArea;
import buoy.widget.WidgetContainer;
import java.awt.Font;

public class ScriptEditor
extends BTextArea {
    public ScriptEditor(String text) {
        super(text, 25, 80);
        this.setFont(new Font("Monospaced", 0, 11));
        this.setTabSize(2);
        this.addEventLink(KeyTypedEvent.class, (Object)this, "keyTyped");
    }

    public WidgetContainer createContainer() {
        BScrollPane sp = new BScrollPane(this, BScrollPane.SCROLLBAR_ALWAYS, BScrollPane.SCROLLBAR_ALWAYS);
        return BOutline.createBevelBorder(sp, false);
    }

    private void keyTyped(KeyTypedEvent e) {
        char c;
        boolean extraIndent;
        int pos;
        if (e.getKeyChar() != '\r' && e.getKeyChar() != '\n') {
            return;
        }
        String text = this.getText();
        int endWhiteSpace = pos = this.getCaretPosition() - 1;
        int startLine = pos;
        boolean bl = extraIndent = startLine > 0 && text.charAt(startLine - 1) == '{';
        while (startLine > 0 && (c = text.charAt(startLine - 1)) != '\r' && c != '\n') {
            --startLine;
            if (Character.isWhitespace(c)) continue;
            endWhiteSpace = startLine;
        }
        String insert = text.substring(startLine, endWhiteSpace);
        if (extraIndent) {
            insert = insert + "\t";
        }
        this.insert(insert, pos + 1);
    }
}

