/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.procedural.AbsModule;
import artofillusion.procedural.Arg;
import artofillusion.procedural.BiasModule;
import artofillusion.procedural.CosineModule;
import artofillusion.procedural.ExpModule;
import artofillusion.procedural.GainModule;
import artofillusion.procedural.LogModule;
import artofillusion.procedural.MaxModule;
import artofillusion.procedural.MinModule;
import artofillusion.procedural.OPort;
import artofillusion.procedural.PolarModule;
import artofillusion.procedural.PowerModule;
import artofillusion.procedural.SineModule;
import artofillusion.procedural.SqrtModule;
import java.awt.Point;
import java.util.Hashtable;

class Token {
    public static final char FUNCTION = '&';
    public static final char VARIABLE = '$';
    public static final char NUMBER = '#';
    public static final char END = '@';
    public static final char PLUS = '+';
    public static final char MINUS = '-';
    public static final char MUL = '*';
    public static final char EXP = '^';
    public static final char DIV = '/';
    public static final char MOD = '%';
    public static final char RET = ';';
    public static final char ASSIGN = '=';
    public static final char LP = '(';
    public static final char RP = ')';
    public static final char COMMA = ',';
    public String strValue;
    public double numValue;
    public char ty;
    static Hashtable funMap = Token.createFunMap();

    static Hashtable createFunMap() {
        Hashtable<String, OPort> fm = new Hashtable<String, OPort>();
        fm.put("sin", new OPort(new SineModule(new Point()), 0));
        fm.put("cos", new OPort(new CosineModule(new Point()), 0));
        fm.put("sqrt", new OPort(new SqrtModule(new Point()), 0));
        fm.put("pow", new OPort(new PowerModule(new Point()), 0, new Arg[]{new Arg("Base", 1), new Arg("Exponent", 0)}));
        fm.put("log", new OPort(new LogModule(new Point()), 0));
        fm.put("angle", new OPort(new PolarModule(new Point()), 1, new Arg[]{new Arg("X", 0), new Arg("Y", 1)}));
        fm.put("min", new OPort(new MinModule(new Point()), 0, new Arg[]{new Arg("Value 1", 1), new Arg("Value 2", 0)}));
        fm.put("max", new OPort(new MaxModule(new Point()), 0, new Arg[]{new Arg("Value 1", 1), new Arg("Value 2", 0)}));
        fm.put("abs", new OPort(new AbsModule(new Point()), 0));
        fm.put("exp", new OPort(new ExpModule(new Point()), 0));
        fm.put("bias", new OPort(new BiasModule(new Point()), 0, new Arg[]{new Arg("Input", 1), new Arg("Bias", 0)}));
        fm.put("gain", new OPort(new GainModule(new Point()), 0, new Arg[]{new Arg("Input", 1), new Arg("Gain", 0)}));
        return fm;
    }

    public Token(char c) {
        this.ty = c;
    }

    public boolean equals(char c) {
        return this.ty == c;
    }

    public String toString() {
        return "type: " + this.ty + " strValue: " + this.strValue + " numValue: " + this.numValue;
    }

    public String getDescription() {
        if (this.ty == '@') {
            return "end of expression";
        }
        return new Character(this.ty).toString();
    }
}

