/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.procedural.AbsModule;
import artofillusion.procedural.BiasModule;
import artofillusion.procedural.BlendModule;
import artofillusion.procedural.BlurModule;
import artofillusion.procedural.BrickModule;
import artofillusion.procedural.CellsModule;
import artofillusion.procedural.CheckerModule;
import artofillusion.procedural.ClipModule;
import artofillusion.procedural.ColorDarkenModule;
import artofillusion.procedural.ColorDifferenceModule;
import artofillusion.procedural.ColorLightenModule;
import artofillusion.procedural.ColorModule;
import artofillusion.procedural.ColorProductModule;
import artofillusion.procedural.ColorScaleModule;
import artofillusion.procedural.ColorSumModule;
import artofillusion.procedural.CommentModule;
import artofillusion.procedural.CompareModule;
import artofillusion.procedural.CoordinateModule;
import artofillusion.procedural.CosineModule;
import artofillusion.procedural.DifferenceModule;
import artofillusion.procedural.ExpModule;
import artofillusion.procedural.ExprModule;
import artofillusion.procedural.FunctionModule;
import artofillusion.procedural.GainModule;
import artofillusion.procedural.GridModule;
import artofillusion.procedural.HLSModule;
import artofillusion.procedural.HSVModule;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.ImageModule;
import artofillusion.procedural.InfoBox;
import artofillusion.procedural.InterpModule;
import artofillusion.procedural.JitterModule;
import artofillusion.procedural.Link;
import artofillusion.procedural.LogModule;
import artofillusion.procedural.MarbleModule;
import artofillusion.procedural.MaxModule;
import artofillusion.procedural.MinModule;
import artofillusion.procedural.ModModule;
import artofillusion.procedural.Module;
import artofillusion.procedural.NoiseModule;
import artofillusion.procedural.NumberModule;
import artofillusion.procedural.OutputModule;
import artofillusion.procedural.ParameterModule;
import artofillusion.procedural.PolarModule;
import artofillusion.procedural.PowerModule;
import artofillusion.procedural.Procedure;
import artofillusion.procedural.ProcedureOwner;
import artofillusion.procedural.ProductModule;
import artofillusion.procedural.RGBModule;
import artofillusion.procedural.RandomModule;
import artofillusion.procedural.RatioModule;
import artofillusion.procedural.ScaleShiftModule;
import artofillusion.procedural.SineModule;
import artofillusion.procedural.SpectrumModule;
import artofillusion.procedural.SphericalModule;
import artofillusion.procedural.SqrtModule;
import artofillusion.procedural.SumModule;
import artofillusion.procedural.TransformModule;
import artofillusion.procedural.TurbulenceModule;
import artofillusion.procedural.ViewAngleModule;
import artofillusion.procedural.WoodModule;
import artofillusion.ui.AutoScroller;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import buoy.event.CommandEvent;
import buoy.event.KeyPressedEvent;
import buoy.event.MouseClickedEvent;
import buoy.event.MouseDraggedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.event.RepaintEvent;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BMenu;
import buoy.widget.BMenuBar;
import buoy.widget.BMenuItem;
import buoy.widget.BScrollPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BTextField;
import buoy.widget.BorderContainer;
import buoy.widget.CustomWidget;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;

public class ProcedureEditor
extends CustomWidget {
    private BFrame parent;
    private Procedure proc;
    private ProcedureOwner owner;
    private Scene theScene;
    private EditingWindow win;
    private Dimension size;
    private BMenuItem undoItem;
    private BMenuItem cutItem;
    private BMenuItem copyItem;
    private BMenuItem pasteItem;
    private BMenuItem clearItem;
    private BTextField nameField;
    private boolean[] selectedModule;
    private boolean[] selectedLink;
    private boolean draggingLink;
    private boolean draggingModule;
    private boolean draggingBox;
    private boolean undoIsRedo;
    private Point clickPos;
    private Point lastPos;
    private InfoBox inputInfo;
    private InfoBox outputInfo;
    private IOPort dragFromPort;
    private IOPort dragToPort;
    private BScrollPane scroll;
    private Object preview;
    private ByteArrayOutputStream undoBuffer;
    private ByteArrayOutputStream cancelBuffer;
    private final Color darkLinkColor = Color.darkGray;
    private final Color blueLinkColor = new Color(40, 40, 255);
    private final Color selectedLinkColor = new Color(255, 50, 50);
    private final Color outputBackgroundColor = new Color(210, 210, 240);
    private static final float BEZIER_HARDNESS = 0.5f;
    private static final Stroke normal = new BasicStroke();
    private static final Stroke bold = new BasicStroke(1.5f, 1, 1);
    private static ClipboardSelection clipboard;
    static /* synthetic */ Class class$buoy$event$CommandEvent;

    public ProcedureEditor(Procedure proc, ProcedureOwner owner, Scene scene) {
        int i;
        this.proc = proc;
        this.owner = owner;
        this.theScene = scene;
        this.selectedModule = new boolean[proc.getModules().length];
        this.selectedLink = new boolean[proc.getLinks().length];
        this.inputInfo = new InfoBox();
        this.outputInfo = new InfoBox();
        this.undoBuffer = new ByteArrayOutputStream();
        this.cancelBuffer = new ByteArrayOutputStream();
        this.parent = new BFrame(owner.getWindowTitle());
        BorderContainer content = new BorderContainer();
        this.parent.setContent(content);
        this.scroll = new BScrollPane(this);
        content.add(this.scroll, BorderContainer.CENTER);
        this.scroll.setPreferredViewSize(new Dimension(500, 550));
        new AutoScroller(this.scroll, 5, 5);
        this.size = new Dimension(1000, 1000);
        this.setBackground(Color.white);
        this.addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
        this.addEventLink(MousePressedEvent.class, (Object)this, "mousePressed");
        this.addEventLink(MouseReleasedEvent.class, (Object)this, "mouseReleased");
        this.addEventLink(MouseClickedEvent.class, (Object)this, "mouseClicked");
        this.addEventLink(MouseDraggedEvent.class, (Object)this, "mouseDragged");
        this.addEventLink(RepaintEvent.class, (Object)this, "paint");
        DataOutputStream out = new DataOutputStream(this.cancelBuffer);
        try {
            proc.writeToStream(out, this.theScene);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        FormContainer top = new FormContainer(new double[]{0.0, 1.0, 0.0, 0.0}, new double[]{1.0});
        top.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(0, 0, 0, 5), null));
        if (owner.canEditName()) {
            top.add(new BLabel(Translate.text("Name") + ':'), 0, 0);
            this.nameField = new BTextField(owner.getName());
            top.add(this.nameField, 1, 0);
        }
        top.add(Translate.button("ok", this, "actionPerformed"), 2, 0);
        top.add(Translate.button("cancel", this, "actionPerformed"), 3, 0);
        content.add(top, BorderContainer.NORTH);
        OutputModule[] output = proc.getOutputModules();
        int widest = 0;
        for (i = 0; i < output.length; ++i) {
            output[i].calcSize();
            if (output[i].getBounds().width <= widest) continue;
            widest = output[i].getBounds().width;
        }
        int x = this.size.width - widest;
        int y = 15;
        for (i = 0; i < output.length; ++i) {
            output[i].setWidth(widest);
            output[i].setPosition(x - 15, y);
            y += output[i].getBounds().height + 15;
        }
        BMenuBar mb = new BMenuBar();
        this.parent.setMenuBar(mb);
        mb.add(this.getEditMenu());
        mb.add(this.getInsertMenu());
        this.updateMenus();
        this.parent.pack();
        this.scroll.getHorizontalScrollBar().setBlockIncrement(100);
        this.scroll.getVerticalScrollBar().setBlockIncrement(100);
        this.scroll.getHorizontalScrollBar().setUnitIncrement(10);
        this.scroll.getVerticalScrollBar().setUnitIncrement(10);
        this.parent.setVisible(true);
        this.scroll.getHorizontalScrollBar().setValue(this.getBounds().width - this.scroll.getViewSize().width);
        this.preview = owner.getPreview(this);
    }

    private BMenu getEditMenu() {
        BMenu editMenu = Translate.menu("edit");
        this.undoItem = Translate.menuItem("undo", this, "actionPerformed");
        editMenu.add(this.undoItem);
        this.undoItem.setEnabled(false);
        editMenu.addSeparator();
        this.cutItem = Translate.menuItem("cut", this, "actionPerformed");
        editMenu.add(this.cutItem);
        this.copyItem = Translate.menuItem("copy", this, "actionPerformed");
        editMenu.add(this.copyItem);
        this.pasteItem = Translate.menuItem("paste", this, "actionPerformed");
        editMenu.add(this.pasteItem);
        this.clearItem = Translate.menuItem("clear", this, "actionPerformed");
        editMenu.add(this.clearItem);
        editMenu.addSeparator();
        editMenu.add(Translate.menuItem("properties", this, "actionPerformed"));
        return editMenu;
    }

    private BMenu getInsertMenu() {
        BMenu insertMenu = Translate.menu("insert");
        BMenu subMenu = Translate.menu("values");
        insertMenu.add(subMenu);
        subMenu.add(Translate.menuItem("numberModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("colorModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("xModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("yModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("zModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("timeModule", this, "actionPerformed"));
        if (this.owner.allowViewAngle()) {
            subMenu.add(Translate.menuItem("viewAngleModule", this, "actionPerformed"));
        }
        if (this.owner.allowParameters()) {
            subMenu.add(Translate.menuItem("parameterModule", this, "actionPerformed"));
        }
        subMenu.addSeparator();
        subMenu.add(Translate.menuItem("commentModule", this, "actionPerformed"));
        subMenu = Translate.menu("functions");
        insertMenu.add(subMenu);
        subMenu.add(Translate.menuItem("expressionModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("customFunctionModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("scaleShiftModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("addModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("subtractModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("multiplyModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("divideModule", this, "actionPerformed"));
        subMenu.addSeparator();
        subMenu.add(Translate.menuItem("absModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("blurModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("clipModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("greaterThanModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("minModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("maxModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("interpolateModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("modModule", this, "actionPerformed"));
        subMenu.addSeparator();
        subMenu.add(Translate.menuItem("sineModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("cosineModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("sqrtModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("expModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("logModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("powModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("biasModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("gainModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("randomModule", this, "actionPerformed"));
        subMenu = Translate.menu("colorFunctions");
        insertMenu.add(subMenu);
        subMenu.add(Translate.menuItem("customColorFunctionModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("blendModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("addColorModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("subtractColorModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("multiplyColorModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("lighterModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("darkerModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("scaleColorModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("RGBModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("HSVModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("HLSModule", this, "actionPerformed"));
        subMenu = Translate.menu("transforms");
        insertMenu.add(subMenu);
        subMenu.add(Translate.menuItem("linearModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("polarModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("sphericalModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("jitterModule", this, "actionPerformed"));
        subMenu = Translate.menu("patterns");
        insertMenu.add(subMenu);
        subMenu.add(Translate.menuItem("noiseModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("turbulenceModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("gridModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("cellsModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("marbleModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("woodModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("checkerModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("bricksModule", this, "actionPerformed"));
        subMenu.add(Translate.menuItem("imageModule", this, "actionPerformed"));
        Class[] plugin = ModellingApp.getModules();
        if (plugin.length > 0) {
            subMenu = Translate.menu("plugins");
            insertMenu.add(subMenu);
            for (int i = 0; i < plugin.length; ++i) {
                try {
                    BMenuItem mi = new BMenuItem(((Module)plugin[i].newInstance()).getName());
                    mi.setActionCommand(plugin[i].getName());
                    mi.addEventLink(class$buoy$event$CommandEvent == null ? ProcedureEditor.class$("buoy.event.CommandEvent") : class$buoy$event$CommandEvent, (Object)this, "actionPerformed");
                    subMenu.add(mi);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return insertMenu;
    }

    public BFrame getParentFrame() {
        return this.parent;
    }

    public Scene getScene() {
        return this.theScene;
    }

    public void setEditingWindow(EditingWindow window) {
        this.win = window;
    }

    public EditingWindow getEditingWindow() {
        return this.win;
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    private void paint(RepaintEvent ev) {
        this.paint(ev.getGraphics());
    }

    private void paint(Graphics2D g) {
        int i;
        OutputModule[] output = this.proc.getOutputModules();
        Module[] module = this.proc.getModules();
        Link[] link = this.proc.getLinks();
        int divider = output[0].getBounds().x - 5;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.outputBackgroundColor);
        g.fillRoundRect(divider, 5, this.size.width - divider - 10, this.size.height - 10, 8, 8);
        for (i = 0; i < output.length; ++i) {
            output[i].draw(g, false);
        }
        for (i = 0; i < module.length; ++i) {
            module[i].draw(g, this.selectedModule[i]);
        }
        g.setStroke(bold);
        for (i = 0; i < link.length; ++i) {
            if (this.selectedLink[i]) continue;
            g.setColor(link[i].from.getValueType() == 0 ? this.darkLinkColor : this.blueLinkColor);
            g.draw(this.createBezierCurve(link[i]));
        }
        g.setColor(this.selectedLinkColor);
        for (i = 0; i < link.length; ++i) {
            if (!this.selectedLink[i]) continue;
            g.draw(this.createBezierCurve(link[i]));
        }
        g.setStroke(normal);
        if (this.draggingLink) {
            boolean isInput;
            boolean bl = isInput = this.dragFromPort.getType() == 0;
            if (isInput || this.dragToPort != null) {
                this.inputInfo.draw(g);
            }
            if (!isInput || this.dragToPort != null) {
                this.outputInfo.draw(g);
            }
        }
        g.setXORMode(Color.WHITE);
        if (this.draggingBox && this.lastPos != null) {
            Rectangle rect = this.getRectangle(this.clickPos, this.lastPos);
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
        }
        if (this.draggingLink && this.lastPos != null) {
            if (this.dragToPort == null) {
                g.drawLine(this.clickPos.x, this.clickPos.y, this.lastPos.x, this.lastPos.y);
            } else {
                Point pos = this.dragToPort.getPosition();
                g.drawLine(this.clickPos.x, this.clickPos.y, pos.x, pos.y);
            }
        }
        if (this.draggingModule && this.lastPos != null) {
            int dx = this.lastPos.x - this.clickPos.x;
            int dy = this.lastPos.y - this.clickPos.y;
            for (int i2 = 0; i2 < this.selectedModule.length; ++i2) {
                if (!this.selectedModule[i2]) continue;
                Rectangle rect = module[i2].getBounds();
                g.drawRect(rect.x + dx, rect.y + dy, rect.width, rect.height);
            }
        }
    }

    private Shape createBezierCurve(Link link) {
        float ctrly2;
        float ctrlx2;
        float ctrly1;
        float ctrlx1;
        int x1 = link.from.getPosition().x;
        int y1 = link.from.getPosition().y;
        int x2 = link.to.getPosition().x;
        int y2 = link.to.getPosition().y;
        if (link.from.getLocation() == 2 || link.from.getLocation() == 3) {
            ctrlx1 = (float)(x2 - x1) * 0.5f + (float)x1;
            ctrly1 = y1;
        } else {
            ctrlx1 = x1;
            ctrly1 = (float)(y2 - y1) * 0.5f + (float)y1;
        }
        if (link.to.getLocation() == 2 || link.to.getLocation() == 3) {
            ctrlx2 = 0.5f * (float)(x2 - x1) + (float)x1;
            ctrly2 = y2;
        } else {
            ctrlx2 = x2;
            ctrly2 = 0.5f * (float)(y2 - y1) + (float)y1;
        }
        return new CubicCurve2D.Float(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2);
    }

    private void updateMenus() {
        int i;
        boolean anyModule = false;
        boolean anyLink = false;
        for (i = 0; i < this.selectedModule.length; ++i) {
            if (!this.selectedModule[i]) continue;
            anyModule = true;
        }
        for (i = 0; i < this.selectedLink.length; ++i) {
            if (!this.selectedLink[i]) continue;
            anyLink = true;
        }
        this.cutItem.setEnabled(anyModule);
        this.copyItem.setEnabled(anyModule);
        this.pasteItem.setEnabled(clipboard != null);
        this.clearItem.setEnabled(anyModule || anyLink);
    }

    private void actionPerformed(CommandEvent e) {
        String command = e.getActionCommand();
        Point p = new Point(this.scroll.getHorizontalScrollBar().getValue(), this.scroll.getVerticalScrollBar().getValue());
        Rectangle bounds = this.scroll.getBounds();
        p.x += (int)(0.5 * (double)bounds.width * Math.random());
        p.y += (int)(0.5 * (double)bounds.height * Math.random());
        if (command.equals("cancel")) {
            this.undoBuffer = this.cancelBuffer;
            this.undo();
            this.owner.disposePreview(this.preview);
            this.parent.dispose();
            return;
        }
        if (command.equals("ok")) {
            if (this.owner.canEditName()) {
                this.owner.setName(this.nameField.getText());
            }
            this.owner.acceptEdits(this);
            this.owner.disposePreview(this.preview);
            this.parent.dispose();
            return;
        }
        if (command.equals("undo")) {
            this.undo();
            return;
        }
        if (command.equals("cut")) {
            clipboard = new ClipboardSelection(this.proc, this.selectedModule, this.selectedLink);
            this.deleteSelection();
            this.updateMenus();
            return;
        }
        if (command.equals("copy")) {
            clipboard = new ClipboardSelection(this.proc, this.selectedModule, this.selectedLink);
            this.updateMenus();
            return;
        }
        if (command.equals("paste") && clipboard != null) {
            this.saveState(false);
            clipboard.paste(this);
            this.repaint();
            return;
        }
        if (command.equals("clear")) {
            this.deleteSelection();
            return;
        }
        if (command.equals("properties")) {
            this.owner.editProperties(this);
            return;
        }
        this.saveState(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (command.equals("numberModule")) {
            this.addModule(new NumberModule(p));
        } else if (command.equals("colorModule")) {
            this.addModule(new ColorModule(p));
        } else if (command.equals("xModule")) {
            this.addModule(new CoordinateModule(p, 0));
        } else if (command.equals("yModule")) {
            this.addModule(new CoordinateModule(p, 1));
        } else if (command.equals("zModule")) {
            this.addModule(new CoordinateModule(p, 2));
        } else if (command.equals("timeModule")) {
            this.addModule(new CoordinateModule(p, 3));
        } else if (command.equals("viewAngleModule")) {
            this.addModule(new ViewAngleModule(p));
        } else if (command.equals("parameterModule")) {
            this.addModule(new ParameterModule(p));
        } else if (command.equals("commentModule")) {
            this.addModule(new CommentModule(p));
        } else if (command.equals("addModule")) {
            this.addModule(new SumModule(p));
        } else if (command.equals("subtractModule")) {
            this.addModule(new DifferenceModule(p));
        } else if (command.equals("multiplyModule")) {
            this.addModule(new ProductModule(p));
        } else if (command.equals("divideModule")) {
            this.addModule(new RatioModule(p));
        } else if (command.equals("scaleShiftModule")) {
            this.addModule(new ScaleShiftModule(p));
        } else if (command.equals("interpolateModule")) {
            this.addModule(new InterpModule(p));
        } else if (command.equals("greaterThanModule")) {
            this.addModule(new CompareModule(p));
        } else if (command.equals("minModule")) {
            this.addModule(new MinModule(p));
        } else if (command.equals("maxModule")) {
            this.addModule(new MaxModule(p));
        } else if (command.equals("modModule")) {
            this.addModule(new ModModule(p));
        } else if (command.equals("absModule")) {
            this.addModule(new AbsModule(p));
        } else if (command.equals("clipModule")) {
            this.addModule(new ClipModule(p));
        } else if (command.equals("sineModule")) {
            this.addModule(new SineModule(p));
        } else if (command.equals("cosineModule")) {
            this.addModule(new CosineModule(p));
        } else if (command.equals("sqrtModule")) {
            this.addModule(new SqrtModule(p));
        } else if (command.equals("expModule")) {
            this.addModule(new ExpModule(p));
        } else if (command.equals("logModule")) {
            this.addModule(new LogModule(p));
        } else if (command.equals("powModule")) {
            this.addModule(new PowerModule(p));
        } else if (command.equals("biasModule")) {
            this.addModule(new BiasModule(p));
        } else if (command.equals("gainModule")) {
            this.addModule(new GainModule(p));
        } else if (command.equals("randomModule")) {
            this.addModule(new RandomModule(p));
        } else if (command.equals("blurModule")) {
            this.addModule(new BlurModule(p));
        } else if (command.equals("customFunctionModule")) {
            this.addModule(new FunctionModule(p));
        } else if (command.equals("expressionModule")) {
            this.addModule(new ExprModule(p));
        } else if (command.equals("linearModule")) {
            this.addModule(new TransformModule(p));
        } else if (command.equals("polarModule")) {
            this.addModule(new PolarModule(p));
        } else if (command.equals("sphericalModule")) {
            this.addModule(new SphericalModule(p));
        } else if (command.equals("jitterModule")) {
            this.addModule(new JitterModule(p));
        } else if (command.equals("addColorModule")) {
            this.addModule(new ColorSumModule(p));
        } else if (command.equals("subtractColorModule")) {
            this.addModule(new ColorDifferenceModule(p));
        } else if (command.equals("multiplyColorModule")) {
            this.addModule(new ColorProductModule(p));
        } else if (command.equals("lighterModule")) {
            this.addModule(new ColorLightenModule(p));
        } else if (command.equals("darkerModule")) {
            this.addModule(new ColorDarkenModule(p));
        } else if (command.equals("scaleColorModule")) {
            this.addModule(new ColorScaleModule(p));
        } else if (command.equals("blendModule")) {
            this.addModule(new BlendModule(p));
        } else if (command.equals("customColorFunctionModule")) {
            this.addModule(new SpectrumModule(p));
        } else if (command.equals("RGBModule")) {
            this.addModule(new RGBModule(p));
        } else if (command.equals("HSVModule")) {
            this.addModule(new HSVModule(p));
        } else if (command.equals("HLSModule")) {
            this.addModule(new HLSModule(p));
        } else if (command.equals("noiseModule")) {
            this.addModule(new NoiseModule(p));
        } else if (command.equals("turbulenceModule")) {
            this.addModule(new TurbulenceModule(p));
        } else if (command.equals("marbleModule")) {
            this.addModule(new MarbleModule(p));
        } else if (command.equals("woodModule")) {
            this.addModule(new WoodModule(p));
        } else if (command.equals("gridModule")) {
            this.addModule(new GridModule(p));
        } else if (command.equals("cellsModule")) {
            this.addModule(new CellsModule(p));
        } else if (command.equals("checkerModule")) {
            this.addModule(new CheckerModule(p));
        } else if (command.equals("bricksModule")) {
            this.addModule(new BrickModule(p));
        } else if (command.equals("imageModule")) {
            this.addModule(new ImageModule(p));
        } else {
            try {
                Class cl = ModellingApp.getClass(command);
                Module mod = (Module)cl.newInstance();
                mod.setPosition(p.x, p.y);
                this.addModule(mod);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.repaint();
    }

    private void addModule(Module mod) {
        this.selectedModule = new boolean[this.selectedModule.length + 1];
        this.selectedModule[this.selectedModule.length - 1] = true;
        for (int i = 0; i < this.selectedLink.length; ++i) {
            this.selectedLink[i] = false;
        }
        this.proc.addModule(mod);
        this.updateMenus();
    }

    private void addLink(IOPort port1, IOPort port2) {
        IOPort to;
        IOPort from;
        this.selectedLink = new boolean[this.selectedLink.length + 1];
        this.selectedLink[this.selectedLink.length - 1] = true;
        for (int i = 0; i < this.selectedModule.length; ++i) {
            this.selectedModule[i] = false;
        }
        if (port1.getType() == 1) {
            from = port1;
            to = port2;
        } else {
            from = port2;
            to = port1;
        }
        this.proc.addLink(new Link(from, to));
        if (this.proc.checkFeedback()) {
            this.proc.deleteLink(this.proc.getLinks().length - 1);
            this.selectedLink = new boolean[this.proc.getLinks().length];
            new BStandardDialog(null, new String[]{"The link you have selected cannot be created,", "as it would result in a feedback loop."}, BStandardDialog.ERROR).showMessageDialog(this.parent);
        }
        this.updateMenus();
    }

    public void saveState(boolean redo) {
        this.undoBuffer.reset();
        DataOutputStream out = new DataOutputStream(this.undoBuffer);
        try {
            this.proc.writeToStream(out, this.theScene);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.undoIsRedo = redo & !this.undoIsRedo;
        this.undoItem.setText(this.undoIsRedo ? "Redo" : "Undo");
        this.undoItem.setEnabled(true);
    }

    private void undo() {
        byte[] buffer = this.undoBuffer.toByteArray();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buffer));
        this.saveState(true);
        try {
            this.proc.readFromStream(in, this.theScene);
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.selectedModule = new boolean[this.proc.getModules().length];
        this.selectedLink = new boolean[this.proc.getLinks().length];
        this.repaint();
        this.updatePreview();
        this.updateMenus();
    }

    public void updatePreview() {
        this.owner.updatePreview(this.preview);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    private void mouseClicked(MouseClickedEvent e) {
        Point pos = e.getPoint();
        if (e.getClickCount() == 2) {
            Module[] module = this.proc.getModules();
            for (int i = 0; i < module.length; ++i) {
                if (!module[i].getBounds().contains(pos)) continue;
                this.saveState(false);
                if (module[i].edit(this.parent, this.theScene)) {
                    this.repaint();
                    this.updatePreview();
                }
                return;
            }
        }
    }

    private void mousePressed(MousePressedEvent e) {
        IOPort port;
        int i;
        OutputModule[] output = this.proc.getOutputModules();
        Module[] module = this.proc.getModules();
        Link[] link = this.proc.getLinks();
        this.requestFocus();
        this.clickPos = e.getPoint();
        this.lastPos = null;
        for (i = 0; i < module.length; ++i) {
            port = module[i].getClickedPort(this.clickPos);
            if (port == null) continue;
            this.startDragLink(port);
            return;
        }
        for (i = 0; i < output.length; ++i) {
            port = output[i].getClickedPort(this.clickPos);
            if (port == null) continue;
            this.startDragLink(port);
            return;
        }
        for (i = module.length - 1; i >= 0; --i) {
            if (!this.selectedModule[i] || !module[i].getBounds().contains(this.clickPos)) continue;
            this.draggingModule = true;
            this.repaint();
            return;
        }
        for (i = module.length - 1; i >= 0; --i) {
            if (this.selectedModule[i] || !module[i].getBounds().contains(this.clickPos)) continue;
            this.draggingModule = true;
            if (!e.isShiftDown()) {
                Arrays.fill(this.selectedModule, false);
                Arrays.fill(this.selectedLink, false);
            }
            this.selectedModule[i] = true;
            this.repaint();
            this.updateMenus();
            return;
        }
        for (i = 0; i < link.length; ++i) {
            int tol = 2;
            if (!this.createBezierCurve(link[i]).intersects(new Rectangle(this.clickPos.x - tol, this.clickPos.y - tol, 2 * tol, 2 * tol))) continue;
            if (!e.isShiftDown()) {
                Arrays.fill(this.selectedModule, false);
                Arrays.fill(this.selectedLink, false);
            }
            this.selectedLink[i] = true;
            this.repaint();
            this.updateMenus();
            return;
        }
        if (!e.isShiftDown()) {
            Arrays.fill(this.selectedModule, false);
            Arrays.fill(this.selectedLink, false);
        }
        this.draggingBox = true;
        this.repaint();
        this.updateMenus();
    }

    private void mouseReleased(MouseReleasedEvent e) {
        Point pos = e.getPoint();
        if (this.draggingLink) {
            this.draggingLink = false;
            if (this.dragToPort != null) {
                this.saveState(false);
                this.addLink(this.dragFromPort, this.dragToPort);
                this.updatePreview();
            }
            this.repaint();
            return;
        }
        if (this.draggingBox) {
            if (this.lastPos == null) {
                this.draggingBox = false;
                this.repaint();
                return;
            }
            Rectangle rect = this.getRectangle(this.clickPos, this.lastPos);
            Module[] module = this.proc.getModules();
            for (int i = 0; i < this.selectedModule.length; ++i) {
                if (!module[i].getBounds().intersects(rect)) continue;
                this.selectedModule[i] = true;
            }
            this.draggingBox = false;
            this.repaint();
            this.updateMenus();
            return;
        }
        if (this.draggingModule) {
            this.saveState(false);
            this.draggingModule = false;
            int dx = pos.x - this.clickPos.x;
            int dy = pos.y - this.clickPos.y;
            Module[] module = this.proc.getModules();
            for (int i = 0; i < this.selectedModule.length; ++i) {
                if (!this.selectedModule[i]) continue;
                Rectangle rect = module[i].getBounds();
                module[i].setPosition(rect.x + dx, rect.y + dy);
            }
        }
        this.repaint();
    }

    private void mouseDragged(MouseDraggedEvent e) {
        Point pos = e.getPoint();
        if (this.draggingBox) {
            Rectangle rect;
            Graphics g = this.getComponent().getGraphics();
            g.setColor(Color.black);
            g.setXORMode(Color.white);
            if (this.lastPos != null) {
                rect = this.getRectangle(this.clickPos, this.lastPos);
                g.drawRect(rect.x, rect.y, rect.width, rect.height);
            }
            this.lastPos = pos;
            rect = this.getRectangle(this.clickPos, this.lastPos);
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
            g.dispose();
            return;
        }
        if (this.draggingLink) {
            int j;
            IOPort[] port;
            int i;
            boolean isInput;
            if (this.dragToPort != null && this.dragToPort.contains(pos)) {
                return;
            }
            Graphics2D g = (Graphics2D)this.getComponent().getGraphics();
            boolean bl = isInput = this.dragFromPort.getType() == 0;
            if (this.dragToPort != null) {
                this.dragToPort = null;
                this.paint(g);
            }
            g.setColor(Color.black);
            g.setXORMode(Color.white);
            if (this.lastPos != null) {
                g.drawLine(this.clickPos.x, this.clickPos.y, this.lastPos.x, this.lastPos.y);
            }
            OutputModule[] output = this.proc.getOutputModules();
            Module[] module = this.proc.getModules();
            for (i = 0; i < module.length; ++i) {
                port = isInput ? module[i].getOutputPorts() : module[i].getInputPorts();
                for (j = 0; j < port.length; ++j) {
                    if (!isInput && module[i].inputConnected(j) || port[j].getValueType() != this.dragFromPort.getValueType() || !port[j].contains(pos)) continue;
                    this.dragToPort = port[j];
                }
                if (this.dragToPort != null) break;
            }
            if (!isInput) {
                for (i = 0; i < output.length; ++i) {
                    port = output[i].getInputPorts();
                    for (j = 0; j < port.length; ++j) {
                        if (output[i].inputConnected(j) || port[j].getValueType() != this.dragFromPort.getValueType() || !port[j].contains(pos)) continue;
                        this.dragToPort = port[j];
                    }
                    if (this.dragToPort != null) break;
                }
            }
            if (this.dragToPort != null) {
                InfoBox info = isInput ? this.outputInfo : this.inputInfo;
                Rectangle rect = info.getBounds();
                pos = this.dragToPort.getPosition();
                if (isInput) {
                    info.setPosition(pos.x - rect.width - 10, pos.y - rect.height / 2);
                } else {
                    info.setPosition(pos.x + 10, pos.y - rect.height / 2);
                }
                info.setText(this.dragToPort.getDescription());
                this.repaint();
            } else {
                g.drawLine(this.clickPos.x, this.clickPos.y, pos.x, pos.y);
            }
            g.dispose();
            this.lastPos = pos;
            return;
        }
        if (!this.draggingModule) {
            return;
        }
        int dx = pos.x - this.clickPos.x;
        int dy = pos.y - this.clickPos.y;
        int lastdx = 0;
        int lastdy = 0;
        Module[] module = this.proc.getModules();
        Graphics g = this.getComponent().getGraphics();
        if (this.lastPos != null) {
            lastdx = this.lastPos.x - this.clickPos.x;
            lastdy = this.lastPos.y - this.clickPos.y;
        }
        g.setColor(Color.black);
        g.setXORMode(Color.white);
        for (int i = 0; i < this.selectedModule.length; ++i) {
            if (!this.selectedModule[i]) continue;
            Rectangle rect = module[i].getBounds();
            if (this.lastPos != null) {
                g.drawRect(rect.x + lastdx, rect.y + lastdy, rect.width, rect.height);
            }
            g.drawRect(rect.x + dx, rect.y + dy, rect.width, rect.height);
        }
        g.dispose();
        this.lastPos = pos;
    }

    private void startDragLink(IOPort port) {
        boolean isInput = port.getType() == 0;
        InfoBox info = isInput ? this.inputInfo : this.outputInfo;
        Point pos = port.getPosition();
        this.draggingLink = true;
        this.draggingModule = false;
        this.dragFromPort = port;
        this.dragToPort = null;
        this.clickPos = port.getPosition();
        info.setText(port.getDescription());
        Rectangle rect = info.getBounds();
        if (isInput) {
            info.setPosition(pos.x + 10, pos.y - rect.height / 2);
        } else {
            info.setPosition(pos.x - rect.width - 10, pos.y - rect.height / 2);
        }
        Graphics g = this.getComponent().getGraphics();
        info.draw(g);
        g.dispose();
        if (isInput) {
            Module module = port.getModule();
            IOPort[] inputs = module.getInputPorts();
            for (int i = 0; i < inputs.length; ++i) {
                if (inputs[i] != port || !module.inputConnected(i)) continue;
                this.draggingLink = false;
            }
        }
    }

    private void keyPressed(KeyPressedEvent e) {
        int key = e.getKeyCode();
        if (key != 8 && key != 127) {
            return;
        }
        this.deleteSelection();
    }

    private void deleteSelection() {
        int i;
        this.saveState(false);
        Module[] module = this.proc.getModules();
        Link[] link = this.proc.getLinks();
        for (i = 0; i < this.selectedLink.length; ++i) {
            for (int j = 0; j < this.selectedModule.length; ++j) {
                if ((module[j] != link[i].from.getModule() || !this.selectedModule[j]) && (module[j] != link[i].to.getModule() || !this.selectedModule[j])) continue;
                this.selectedLink[i] = true;
            }
        }
        for (i = this.selectedLink.length - 1; i >= 0; --i) {
            if (!this.selectedLink[i]) continue;
            this.proc.deleteLink(i);
        }
        for (i = this.selectedModule.length - 1; i >= 0; --i) {
            if (!this.selectedModule[i]) continue;
            this.proc.deleteModule(i);
        }
        this.selectedModule = new boolean[this.proc.getModules().length];
        this.selectedLink = new boolean[this.proc.getLinks().length];
        this.updatePreview();
        this.repaint();
        this.updateMenus();
    }

    public Rectangle getRectangle(Point p1, Point p2) {
        int x = Math.min(p1.x, p2.x);
        int y = Math.min(p1.y, p2.y);
        int width = Math.abs(p1.x - p2.x);
        int height = Math.abs(p1.y - p2.y);
        return new Rectangle(x, y, width, height);
    }

    private static class ClipboardSelection {
        Module[] module;
        Link[] link;

        public ClipboardSelection(Procedure proc, boolean[] selectedModule, boolean[] selectedLink) {
            int i;
            Vector<Module> mod = new Vector<Module>();
            Vector<Link> ln = new Vector<Link>();
            Module[] allModules = proc.getModules();
            Link[] allLinks = proc.getLinks();
            for (i = 0; i < selectedModule.length; ++i) {
                if (!selectedModule[i]) continue;
                mod.addElement(allModules[i]);
            }
            for (i = 0; i < selectedLink.length; ++i) {
                if (mod.indexOf(allLinks[i].from.getModule()) <= -1 || mod.indexOf(allLinks[i].to.getModule()) <= -1) continue;
                ln.addElement(allLinks[i]);
            }
            this.module = new Module[mod.size()];
            this.link = new Link[ln.size()];
            for (i = 0; i < this.module.length; ++i) {
                this.module[i] = ((Module)mod.elementAt(i)).duplicate();
            }
            for (i = 0; i < this.link.length; ++i) {
                Link thisLink = (Link)ln.elementAt(i);
                int from = mod.indexOf(thisLink.from.getModule());
                int to = mod.indexOf(thisLink.to.getModule());
                int fromPort = thisLink.getFromPortIndex();
                int toPort = thisLink.getToPortIndex();
                this.link[i] = new Link(this.module[from].getOutputPorts()[fromPort], this.module[to].getInputPorts()[toPort]);
            }
        }

        public void paste(ProcedureEditor editor) {
            int i;
            int numModules = editor.selectedModule.length;
            int numLinks = editor.selectedLink.length;
            Module[] realMod = new Module[this.module.length];
            for (i = 0; i < this.module.length; ++i) {
                if (this.module[i] instanceof ParameterModule && !editor.owner.allowParameters()) continue;
                realMod[i] = this.module[i].duplicate();
                if (realMod[i] instanceof ImageModule && editor.theScene.indexOf(((ImageModule)realMod[i]).getMap()) == -1) {
                    ((ImageModule)realMod[i]).setMap(null);
                }
                Rectangle bounds = realMod[i].getBounds();
                realMod[i].setPosition(bounds.x - 30, bounds.y + 30);
                editor.addModule(realMod[i]);
            }
            for (i = 0; i < this.link.length; ++i) {
                int from = 0;
                while (this.module[from] != this.link[i].from.getModule()) {
                    ++from;
                }
                int to = 0;
                while (this.module[to] != this.link[i].to.getModule()) {
                    ++to;
                }
                if (realMod[from] == null || realMod[to] == null) continue;
                int fromPort = this.link[i].getFromPortIndex();
                int toPort = this.link[i].getToPortIndex();
                editor.addLink(realMod[from].getOutputPorts()[fromPort], realMod[to].getInputPorts()[toPort]);
            }
            for (i = 0; i < editor.selectedModule.length; ++i) {
                ((ProcedureEditor)editor).selectedModule[i] = i >= numModules;
            }
            for (i = 0; i < editor.selectedLink.length; ++i) {
                ((ProcedureEditor)editor).selectedLink[i] = i >= numLinks;
            }
            editor.updateMenus();
        }
    }
}

