/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.Vec3;
import artofillusion.procedural.Arg;
import artofillusion.procedural.CoordinateModule;
import artofillusion.procedural.DifferenceModule;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.ModuleLoader;
import artofillusion.procedural.NumberModule;
import artofillusion.procedural.OPort;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.Token;
import artofillusion.procedural.debug;
import artofillusion.ui.ComponentsDialog;
import buoy.widget.BFrame;
import buoy.widget.BStandardDialog;
import buoy.widget.BTextField;
import buoy.widget.Widget;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExprModule
extends Module {
    Hashtable varTable;
    Module[] inputs;
    Module[] myModules;
    Vector moduleVec;
    OPort compiled;
    Token[] tokens;
    Token currTok;
    int tokIdx;
    PointInfo point;
    Point zero = new Point(0, 0);
    String expr;
    Vector errors;
    int a;
    static /* synthetic */ Class class$artofillusion$procedural$SumModule;
    static /* synthetic */ Class class$artofillusion$procedural$ProductModule;
    static /* synthetic */ Class class$artofillusion$procedural$RatioModule;
    static /* synthetic */ Class class$artofillusion$procedural$ModModule;

    public ExprModule(Point position) {
        super("expr", new IOPort[]{new IOPort(0, 0, 2, new String[]{"Value 1", "(0)"}), new IOPort(0, 0, 2, new String[]{"Value 2", "(0)"}), new IOPort(0, 0, 2, new String[]{"Value 3", "(0)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Result"})}, position);
        this.inputs = this.linkFrom;
        this.setExpr("x");
        this.layout();
    }

    public final void init(PointInfo p) {
        this.point = p;
        for (int i = this.myModules.length - 1; i >= 0; --i) {
            if (this.myModules[i] == null) {
                debug.print("There's a null module in the module list at " + i + " of " + this.myModules.length + ", skipping.");
            }
            this.myModules[i].init(p);
        }
    }

    public final double getAverageValue(int which, double blur) {
        return this.compiled.module.getAverageValue(this.compiled.oport, blur);
    }

    public final double getValueError(int which, double blur) {
        return this.compiled.module.getValueError(this.compiled.oport, blur);
    }

    public final void getValueGradient(int which, Vec3 grad, double blur) {
        this.compiled.module.getValueGradient(this.compiled.oport, grad, blur);
    }

    public void setInput(IOPort which, IOPort port) {
        super.setInput(which, port);
        this.inputs = this.linkFrom;
        this.initVarTable();
        this.compile();
    }

    public boolean edit(BFrame fr, Scene theScene) {
        BTextField exprField = new BTextField(this.expr, 40);
        ComponentsDialog dlg = new ComponentsDialog(fr, "Set Expression:", new Widget[]{exprField}, new String[]{"Calculate:"});
        if (!dlg.clickedOk()) {
            return false;
        }
        this.errors = new Vector();
        try {
            this.setExpr(exprField.getText().toLowerCase());
        }
        catch (Exception ex) {
            this.addError("The expression could not be evaluated.");
        }
        if (this.errors.size() > 0) {
            this.displayErrors(fr);
        }
        this.errors = null;
        this.layout();
        return true;
    }

    public Module duplicate() {
        ExprModule mod = new ExprModule(new Point(this.bounds.x, this.bounds.y));
        mod.setExpr(new String(this.expr));
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeUTF(this.expr);
    }

    public void setExpr(String e) {
        this.expr = e;
        this.name = "[" + this.expr + "]";
        this.lex(this.expr);
        this.compile();
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.inputs = this.linkFrom;
        this.setExpr(in.readUTF());
        this.layout();
    }

    public final boolean isCompiled() {
        return this.compiled != null;
    }

    void addToken(Token tok) {
        debug.print("Adding token " + tok);
        if (this.tokIdx >= this.tokens.length) {
            Token[] oldtokens = this.tokens;
            this.tokens = new Token[this.tokens.length * 2];
            for (int i = 0; i < this.tokens.length; ++i) {
                this.tokens[i] = oldtokens[i];
            }
        }
        this.tokens[this.tokIdx++] = tok;
        this.currTok = tok;
    }

    void lex(String str) {
        this.tokIdx = 0;
        this.tokens = new Token[100];
        StringTokenizer st = new StringTokenizer(this.expr, "+-/*%;=,()^ ", true);
        String tok = " ";
        boolean get = true;
        block4: while (!get || st.hasMoreTokens()) {
            char c;
            if (get) {
                tok = st.nextToken();
            } else {
                get = true;
            }
            if ((c = tok.charAt(0)) == ' ') continue;
            switch (c) {
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '/': 
                case ';': 
                case '=': 
                case '^': {
                    this.addToken(new Token(c));
                    continue block4;
                }
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.addToken(new Token('#'));
                    this.currTok.numValue = new Double(tok);
                    continue block4;
                }
            }
            this.addToken(new Token('$'));
            String name = tok;
            get = true;
            while (get && st.hasMoreTokens()) {
                tok = st.nextToken();
                c = tok.charAt(0);
                if (c == ' ') continue;
                get = false;
            }
            if (c == '(') {
                this.currTok.ty = (char)38;
            }
            this.currTok.strValue = name;
        }
        this.currTok = new Token(';');
        this.tokIdx = 0;
    }

    void initVarTable() {
        this.varTable = new Hashtable();
        this.moduleVec = new Vector();
        CoordinateModule x = (CoordinateModule)ModuleLoader.createModule(CoordinateModule.class);
        x.setCoordinate(0);
        CoordinateModule y = (CoordinateModule)ModuleLoader.createModule(CoordinateModule.class);
        y.setCoordinate(1);
        CoordinateModule z = (CoordinateModule)ModuleLoader.createModule(CoordinateModule.class);
        z.setCoordinate(2);
        CoordinateModule t = (CoordinateModule)ModuleLoader.createModule(CoordinateModule.class);
        t.setCoordinate(3);
        this.varTable.put("x", new OPort(x));
        this.varTable.put("y", new OPort(y));
        this.varTable.put("z", new OPort(z));
        this.varTable.put("t", new OPort(t));
        for (int i = 0; i < this.inputs.length; ++i) {
            if (this.inputs[i] != null) {
                OPort inp = new OPort(this.inputs[i], this.linkFromIndex[i]);
                this.varTable.put("input" + (i + 1), inp);
                continue;
            }
            this.varTable.put("input" + (i + 1), this.createNumberPort(0.0));
        }
        this.varTable.put("e", this.createNumberPort(Math.E));
        this.varTable.put("pi", this.createNumberPort(Math.PI));
    }

    void compile() {
        this.clearModules();
        this.tokIdx = 0;
        this.initVarTable();
        this.getToken();
        this.compiled = this.expr(false);
        this.myModules = new Module[this.moduleVec.size()];
        this.moduleVec.copyInto(this.myModules);
        if (this.compiled == null) {
            this.compiled = new OPort(new NumberModule(new Point(), 0.0), 0);
        }
        debug.print("Compiled form: " + this.compiled);
    }

    OPort expr(boolean get) {
        OPort left = this.term(get);
        block4: while (true) {
            switch (this.currTok.ty) {
                case '+': {
                    left = this.binOp(class$artofillusion$procedural$SumModule == null ? ExprModule.class$("artofillusion.procedural.SumModule") : class$artofillusion$procedural$SumModule, left, this.term(true));
                    continue block4;
                }
                case '-': {
                    left = this.binOp(class$artofillusion$procedural$DifferenceModule == null ? ExprModule.class$("artofillusion.procedural.DifferenceModule") : class$artofillusion$procedural$DifferenceModule, left, this.term(true));
                    continue block4;
                }
            }
            break;
        }
        return left;
    }

    void addModule(Module m) {
        if (m == null) {
            debug.print("I don't want to add a null module to the module list at position " + this.moduleVec.size());
            try {
                m.init(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (!this.moduleVec.contains(m)) {
            debug.print("Adding module " + m + " to the module list at position " + this.moduleVec.size());
            this.moduleVec.addElement(m);
        }
    }

    void clearModules() {
        this.myModules = new Module[0];
    }

    OPort term(boolean get) {
        OPort left = this.exponent(get);
        block5: while (true) {
            switch (this.currTok.ty) {
                case '*': {
                    left = this.binOp(class$artofillusion$procedural$ProductModule == null ? ExprModule.class$("artofillusion.procedural.ProductModule") : class$artofillusion$procedural$ProductModule, left, this.exponent(true));
                    continue block5;
                }
                case '/': {
                    left = this.binOp(class$artofillusion$procedural$RatioModule == null ? ExprModule.class$("artofillusion.procedural.RatioModule") : class$artofillusion$procedural$RatioModule, left, this.exponent(true));
                    continue block5;
                }
                case '%': {
                    left = this.binOp(class$artofillusion$procedural$ModModule == null ? ExprModule.class$("artofillusion.procedural.ModModule") : class$artofillusion$procedural$ModModule, left, this.exponent(true));
                    continue block5;
                }
            }
            break;
        }
        return left;
    }

    OPort exponent(boolean get) {
        OPort left = this.prim(get);
        while (this.currTok.ty == '^') {
            OPort right = this.prim(true);
            OPort pow = this.getOPort("pow");
            IOPort[] inp = pow.module.getInputPorts();
            IOPort inport = inp[pow.args[0].iport];
            pow.module.setInput(inport, left.getOPort());
            inport = inp[pow.args[1].iport];
            pow.module.setInput(inport, right.getOPort());
            this.addModule(pow.module);
            left = pow;
        }
        return left;
    }

    OPort prim(boolean get) {
        if (get) {
            this.getToken();
        }
        switch (this.currTok.ty) {
            case '#': {
                OPort port = this.createNumberPort(this.currTok.numValue);
                this.getToken();
                return port;
            }
            case '&': {
                Token name = this.currTok;
                this.getToken();
                this.getToken();
                return this.function(name.strValue);
            }
            case '$': {
                if (this.currTok.strValue == null) {
                    debug.print("No variable " + this.currTok.strValue);
                    return null;
                }
                OPort port = (OPort)this.varTable.get(this.currTok.strValue);
                if (port == null) {
                    this.addError("There was no value assigned variable " + this.currTok.strValue + ".");
                    port = this.createNumberPort(0.0);
                }
                this.addModule(port.module);
                this.getToken();
                return port;
            }
            case '-': {
                return this.binOp(DifferenceModule.class, this.createNumberPort(0.0), this.prim(true));
            }
            case '(': {
                OPort port = this.expr(true);
                if (this.currTok.ty != ')') {
                    this.addError("Missing ).  Found " + this.currTok.getDescription() + " instead.");
                }
                this.getToken();
                return port;
            }
        }
        this.addError("Found " + this.currTok.getDescription() + " where a number or variable was expected.");
        return null;
    }

    Token getToken() {
        Token tok;
        if ((tok = this.tokens[this.tokIdx++]) == null) {
            tok = new Token('@');
        }
        this.currTok = tok;
        return tok;
    }

    OPort function(String name) {
        Object pr = null;
        OPort func = this.getOPort(name);
        Vector<OPort> s = new Vector<OPort>();
        while (this.currTok.ty != ')' && this.currTok.ty != '@') {
            s.addElement(this.expr(false));
            if (this.currTok.ty != ',') continue;
            this.getToken();
        }
        this.getToken();
        if (s.size() != func.args.length) {
            this.addError(name + " expects " + func.args.length + " arguments, but you called it with " + s.size() + ".");
            return null;
        }
        for (int i = 0; i < s.size(); ++i) {
            OPort arg = (OPort)s.elementAt(i);
            IOPort[] inp = func.module.getInputPorts();
            IOPort inport = inp[func.args[i].iport];
            func.module.setInput(inport, arg.getOPort());
            this.addModule(arg.module);
        }
        this.addModule(func.module);
        return func;
    }

    OPort getOPort(String name) {
        if (!Token.funMap.containsKey(name)) {
            debug.print("No such function: " + name);
            return null;
        }
        OPort op = (OPort)Token.funMap.get(name);
        return new OPort(op.module.duplicate(), op.oport, op.args);
    }

    OPort createNumberPort(double v) {
        NumberModule m = new NumberModule(this.zero, v);
        return new OPort(m);
    }

    OPort binOp(Class parentClass, OPort left, OPort right) {
        Module parentM = ModuleLoader.createModule(parentClass);
        Arg[] args = new Arg[]{new Arg("Arg1", 0), new Arg("Arg1", 1)};
        OPort parent = new OPort(parentM);
        parent.args = args;
        IOPort[] inp = parentM.getInputPorts();
        IOPort inport = inp[parent.args[0].iport];
        parentM.setInput(inport, left.getOPort());
        inport = inp[parent.args[1].iport];
        parentM.setInput(inport, right.getOPort());
        debug.print("Creating binOp: " + parentClass.getName() + " (" + left + ", " + right + ")");
        this.addModule(parentM);
        return parent;
    }

    void link(OPort consumer, OPort producer, int inIdx) {
        IOPort[] inp = consumer.module.getInputPorts();
        IOPort inport = inp[consumer.args[inIdx].iport];
        consumer.module.setInput(inport, producer.getOPort());
    }

    private void addError(String msg) {
        if (this.errors == null) {
            System.err.println(msg);
        } else {
            this.errors.addElement(msg);
        }
    }

    private void displayErrors(BFrame fr) {
        String[] msg = new String[this.errors.size() + 1];
        msg[0] = "Your expression contains the following errors:";
        for (int i = 0; i < this.errors.size(); ++i) {
            msg[i + 1] = (String)this.errors.elementAt(i);
        }
        new BStandardDialog("", msg, BStandardDialog.INFORMATION).showMessageDialog(fr);
    }
}

