/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Scene;
import artofillusion.ViewerCanvas;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.NullKeyframe;
import artofillusion.math.BoundingBox;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import javax.imageio.ImageIO;

public class ReferenceImage
extends Object3D {
    private double width;
    private double height;
    private Image image;

    public ReferenceImage() {
        this.width = 1.0;
        this.height = 1.0;
    }

    public ReferenceImage(Image image) {
        this.image = image;
        this.width = 0.01 * (double)image.getWidth(null);
        this.height = 0.01 * (double)image.getHeight(null);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public boolean canSetTexture() {
        return false;
    }

    public Object3D duplicate() {
        ReferenceImage ri = new ReferenceImage();
        ri.image = this.image;
        ri.width = this.width;
        ri.height = this.height;
        return ri;
    }

    public void copyObject(Object3D obj) {
        ReferenceImage ri = (ReferenceImage)obj;
        this.image = ri.image;
        this.width = ri.width;
        this.height = ri.height;
    }

    public BoundingBox getBounds() {
        return new BoundingBox(-0.5 * this.width, 0.5 * this.width, -0.5 * this.height, 0.5 * this.height, 0.0, 0.0);
    }

    public void setSize(double xsize, double ysize, double zsize) {
        this.width = xsize;
        this.height = ysize;
    }

    public WireframeMesh getWireframeMesh() {
        Vec3[] vert = new Vec3[]{new Vec3(-0.5 * this.width, 0.5 * this.height, 0.0), new Vec3(0.5 * this.width, 0.5 * this.height, 0.0), new Vec3(0.5 * this.width, -0.5 * this.height, 0.0), new Vec3(-0.5 * this.width, -0.5 * this.height, 0.0)};
        int[] from = new int[]{0, 1, 2, 3};
        int[] to = new int[]{1, 2, 3, 0};
        return new WireframeMesh(vert, from, to);
    }

    public Keyframe getPoseKeyframe() {
        return new NullKeyframe();
    }

    public void applyPoseKeyframe(Keyframe k) {
    }

    public void renderObject(ObjectInfo obj, ViewerCanvas canvas, Vec3 viewDir) {
        if (this.image == null) {
            super.renderObject(obj, canvas, viewDir);
        } else {
            canvas.renderImage(this.image, new Vec3(-0.5 * this.width, -0.5 * this.height, 0.0), new Vec3(0.5 * this.width, -0.5 * this.height, 0.0), new Vec3(0.5 * this.width, 0.5 * this.height, 0.0), new Vec3(-0.5 * this.width, 0.5 * this.height, 0.0));
        }
    }

    public ReferenceImage(DataInputStream in, Scene theScene) throws IOException {
        super(in, theScene);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.width = in.readDouble();
        this.height = in.readDouble();
        byte[] imageData = new byte[in.readInt()];
        in.readFully(imageData);
        this.image = ImageIO.read(new ByteArrayInputStream(imageData));
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
        out.writeDouble(this.width);
        out.writeDouble(this.height);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.image instanceof RenderedImage) {
            ImageIO.write((RenderedImage)((Object)this.image), "png", baos);
        } else {
            BufferedImage bi = new BufferedImage(this.image.getWidth(null), this.image.getHeight(null), 2);
            Graphics2D g = bi.createGraphics();
            g.drawImage(this.image, 0, 0, null);
            g.dispose();
            ImageIO.write((RenderedImage)bi, "png", baos);
        }
        out.writeInt(baos.size());
        out.write(baos.toByteArray());
    }
}

