/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.RenderingMesh;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.PoseTrack;
import artofillusion.animation.Skeleton;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.ui.EditingWindow;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public abstract class ObjectWrapper
extends Object3D {
    protected Object3D theObject;

    public ObjectWrapper() {
    }

    public ObjectWrapper(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
    }

    public Object3D getWrappedObject() {
        return this.theObject;
    }

    public BoundingBox getBounds() {
        return this.theObject.getBounds();
    }

    public boolean isClosed() {
        return this.theObject.isClosed();
    }

    public int canConvertToTriangleMesh() {
        return this.theObject.canConvertToTriangleMesh();
    }

    public TriangleMesh convertToTriangleMesh(double tol) {
        return this.theObject.convertToTriangleMesh(tol);
    }

    public void sceneChanged(ObjectInfo info, Scene scene) {
        this.theObject.sceneChanged(info, scene);
    }

    public void editGesture(EditingWindow parent, ObjectInfo info, Runnable cb, ObjectInfo realObject) {
        this.theObject.editGesture(parent, info, cb, realObject);
    }

    public Texture getTexture() {
        return this.theObject.getTexture();
    }

    public TextureMapping getTextureMapping() {
        return this.theObject.getTextureMapping();
    }

    public Material getMaterial() {
        return this.theObject.getMaterial();
    }

    public MaterialMapping getMaterialMapping() {
        return this.theObject.getMaterialMapping();
    }

    public TextureParameter[] getParameters() {
        return this.theObject.getParameters();
    }

    public void setParameters(TextureParameter[] param) {
        this.theObject.setParameters(param);
    }

    public ParameterValue[] getParameterValues() {
        return this.theObject.getParameterValues();
    }

    public double[] getAverageParameterValues() {
        return this.theObject.getAverageParameterValues();
    }

    public void setParameterValues(ParameterValue[] val) {
        this.theObject.setParameterValues(val);
    }

    public ParameterValue getParameterValue(TextureParameter param) {
        return this.theObject.getParameterValue(param);
    }

    public void setParameterValue(TextureParameter param, ParameterValue val) {
        this.theObject.setParameterValue(param, val);
    }

    public Skeleton getSkeleton() {
        return this.theObject.getSkeleton();
    }

    public RenderingMesh getRenderingMesh(double tol, boolean interactive, ObjectInfo info) {
        return this.theObject.getRenderingMesh(tol, interactive, info);
    }

    public WireframeMesh getWireframeMesh() {
        return this.theObject.getWireframeMesh();
    }

    public Keyframe getPoseKeyframe() {
        return this.theObject.getPoseKeyframe();
    }

    public void applyPoseKeyframe(Keyframe k) {
        this.theObject.applyPoseKeyframe(k);
    }

    public void configurePoseTrack(PoseTrack track) {
        this.theObject.configurePoseTrack(track);
    }

    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        this.theObject.editKeyframe(parent, k, info);
    }
}

