/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.ExternalObjectEditingWindow;
import artofillusion.Scene;
import artofillusion.object.NullObject;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.ObjectWrapper;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;

public class ExternalObject
extends ObjectWrapper {
    private File externalFile;
    private String objectName;
    private String loadingError;

    public ExternalObject(File file, String name) {
        this.externalFile = file;
        this.objectName = name;
        this.theObject = new NullObject();
    }

    private ExternalObject() {
        this.theObject = new NullObject();
    }

    public String getExternalObjectName() {
        return this.objectName;
    }

    public void setExternalObjectName(String name) {
        this.objectName = name;
    }

    public File getExternalSceneFile() {
        return this.externalFile;
    }

    public void setExternalSceneFile(File file) {
        this.externalFile = file;
    }

    public String getLoadingError() {
        return this.loadingError;
    }

    public void reloadObject() {
        this.theObject = new NullObject();
        this.loadingError = null;
        try {
            if (!this.externalFile.isFile()) {
                this.loadingError = Translate.text("externalObject.sceneNotFound", this.externalFile.getAbsolutePath());
                return;
            }
            Scene scene = new Scene(this.externalFile, true);
            boolean found = false;
            for (int i = 0; i < scene.getNumObjects(); ++i) {
                ObjectInfo info = scene.getObject(i);
                if (!info.name.equals(this.objectName)) continue;
                if (found) {
                    this.loadingError = Translate.text("externalObject.multipleObjectsFound", this.externalFile.getAbsolutePath(), this.objectName);
                    return;
                }
                this.theObject = info.object;
                found = true;
            }
            if (!found) {
                this.loadingError = Translate.text("externalObject.objectNotFound", this.externalFile.getAbsolutePath(), this.objectName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.loadingError = ex.getMessage();
        }
    }

    public Object3D duplicate() {
        ExternalObject obj = new ExternalObject();
        obj.externalFile = this.externalFile;
        obj.objectName = this.objectName;
        obj.theObject = this.theObject;
        return obj;
    }

    public void copyObject(Object3D obj) {
        ExternalObject eo = (ExternalObject)obj;
        this.externalFile = eo.externalFile;
        this.objectName = eo.objectName;
        this.theObject = eo.theObject;
    }

    public void setSize(double xsize, double ysize, double zsize) {
    }

    public boolean isEditable() {
        return true;
    }

    public void edit(EditingWindow parent, ObjectInfo info, Runnable cb) {
        new ExternalObjectEditingWindow(parent, this, info);
    }

    public boolean canSetTexture() {
        return false;
    }

    public boolean canSetMaterial() {
        return false;
    }

    public boolean canConvertToActor() {
        return false;
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
        out.writeUTF(this.externalFile.getAbsolutePath());
        out.writeUTF(this.findRelativePath(theScene));
        out.writeUTF(this.objectName);
    }

    private String findRelativePath(Scene theScene) {
        int i;
        int numCommon;
        String scenePath = null;
        String externalPath = null;
        try {
            scenePath = new File(theScene.getDirectory()).getCanonicalPath();
            externalPath = this.externalFile.getCanonicalPath();
        }
        catch (IOException ex) {
            return "";
        }
        String splitExpr = File.separator;
        if ("\\".equals(splitExpr)) {
            splitExpr = "\\\\";
        }
        String[] scenePathParts = scenePath.split(splitExpr);
        String[] externalPathParts = externalPath.split(splitExpr);
        for (numCommon = 0; numCommon < scenePathParts.length && numCommon < externalPathParts.length && scenePathParts[numCommon].equals(externalPathParts[numCommon]); ++numCommon) {
        }
        StringBuffer relPath = new StringBuffer();
        for (i = numCommon; i < scenePathParts.length; ++i) {
            relPath.append(".." + File.separator);
        }
        for (i = numCommon; i < externalPathParts.length; ++i) {
            if (i > numCommon) {
                relPath.append(File.separator);
            }
            relPath.append(externalPathParts[i]);
        }
        return relPath.toString();
    }

    public ExternalObject(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        File f;
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("Unknown version: " + version);
        }
        this.externalFile = new File(in.readUTF());
        String relPath = in.readUTF();
        if (!this.externalFile.isFile() && (f = new File(theScene.getDirectory(), relPath)).isFile()) {
            this.externalFile = f;
        }
        this.objectName = in.readUTF();
        this.reloadObject();
    }
}

