/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Property;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.Scene;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.PoseTrack;
import artofillusion.math.BoundingBox;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class Cylinder
extends Object3D {
    private double rx;
    private double rz;
    private double ratio;
    private double height;
    private BoundingBox bounds;
    private RenderingMesh cachedMesh;
    private WireframeMesh cachedWire;
    private static final int SEGMENTS = 16;
    private static double[] sine;
    private static double[] cosine;
    private static final Property[] PROPERTIES;

    public Cylinder(double height, double xradius, double yradius, double ratio) {
        this.height = height;
        this.rx = xradius;
        this.rz = yradius;
        this.ratio = ratio;
        this.bounds = new BoundingBox(-this.rx, this.rx, -height / 2.0, height / 2.0, -this.rz, this.rz);
    }

    public Object3D duplicate() {
        Cylinder obj = new Cylinder(this.height, this.rx, this.rz, this.ratio);
        obj.copyTextureAndMaterial(this);
        return obj;
    }

    public void copyObject(Object3D obj) {
        Cylinder c = (Cylinder)obj;
        Vec3 size = c.getBounds().getSize();
        this.setSize(size.x, size.y, size.z);
        this.ratio = c.ratio;
        this.copyTextureAndMaterial(obj);
        this.cachedMesh = null;
        this.cachedWire = null;
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
        this.cachedMesh = null;
        this.cachedWire = null;
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public void setSize(double xsize, double ysize, double zsize) {
        this.rx = xsize / 2.0;
        this.rz = zsize / 2.0;
        this.height = ysize;
        this.bounds = new BoundingBox(-this.rx, this.rx, -this.height / 2.0, this.height / 2.0, -this.rz, this.rz);
        this.cachedMesh = null;
        this.cachedWire = null;
    }

    public WireframeMesh getWireframeMesh() {
        int[] to;
        int[] from;
        Vec3[] vert;
        if (this.cachedWire != null) {
            return this.cachedWire;
        }
        double y1 = -this.height / 2.0;
        double y2 = this.height / 2.0;
        if (this.ratio > 0.0) {
            vert = new Vec3[34];
            from = new int[80];
            to = new int[80];
            vert[32] = new Vec3(0.0, y1, 0.0);
            vert[33] = new Vec3(0.0, y2, 0.0);
            for (int i = 0; i < 16; ++i) {
                vert[i] = new Vec3(this.rx * cosine[i], y1, this.rz * sine[i]);
                vert[i + 16] = new Vec3(this.ratio * this.rx * cosine[i], y2, this.ratio * this.rz * sine[i]);
                from[i] = 32;
                to[i] = i;
                from[i + 16] = i;
                to[i + 16] = (i + 1) % 16;
                from[i + 32] = i;
                to[i + 32] = (i + 1) % 16 + 16;
                from[i + 48] = i + 16;
                to[i + 48] = (i + 1) % 16 + 16;
                from[i + 64] = 33;
                to[i + 64] = i + 16;
            }
        } else {
            vert = new Vec3[18];
            from = new int[48];
            to = new int[48];
            vert[16] = new Vec3(0.0, y1, 0.0);
            vert[17] = new Vec3(0.0, y2, 0.0);
            for (int i = 0; i < 16; ++i) {
                vert[i] = new Vec3(this.rx * cosine[i], y1, this.rz * sine[i]);
                from[i] = 16;
                to[i] = i;
                from[i + 16] = i;
                to[i + 16] = (i + 1) % 16;
                from[i + 32] = i;
                to[i + 32] = 17;
            }
        }
        this.cachedWire = new WireframeMesh(vert, from, to);
        return this.cachedWire;
    }

    public int canConvertToTriangleMesh() {
        return 2;
    }

    public TriangleMesh convertToTriangleMesh(double tol) {
        int[][] faces;
        Vec3[] vertices;
        int i;
        Vec2[] v = new Vec2[4];
        double y1 = -this.height / 2.0;
        double y2 = this.height / 2.0;
        v[0] = new Vec2(this.rx, 0.0);
        v[1] = new Vec2(0.0, -this.rz);
        v[2] = new Vec2(-this.rx, 0.0);
        v[3] = new Vec2(0.0, this.rz);
        while (!this.withinTolerance(v, tol)) {
            Vec2[] vtemp = v;
            v = new Vec2[v.length * 2];
            for (i = 0; i < vtemp.length; ++i) {
                v[i * 2] = vtemp[i];
                double angle = Math.PI * 2 * ((double)i + 0.5) / (double)vtemp.length;
                v[i * 2 + 1] = new Vec2(this.rx * Math.cos(angle), -this.rz * Math.sin(angle));
            }
        }
        if (this.ratio == 0.0) {
            vertices = new Vec3[v.length + 2];
            faces = new int[v.length * 2][];
            vertices[0] = new Vec3(0.0, y1, 0.0);
            vertices[v.length + 1] = new Vec3(0.0, y2, 0.0);
            for (i = 0; i < v.length; ++i) {
                vertices[i + 1] = new Vec3(v[i].x, y1, v[i].y);
                faces[i] = new int[]{i + 2, i + 1, 0};
                faces[i + v.length] = new int[]{v.length + 1, i + 1, i + 2};
            }
            int[] nArray = faces[v.length - 1];
            nArray[0] = nArray[0] - v.length;
            int[] nArray2 = faces[v.length * 2 - 1];
            nArray2[2] = nArray2[2] - v.length;
        } else {
            vertices = new Vec3[v.length * 2 + 2];
            faces = new int[v.length * 4][];
            vertices[0] = new Vec3(0.0, y1, 0.0);
            vertices[v.length * 2 + 1] = new Vec3(0.0, y2, 0.0);
            for (i = 0; i < v.length; ++i) {
                vertices[i + 1] = new Vec3(v[i].x, y1, v[i].y);
                vertices[i + v.length + 1] = new Vec3(v[i].x * this.ratio, y2, v[i].y * this.ratio);
                faces[i] = new int[]{i + 2, i + 1, 0};
                faces[i + v.length] = new int[]{i + v.length + 1, i + 1, i + 2};
                faces[i + v.length * 2] = new int[]{i + v.length + 1, i + 2, i + v.length + 2};
                faces[i + v.length * 3] = new int[]{v.length * 2 + 1, i + v.length + 1, i + v.length + 2};
            }
            int[] nArray = faces[v.length - 1];
            nArray[0] = nArray[0] - v.length;
            int[] nArray3 = faces[v.length * 2 - 1];
            nArray3[2] = nArray3[2] - v.length;
            int[] nArray4 = faces[v.length * 3 - 1];
            nArray4[1] = nArray4[1] - v.length;
            int[] nArray5 = faces[v.length * 3 - 1];
            nArray5[2] = nArray5[2] - v.length;
            int[] nArray6 = faces[v.length * 4 - 1];
            nArray6[2] = nArray6[2] - v.length;
        }
        TriangleMesh mesh = new TriangleMesh(vertices, (int[][])faces);
        TriangleMesh.Edge[] edges = mesh.getEdges();
        for (i = 0; i < edges.length; ++i) {
            if (edges[i].v1 == 0 || edges[i].v2 == 0 || edges[i].v1 > v.length || edges[i].v2 > v.length) continue;
            edges[i].smoothness = 0.0f;
        }
        if (this.ratio != 0.0) {
            for (i = 0; i < edges.length; ++i) {
                if (edges[i].v1 == v.length * 2 + 1 || edges[i].v2 == v.length * 2 + 1 || edges[i].v1 <= v.length || edges[i].v2 <= v.length) continue;
                edges[i].smoothness = 0.0f;
            }
        }
        mesh.copyTextureAndMaterial(this);
        return mesh;
    }

    boolean withinTolerance(Vec2[] v, double tol) {
        Vec2 point = new Vec2(0.0, 0.0);
        Vec2 truePoint = new Vec2(0.0, 0.0);
        for (int i = 0; i < v.length / 2; ++i) {
            point.x = (v[i].x + v[i + 1].x) / 2.0;
            point.y = (v[i].y + v[i + 1].y) / 2.0;
            double angle = Math.PI * 2 * ((double)i + 0.5) / (double)v.length;
            truePoint.x = this.rx * Math.cos(angle);
            truePoint.y = -this.rz * Math.sin(angle);
            if (!(truePoint.distance(point) > tol)) continue;
            return false;
        }
        return true;
    }

    public RenderingMesh getRenderingMesh(double tol, boolean interactive, ObjectInfo info) {
        RenderingTriangle[] tri;
        Vec3[] norm;
        Vec3[] vert;
        int i;
        if (interactive && this.cachedMesh != null) {
            return this.cachedMesh;
        }
        double y1 = -this.height / 2.0;
        double y2 = this.height / 2.0;
        Vec2[] v = new Vec2[]{new Vec2(this.rx, 0.0), new Vec2(0.0, -this.rz), new Vec2(-this.rx, 0.0), new Vec2(0.0, this.rz)};
        while (!this.withinTolerance(v, tol)) {
            Vec2[] vtemp = v;
            v = new Vec2[v.length * 2];
            for (i = 0; i < vtemp.length; ++i) {
                v[i * 2] = vtemp[i];
                double angle = Math.PI * 2 * ((double)i + 0.5) / (double)vtemp.length;
                v[i * 2 + 1] = new Vec2(this.rx * Math.cos(angle), -this.rz * Math.sin(angle));
            }
        }
        if (this.ratio == 0.0) {
            vert = new Vec3[v.length + 2];
            norm = new Vec3[v.length + 1];
            tri = new RenderingTriangle[v.length * 2];
            vert[0] = new Vec3(0.0, y1, 0.0);
            vert[v.length + 1] = new Vec3(0.0, y2, 0.0);
            norm[0] = new Vec3(0.0, y1, 0.0);
            for (i = 0; i < v.length; ++i) {
                vert[i + 1] = new Vec3(v[i].x, y1, v[i].y);
                norm[i + 1] = new Vec3(v[i].x / (this.rx * this.rx), 1.0 / (y2 - y1), v[i].y / (this.rz * this.rz));
            }
            for (i = 0; i < v.length - 1; ++i) {
                tri[i] = this.texMapping.mapTriangle(i + 2, i + 1, 0, 0, 0, 0, vert);
                tri[i + v.length] = this.texMapping.mapTriangle(v.length + 1, i + 1, i + 2, i + 1, i + 1, i + 2, vert);
            }
            tri[v.length - 1] = this.texMapping.mapTriangle(1, v.length, 0, 0, 0, 0, vert);
            tri[v.length * 2 - 1] = this.texMapping.mapTriangle(v.length + 1, v.length, 1, v.length, v.length, 1, vert);
        } else {
            vert = new Vec3[v.length * 2 + 2];
            norm = new Vec3[v.length + 2];
            tri = new RenderingTriangle[v.length * 4];
            vert[0] = new Vec3(0.0, y1, 0.0);
            vert[v.length * 2 + 1] = new Vec3(0.0, y2, 0.0);
            norm[0] = new Vec3(0.0, y1, 0.0);
            norm[v.length + 1] = new Vec3(0.0, y2, 0.0);
            for (i = 0; i < v.length; ++i) {
                vert[i + 1] = new Vec3(v[i].x, y1, v[i].y);
                vert[i + v.length + 1] = new Vec3(v[i].x * this.ratio, y2, v[i].y * this.ratio);
                norm[i + 1] = new Vec3(v[i].x / (this.rx * this.rx), (1.0 - this.ratio) / (y2 - y1), v[i].y / (this.rz * this.rz));
            }
            for (i = 0; i < v.length - 1; ++i) {
                tri[i] = this.texMapping.mapTriangle(i + 2, i + 1, 0, 0, 0, 0, vert);
                tri[i + v.length] = this.texMapping.mapTriangle(i + v.length + 1, i + 1, i + 2, i + 1, i + 1, i + 2, vert);
                tri[i + v.length * 2] = this.texMapping.mapTriangle(i + v.length + 1, i + 2, i + v.length + 2, i + 1, i + 2, i + 2, vert);
                tri[i + v.length * 3] = this.texMapping.mapTriangle(v.length * 2 + 1, i + v.length + 1, i + v.length + 2, v.length + 1, v.length + 1, v.length + 1, vert);
            }
            tri[v.length - 1] = this.texMapping.mapTriangle(1, v.length, 0, 0, 0, 0, vert);
            tri[v.length * 2 - 1] = this.texMapping.mapTriangle(v.length * 2, v.length, 1, v.length, v.length, 1, vert);
            tri[v.length * 3 - 1] = this.texMapping.mapTriangle(v.length * 2, 1, v.length + 1, v.length, 1, 1, vert);
            tri[v.length * 4 - 1] = this.texMapping.mapTriangle(v.length * 2 + 1, v.length * 2, v.length + 1, v.length + 1, v.length + 1, v.length + 1, vert);
        }
        for (i = 0; i < norm.length; ++i) {
            norm[i].normalize();
        }
        RenderingMesh mesh = new RenderingMesh(vert, norm, tri, this.texMapping, this.matMapping);
        mesh.setParameters(this.paramValue);
        if (interactive) {
            this.cachedMesh = mesh;
        }
        return mesh;
    }

    public void setTexture(Texture tex, TextureMapping mapping) {
        super.setTexture(tex, mapping);
        this.cachedMesh = null;
        this.cachedWire = null;
    }

    public boolean isEditable() {
        return true;
    }

    public void edit(EditingWindow parent, ObjectInfo info, Runnable cb) {
        ValueField xField = new ValueField(this.rx, 3, 5);
        ValueField yField = new ValueField(this.rz, 3, 5);
        ValueField heightField = new ValueField(this.height, 3, 5);
        ValueSlider ratioSlider = new ValueSlider(0.0, 1.0, 100, this.ratio);
        ComponentsDialog dlg = new ComponentsDialog(parent.getFrame(), Translate.text("editCylinderTitle"), new Widget[]{xField, yField, ratioSlider, heightField}, new String[]{Translate.text("bottomRadiusX"), Translate.text("bottomRadiusZ"), Translate.text("radiusRatio"), Translate.text("Height")});
        if (!dlg.clickedOk()) {
            return;
        }
        this.ratio = ratioSlider.getValue();
        this.setSize(2.0 * xField.getValue(), heightField.getValue(), 2.0 * yField.getValue());
        cb.run();
    }

    public Cylinder(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.rx = in.readDouble();
        this.rz = in.readDouble();
        this.height = in.readDouble();
        this.ratio = in.readDouble();
        this.bounds = new BoundingBox(-this.rx, this.rx, -this.height / 2.0, this.height / 2.0, -this.rz, this.rz);
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
        out.writeDouble(this.rx);
        out.writeDouble(this.rz);
        out.writeDouble(this.height);
        out.writeDouble(this.ratio);
    }

    public Property[] getProperties() {
        return (Property[])PROPERTIES.clone();
    }

    public Object getPropertyValue(int index) {
        switch (index) {
            case 0: {
                return new Double(this.rx);
            }
            case 1: {
                return new Double(this.rz);
            }
            case 2: {
                return new Double(this.ratio);
            }
            case 3: {
                return new Double(this.height);
            }
        }
        return null;
    }

    public void setPropertyValue(int index, Object value) {
        double val = (Double)value;
        if (index == 0) {
            this.setSize(2.0 * val, this.height, 2.0 * this.rz);
        } else if (index == 1) {
            this.setSize(2.0 * this.rx, this.height, 2.0 * val);
        } else if (index == 2) {
            this.setRatio(val);
        } else if (index == 3) {
            this.setSize(2.0 * this.rx, val, 2.0 * this.rz);
        }
    }

    public Keyframe getPoseKeyframe() {
        return new CylinderKeyframe(this.rx, this.rz, this.height, this.ratio);
    }

    public void applyPoseKeyframe(Keyframe k) {
        CylinderKeyframe key = (CylinderKeyframe)k;
        this.ratio = key.ratio;
        this.setSize(2.0 * key.rx, key.height, 2.0 * key.ry);
    }

    public void configurePoseTrack(PoseTrack track) {
        track.setGraphableValues(new String[]{"X Radius", "Z Radius", "Height", "Ratio"}, new double[]{2.0 * this.rx, 2.0 * this.rz, this.height, this.ratio}, new double[][]{{0.0, Double.MAX_VALUE}, {0.0, Double.MAX_VALUE}, {0.0, Double.MAX_VALUE}, {0.0, 1.0}});
    }

    public String[] getPoseValueNames() {
        return new String[]{"X Radius", "Z Radius", "Height", "Ratio"};
    }

    public double[] getDefaultPoseValues() {
        return new double[]{2.0 * this.rx, 2.0 * this.rz, this.height, this.ratio};
    }

    public double[][] getPoseValueRange() {
        return new double[][]{{0.0, Double.MAX_VALUE}, {0.0, Double.MAX_VALUE}, {0.0, Double.MAX_VALUE}, {0.0, 1.0}};
    }

    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        CylinderKeyframe key = (CylinderKeyframe)k;
        ValueField xField = new ValueField(2.0 * key.rx, 3, 5);
        ValueField yField = new ValueField(2.0 * key.ry, 3, 5);
        ValueField heightField = new ValueField(key.height, 3, 5);
        ValueSlider ratioSlider = new ValueSlider(0.0, 1.0, 100, key.ratio);
        ComponentsDialog dlg = new ComponentsDialog(parent.getFrame(), Translate.text("editCylinderTitle"), new Widget[]{xField, yField, ratioSlider, heightField}, new String[]{Translate.text("bottomRadiusX"), Translate.text("bottomRadiusZ"), Translate.text("radiusRatio"), Translate.text("Height")});
        if (!dlg.clickedOk()) {
            return;
        }
        key.rx = 0.5 * xField.getValue();
        key.ry = 0.5 * yField.getValue();
        key.ratio = ratioSlider.getValue();
        key.height = heightField.getValue();
    }

    static {
        PROPERTIES = new Property[]{new Property(Translate.text("bottomRadiusX"), 0.0, Double.MAX_VALUE, 1.0), new Property(Translate.text("bottomRadiusZ"), 0.0, Double.MAX_VALUE, 1.0), new Property(Translate.text("radiusRatio"), 0.0, 1.0, 1.0), new Property(Translate.text("Height"), 0.0, Double.MAX_VALUE, 1.0)};
        sine = new double[16];
        cosine = new double[16];
        for (int i = 0; i < 16; ++i) {
            Cylinder.sine[i] = Math.sin((double)i * 2.0 * Math.PI / 16.0);
            Cylinder.cosine[i] = Math.cos((double)i * 2.0 * Math.PI / 16.0);
        }
    }

    public static class CylinderKeyframe
    implements Keyframe {
        public double rx;
        public double ry;
        public double ratio;
        public double height;

        public CylinderKeyframe(double rx, double ry, double height, double ratio) {
            this.rx = rx;
            this.ry = ry;
            this.height = height;
            this.ratio = ratio;
        }

        public Keyframe duplicate() {
            return new CylinderKeyframe(this.rx, this.ry, this.height, this.ratio);
        }

        public Keyframe duplicate(Object owner) {
            return new CylinderKeyframe(this.rx, this.ry, this.height, this.ratio);
        }

        public double[] getGraphValues() {
            return new double[]{this.rx, this.ry, this.height, this.ratio};
        }

        public void setGraphValues(double[] values) {
            this.rx = values[0];
            this.ry = values[1];
            this.height = values[2];
            this.ratio = values[3];
        }

        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            CylinderKeyframe k2 = (CylinderKeyframe)o2;
            return new CylinderKeyframe(weight1 * this.rx + weight2 * k2.rx, weight1 * this.ry + weight2 * k2.ry, weight1 * this.height + weight2 * k2.height, weight1 * this.ratio + weight2 * k2.ratio);
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            CylinderKeyframe k2 = (CylinderKeyframe)o2;
            CylinderKeyframe k3 = (CylinderKeyframe)o3;
            return new CylinderKeyframe(weight1 * this.rx + weight2 * k2.rx + weight3 * k3.rx, weight1 * this.ry + weight2 * k2.ry + weight3 * k3.ry, weight1 * this.height + weight2 * k2.height + weight3 * k3.height, weight1 * this.ratio + weight2 * k2.ratio + weight3 * k3.ratio);
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            CylinderKeyframe k2 = (CylinderKeyframe)o2;
            CylinderKeyframe k3 = (CylinderKeyframe)o3;
            CylinderKeyframe k4 = (CylinderKeyframe)o4;
            return new CylinderKeyframe(weight1 * this.rx + weight2 * k2.rx + weight3 * k3.rx + weight4 * k4.rx, weight1 * this.ry + weight2 * k2.ry + weight3 * k3.ry + weight4 * k4.ry, weight1 * this.height + weight2 * k2.height + weight3 * k3.height + weight4 * k4.height, weight1 * this.ratio + weight2 * k2.ratio + weight3 * k3.ratio + weight4 * k4.ratio);
        }

        public boolean equals(Keyframe k) {
            if (!(k instanceof CylinderKeyframe)) {
                return false;
            }
            CylinderKeyframe key = (CylinderKeyframe)k;
            return key.rx == this.rx && key.ry == this.ry && key.ratio == this.ratio && key.height == this.height;
        }

        public void writeToStream(DataOutputStream out) throws IOException {
            out.writeDouble(this.rx);
            out.writeDouble(this.ry);
            out.writeDouble(this.height);
            out.writeDouble(this.ratio);
        }

        public CylinderKeyframe(DataInputStream in, Object parent) throws IOException {
            this(in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble());
        }
    }
}

