/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.material;

import artofillusion.MaterialPreviewer;
import artofillusion.material.Material;
import artofillusion.material.MaterialSpec;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import buoy.widget.Widget;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class MaterialMapping {
    Object3D object;
    Material material;

    protected MaterialMapping(Object3D obj, Material mat) {
        this.object = obj;
        this.material = mat;
    }

    public abstract void writeToFile(DataOutputStream var1) throws IOException;

    public static String getName() {
        return "";
    }

    public double indexOfRefraction() {
        return this.material.indexOfRefraction();
    }

    public abstract double getStepSize();

    public boolean isScattering() {
        return this.material.isScattering();
    }

    public boolean castsShadows() {
        return this.material.castsShadows();
    }

    public Material getMaterial() {
        return this.material;
    }

    public Object3D getObject() {
        return this.object;
    }

    public abstract void getMaterialSpec(Vec3 var1, MaterialSpec var2, double var3, double var5);

    public abstract MaterialMapping duplicate();

    public abstract MaterialMapping duplicate(Object3D var1, Material var2);

    public abstract void copy(MaterialMapping var1);

    public abstract Widget getEditingPanel(Object3D var1, MaterialPreviewer var2);
}

