/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image.filter;

import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.image.ComplexImage;
import artofillusion.image.filter.ImageFilter;
import artofillusion.math.CoordinateSystem;
import artofillusion.object.SceneCamera;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.ValueChangedEvent;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class GlowFilter
extends ImageFilter {
    private int shape = 0;
    public static final int CROSSHAIR = 0;
    public static final int DIAGONAL = 1;
    public static final int STAR = 2;
    public static final int CIRCLE = 3;

    public String getName() {
        return Translate.text("Glow");
    }

    public void filterImage(ComplexImage image, Scene scene, SceneCamera camera, CoordinateSystem cameraPos) {
        if (this.shape == 3) {
            int radius = (int)(this.paramValue[0] * (double)image.getHeight());
            if (radius < 1) {
                return;
            }
            float[] mask = this.createCircularMask(radius);
            this.filterComponentCircular(image, 4, radius, mask);
            this.filterComponentCircular(image, 2, radius, mask);
            this.filterComponentCircular(image, 1, radius, mask);
        } else {
            this.filterComponent(image, 4);
            this.filterComponent(image, 2);
            this.filterComponent(image, 1);
        }
    }

    private void filterComponent(ComplexImage image, int component) {
        Thread currentThread = Thread.currentThread();
        int width = image.getWidth();
        int height = image.getHeight();
        int radius = (int)(this.paramValue[0] * (double)height);
        int diagonalRadius = (int)(this.paramValue[0] * (double)height * Math.sqrt(0.5));
        float intensity = (float)this.paramValue[1];
        float[] glow = new float[width * height];
        for (int i = 0; i < width; ++i) {
            if (currentThread.isInterrupted()) {
                return;
            }
            for (int j = 0; j < height; ++j) {
                float value = image.getPixelComponent(i, j, component);
                int n = i + j * width;
                glow[n] = glow[n] + value;
                if (value < 1.0f) continue;
                float maxIntensity = intensity * (value - 1.0f);
                if (this.shape == 0 || this.shape == 2) {
                    this.addGlowArm(glow, i, j, -1, 0, width, height, radius, maxIntensity);
                    this.addGlowArm(glow, i, j, 1, 0, width, height, radius, maxIntensity);
                    this.addGlowArm(glow, i, j, 0, -1, width, height, radius, maxIntensity);
                    this.addGlowArm(glow, i, j, 0, 1, width, height, radius, maxIntensity);
                }
                if (this.shape != 1 && this.shape != 2) continue;
                this.addGlowArm(glow, i, j, -1, -1, width, height, diagonalRadius, maxIntensity);
                this.addGlowArm(glow, i, j, 1, -1, width, height, diagonalRadius, maxIntensity);
                this.addGlowArm(glow, i, j, -1, 1, width, height, diagonalRadius, maxIntensity);
                this.addGlowArm(glow, i, j, 1, 1, width, height, diagonalRadius, maxIntensity);
            }
        }
        image.setComponentValues(component, glow);
    }

    private void addGlowArm(float[] glow, int x, int y, int xstep, int ystep, int width, int height, int radius, float intensity) {
        float intensityStep = intensity / (float)radius;
        for (int i = 0; i < radius; ++i) {
            if ((x += xstep) < 0 || (y += ystep) < 0 || x >= width || y >= height) {
                return;
            }
            int n = x + y * width;
            glow[n] = glow[n] + intensity;
            intensity -= intensityStep;
        }
    }

    private float[] createCircularMask(int radius) {
        int size = 2 * radius + 1;
        int radius2 = radius * radius;
        float intensity = (float)this.paramValue[1];
        float[] mask = new float[size * size];
        for (int i = 0; i < radius; ++i) {
            for (int j = 0; j < radius; ++j) {
                float value;
                int dist2 = i * i + j * j;
                if (dist2 > radius2) continue;
                float d = (float)dist2 / (float)radius2;
                mask[radius - i + (radius - j) * size] = value = intensity * (d * (d - 2.0f) + 1.0f);
                mask[radius + i + (radius - j) * size] = value;
                mask[radius - i + (radius + j) * size] = value;
                mask[radius + i + (radius + j) * size] = value;
            }
        }
        mask[radius + radius * size] = 0.0f;
        return mask;
    }

    private void filterComponentCircular(ComplexImage image, int component, int radius, float[] mask) {
        Thread currentThread = Thread.currentThread();
        int maskWidth = 2 * radius + 1;
        int width = image.getWidth();
        int height = image.getHeight();
        float[] glow = new float[width * height];
        for (int i = 0; i < width; ++i) {
            if (currentThread.isInterrupted()) {
                return;
            }
            for (int j = 0; j < height; ++j) {
                float value = image.getPixelComponent(i, j, component);
                int n = i + j * width;
                glow[n] = glow[n] + value;
                if (value < 1.0f) continue;
                float maxIntensity = value - 1.0f;
                int basex = i - radius;
                int basey = j - radius;
                int xstart = basex < 0 ? -basex : 0;
                int ystart = basey < 0 ? -basey : 0;
                int xend = basex + maskWidth >= width ? width - basex : maskWidth;
                int yend = basey + maskWidth >= height ? height - basey : maskWidth;
                for (int y = ystart; y < yend; ++y) {
                    int maskBase = y * maskWidth;
                    int imageBase = basex + (basey + y) * width;
                    for (int x = xstart; x < xend; ++x) {
                        int n2 = imageBase + x;
                        glow[n2] = glow[n2] + mask[maskBase + x] * maxIntensity;
                    }
                }
            }
        }
        image.setComponentValues(component, glow);
    }

    public TextureParameter[] getParameters() {
        return new TextureParameter[]{new TextureParameter(this, Translate.text("Radius"), 0.0, 1.0, 0.05), new TextureParameter(this, Translate.text("Intensity"), 0.0, 1.0, 0.5)};
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeInt(this.shape);
        out.writeDouble(this.paramValue[0]);
        out.writeDouble(this.paramValue[1]);
    }

    public void initFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.shape = in.readInt();
        this.paramValue[0] = in.readDouble();
        this.paramValue[1] = in.readDouble();
    }

    public Widget getConfigPanel(final Runnable changeCallback) {
        FormContainer form = new FormContainer(new double[]{0.0, 1.0}, new double[]{1.0, 1.0});
        form.add(super.getConfigPanel(changeCallback), 0, 0, 2, 1);
        form.add(new BLabel(Translate.text("Shape") + ": "), 0, 1);
        final BComboBox shapeChoice = new BComboBox(new String[]{Translate.text("Crosshairs"), Translate.text("Diagonal"), Translate.text("Star"), Translate.text("Circle")});
        form.add(shapeChoice, 1, 1, new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null));
        shapeChoice.setSelectedIndex(this.shape);
        shapeChoice.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                GlowFilter.this.shape = shapeChoice.getSelectedIndex();
                changeCallback.run();
            }
        });
        UIUtilities.applyBackground(form, null);
        return form;
    }
}

