/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image.filter;

import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.image.ComplexImage;
import artofillusion.image.filter.ImageFilter;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.object.SceneCamera;
import artofillusion.ui.Translate;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ExposureFilter
extends ImageFilter {
    public String getName() {
        return Translate.text("Exposure Correction");
    }

    public void filterImage(ComplexImage image, Scene scene, SceneCamera camera, CoordinateSystem cameraPos) {
        int width = image.getWidth();
        int height = image.getHeight();
        double exposure = this.paramValue[0];
        double gamma = exposure < 0.0 ? 1.0 / (1.0 - exposure) : exposure + 1.0;
        float[] red = new float[width * height];
        float[] green = new float[width * height];
        float[] blue = new float[width * height];
        RGBColor color = new RGBColor();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                float r = image.getPixelComponent(i, j, 4);
                float g = image.getPixelComponent(i, j, 2);
                float b = image.getPixelComponent(i, j, 1);
                color.setRGB(r, g, b);
                float[] hsv = color.getHSV();
                hsv[2] = (float)Math.pow(hsv[2], 1.0 / gamma);
                color.setHSV(hsv[0], hsv[1], hsv[2]);
                red[i + j * width] = color.getRed();
                green[i + j * width] = color.getGreen();
                blue[i + j * width] = color.getBlue();
            }
        }
        image.setComponentValues(4, red);
        image.setComponentValues(2, green);
        image.setComponentValues(1, blue);
    }

    public TextureParameter[] getParameters() {
        return new TextureParameter[]{new TextureParameter(this, this.getName(), -5.0, 5.0, 0.0)};
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeDouble(this.paramValue[0]);
    }

    public void initFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.paramValue[0] = in.readDouble();
    }
}

