/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation.distortion;

import artofillusion.animation.Actor;
import artofillusion.animation.Skeleton;
import artofillusion.animation.distortion.Distortion;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;

public class SkeletonShapeDistortion
implements Distortion {
    private Skeleton skeleton;
    private double weight;
    private Actor actor;
    private Distortion previous;

    public SkeletonShapeDistortion(Skeleton skeleton, double weight, Actor actor) {
        this.skeleton = skeleton;
        this.weight = weight;
        this.actor = actor;
    }

    public void setPreviousDistortion(Distortion previous) {
        this.previous = previous;
    }

    public boolean isIdenticalTo(Distortion d) {
        if (!(d instanceof SkeletonShapeDistortion)) {
            return false;
        }
        SkeletonShapeDistortion s = (SkeletonShapeDistortion)d;
        if (this.previous != null && !this.previous.isIdenticalTo(s.previous)) {
            return false;
        }
        if (this.previous == null && s.previous != null) {
            return false;
        }
        if (this.actor != s.actor) {
            return false;
        }
        if (this.weight != s.weight) {
            return false;
        }
        return this.skeleton.equals(s.skeleton);
    }

    public Distortion duplicate() {
        SkeletonShapeDistortion d = new SkeletonShapeDistortion(this.skeleton, this.weight, this.actor);
        if (this.previous != null) {
            d.previous = this.previous.duplicate();
        }
        return d;
    }

    public Mesh transform(Mesh obj) {
        if (this.previous != null) {
            obj = this.previous.transform(obj);
        }
        Mesh newmesh = (Mesh)((Object)obj.duplicate());
        Skeleton meshSkeleton = newmesh.getSkeleton();
        obj.getSkeleton().blend(meshSkeleton, new Skeleton[]{this.skeleton}, new double[]{this.weight});
        if (this.actor != null) {
            this.actor.shapeMeshFromGestures((Object3D)((Object)newmesh));
        } else {
            Skeleton.adjustMesh(obj, newmesh);
        }
        return newmesh;
    }
}

