/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.animation.Keyframe;
import artofillusion.math.Vec3;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class VectorKeyframe
extends Vec3
implements Keyframe {
    public VectorKeyframe() {
    }

    public VectorKeyframe(double xval, double yval, double zval) {
        super(xval, yval, zval);
    }

    public VectorKeyframe(Vec3 v) {
        super(v);
    }

    public Keyframe duplicate(Object owner) {
        return new VectorKeyframe(this);
    }

    public Keyframe duplicate() {
        return new VectorKeyframe(this);
    }

    public double[] getGraphValues() {
        return new double[]{this.x, this.y, this.z};
    }

    public void setGraphValues(double[] values) {
        if (values.length == 3) {
            this.set(values[0], values[1], values[2]);
        }
    }

    public Keyframe blend(Keyframe o2, double weight1, double weight2) {
        VectorKeyframe v2 = (VectorKeyframe)o2;
        return new VectorKeyframe(weight1 * this.x + weight2 * v2.x, weight1 * this.y + weight2 * v2.y, weight1 * this.z + weight2 * v2.z);
    }

    public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
        VectorKeyframe v2 = (VectorKeyframe)o2;
        VectorKeyframe v3 = (VectorKeyframe)o3;
        return new VectorKeyframe(weight1 * this.x + weight2 * v2.x + weight3 * v3.x, weight1 * this.y + weight2 * v2.y + weight3 * v3.y, weight1 * this.z + weight2 * v2.z + weight3 * v3.z);
    }

    public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
        VectorKeyframe v2 = (VectorKeyframe)o2;
        VectorKeyframe v3 = (VectorKeyframe)o3;
        VectorKeyframe v4 = (VectorKeyframe)o4;
        return new VectorKeyframe(weight1 * this.x + weight2 * v2.x + weight3 * v3.x + weight4 * v4.x, weight1 * this.y + weight2 * v2.y + weight3 * v3.y + weight4 * v4.y, weight1 * this.z + weight2 * v2.z + weight3 * v3.z + weight4 * v4.z);
    }

    public boolean equals(Keyframe k) {
        if (!(k instanceof VectorKeyframe)) {
            return false;
        }
        VectorKeyframe key = (VectorKeyframe)k;
        return this.equals((Vec3)((Object)k));
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        super.writeToFile(out);
    }

    public VectorKeyframe(DataInputStream in, Object parent) throws IOException {
        super(in);
    }
}

