/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ListChangeListener;
import artofillusion.MaterialsDialog;
import artofillusion.ModellingApp;
import artofillusion.SafeFileOutputStream;
import artofillusion.TextureParameter;
import artofillusion.TexturesDialog;
import artofillusion.UndoRecord;
import artofillusion.animation.PoseTrack;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.animation.Track;
import artofillusion.image.ImageMap;
import artofillusion.image.MIPMappedImage;
import artofillusion.material.Material;
import artofillusion.material.UniformMaterial;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.NullObject;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.Sphere;
import artofillusion.texture.ConstantParameterValue;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.UniformTexture;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.Translate;
import buoy.widget.BFrame;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Scene {
    private Vector objects;
    private Vector materials;
    private Vector textures;
    private Vector images;
    private Vector selection;
    private Vector textureListeners;
    private Vector materialListeners;
    private RGBColor ambientColor;
    private RGBColor environColor;
    private RGBColor fogColor;
    private Texture environTexture;
    private TextureMapping environMapping;
    private int gridSubdivisions;
    private int environMode;
    private int framesPerSecond;
    private int nextID;
    private double fogDist;
    private double gridSpacing;
    private double time;
    private boolean fog;
    private boolean showGrid;
    private boolean snapToGrid;
    private boolean errorsLoading;
    private String name;
    private String directory;
    private TexturesDialog texDlg;
    private MaterialsDialog matDlg;
    private ParameterValue[] environParamValue;
    private StringBuffer loadingErrors;
    public static final int HANDLE_SIZE = 4;
    public static final int ENVIRON_SOLID = 0;
    public static final int ENVIRON_DIFFUSE = 1;
    public static final int ENVIRON_EMISSIVE = 2;
    static /* synthetic */ Class class$artofillusion$object$ObjectInfo;

    public Scene() {
        UniformTexture defTex = new UniformTexture();
        this.objects = new Vector();
        this.materials = new Vector();
        this.textures = new Vector();
        this.images = new Vector();
        this.selection = new Vector();
        this.textureListeners = new Vector();
        this.materialListeners = new Vector();
        defTex.setName("Default Texture");
        this.textures.addElement(defTex);
        this.ambientColor = new RGBColor(0.3f, 0.3f, 0.3f);
        this.environColor = new RGBColor(0.0f, 0.0f, 0.0f);
        this.environTexture = defTex;
        this.environMapping = defTex.getDefaultMapping(new Sphere(1.0, 1.0, 1.0));
        this.environParamValue = new ParameterValue[0];
        this.environMode = 0;
        this.fogColor = new RGBColor(0.3f, 0.3f, 0.3f);
        this.fogDist = 20.0;
        this.fog = false;
        this.framesPerSecond = 30;
        this.nextID = 1;
        this.snapToGrid = false;
        this.showGrid = false;
        this.gridSpacing = 1.0;
        this.gridSubdivisions = 10;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String newDir) {
        this.directory = newDir;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double t) {
        this.time = t;
        boolean[] changed = new boolean[this.objects.size()];
        for (int i = 0; i < this.objects.size(); ++i) {
            ObjectInfo info = (ObjectInfo)this.objects.elementAt(i);
            if (info.parent != null) continue;
            this.applyTracksToObject(info, changed, i);
        }
    }

    public void applyTracksToObject(ObjectInfo info) {
        this.applyTracksToObject(info, null, 0);
    }

    private void applyTracksToObject(ObjectInfo info, boolean[] changed, int index) {
        int j;
        if (changed != null) {
            if (changed[index]) {
                info.object.sceneChanged(info, this);
                return;
            }
            changed[index] = true;
        }
        boolean hasPos = false;
        boolean hasRot = false;
        boolean hasPose = false;
        for (j = 0; j < info.tracks.length; ++j) {
            if (info.tracks[j].isNullTrack() || !info.tracks[j].isEnabled()) continue;
            if (changed != null) {
                ObjectInfo[] depends = info.tracks[j].getDependencies();
                for (int i = 0; i < depends.length; ++i) {
                    int k = this.objects.indexOf(depends[i]);
                    if (k <= -1 || changed[k]) continue;
                    this.applyTracksToObject(depends[i], changed, k);
                }
            }
            if (info.tracks[j] instanceof PositionTrack) {
                hasPos = true;
                continue;
            }
            if (info.tracks[j] instanceof RotationTrack) {
                hasRot = true;
                continue;
            }
            if (!(info.tracks[j] instanceof PoseTrack)) continue;
            hasPose = true;
        }
        if (hasPos) {
            Vec3 orig = info.coords.getOrigin();
            orig.set(0.0, 0.0, 0.0);
            info.coords.setOrigin(orig);
        }
        if (hasRot) {
            info.coords.setOrientation(0.0, 0.0, 0.0);
        }
        if (hasPose) {
            info.clearCachedMeshes();
        }
        info.pose = null;
        info.clearDistortion();
        for (j = info.tracks.length - 1; j >= 0; --j) {
            if (!info.tracks[j].isEnabled()) continue;
            info.tracks[j].apply(this.time);
        }
        if (info.pose != null) {
            info.object.applyPoseKeyframe(info.pose);
        }
        info.object.sceneChanged(info, this);
        for (int i = 0; i < info.children.length; ++i) {
            this.applyTracksToObject(info.children[i]);
        }
    }

    public int getFramesPerSecond() {
        return this.framesPerSecond;
    }

    public void setFramesPerSecond(int n) {
        this.framesPerSecond = n;
    }

    public RGBColor getAmbientColor() {
        return this.ambientColor;
    }

    public void setAmbientColor(RGBColor color) {
        this.ambientColor = color;
    }

    public int getEnvironmentMode() {
        return this.environMode;
    }

    public void setEnvironmentMode(int mode) {
        this.environMode = mode;
    }

    public Texture getEnvironmentTexture() {
        return this.environTexture;
    }

    public void setEnvironmentTexture(Texture tex) {
        this.environTexture = tex;
    }

    public TextureMapping getEnvironmentMapping() {
        return this.environMapping;
    }

    public void setEnvironmentMapping(TextureMapping map) {
        this.environMapping = map;
    }

    public ParameterValue[] getEnvironmentParameterValues() {
        return this.environParamValue;
    }

    public void setEnvironmentParameterValues(ParameterValue[] value) {
        this.environParamValue = value;
    }

    public RGBColor getEnvironmentColor() {
        return this.environColor;
    }

    public void setEnvironmentColor(RGBColor color) {
        this.environColor = color;
    }

    public RGBColor getFogColor() {
        return this.fogColor;
    }

    public void setFogColor(RGBColor color) {
        this.fogColor = color;
    }

    public boolean getFogState() {
        return this.fog;
    }

    public double getFogDistance() {
        return this.fogDist;
    }

    public void setFog(boolean state, double dist) {
        this.fog = state;
        this.fogDist = dist;
    }

    public boolean getShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean show) {
        this.showGrid = show;
    }

    public boolean getSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean snap) {
        this.snapToGrid = snap;
    }

    public double getGridSpacing() {
        return this.gridSpacing;
    }

    public void setGridSpacing(double spacing) {
        this.gridSpacing = spacing;
    }

    public int getGridSubdivisions() {
        return this.gridSubdivisions;
    }

    public void setGridSubdivisions(int subdivisions) {
        this.gridSubdivisions = subdivisions;
    }

    public void addObject(Object3D obj, CoordinateSystem coords, String name, UndoRecord undo) {
        this.addObject(new ObjectInfo(obj, coords, name), undo);
        this.updateSelectionInfo();
    }

    public void addObject(ObjectInfo info, UndoRecord undo) {
        this.addObject(info, this.objects.size(), undo);
        this.updateSelectionInfo();
    }

    public void addObject(ObjectInfo info, int index, UndoRecord undo) {
        info.id = this.nextID++;
        if (info.tracks == null) {
            info.addTrack(new PositionTrack(info), 0);
            info.addTrack(new RotationTrack(info), 1);
        }
        if (info.object.canSetTexture() && info.object.getTextureMapping() == null) {
            info.setTexture(this.getDefaultTexture(), this.getDefaultTexture().getDefaultMapping(info.object));
        }
        info.object.sceneChanged(info, this);
        this.objects.insertElementAt(info, index);
        if (undo != null) {
            undo.addCommandAtBeginning(5, new Object[]{new Integer(index)});
        }
        this.updateSelectionInfo();
    }

    public void removeObject(int which, UndoRecord undo) {
        ObjectInfo info = (ObjectInfo)this.objects.elementAt(which);
        this.objects.removeElementAt(which);
        if (undo != null) {
            undo.addCommandAtBeginning(4, new Object[]{info, new Integer(which)});
        }
        if (info.parent != null) {
            int j = 0;
            while (info.parent.children[j] != info) {
                ++j;
            }
            if (undo != null) {
                undo.addCommandAtBeginning(7, new Object[]{info.parent, info, new Integer(j)});
            }
            info.parent.removeChild(j);
        }
        for (int i = 0; i < this.objects.size(); ++i) {
            ObjectInfo obj = (ObjectInfo)this.objects.elementAt(i);
            for (int j = 0; j < obj.tracks.length; ++j) {
                Track tr = obj.tracks[j];
                ObjectInfo[] depends = tr.getDependencies();
                for (int k = 0; k < depends.length; ++k) {
                    if (depends[k] != info) continue;
                    if (undo != null) {
                        undo.addCommandAtBeginning(12, new Object[]{tr, tr.duplicate(tr.getParent())});
                    }
                    obj.tracks[j].deleteDependencies(info);
                }
            }
        }
        this.clearSelection();
    }

    public void addMaterial(Material mat) {
        this.materials.addElement(mat);
        for (int i = 0; i < this.materialListeners.size(); ++i) {
            ((ListChangeListener)this.materialListeners.elementAt(i)).itemAdded(this.materials.size() - 1, mat);
        }
    }

    public void removeMaterial(int which) {
        int i;
        Material mat = (Material)this.materials.elementAt(which);
        this.materials.removeElementAt(which);
        for (i = 0; i < this.materialListeners.size(); ++i) {
            ((ListChangeListener)this.materialListeners.elementAt(i)).itemRemoved(which, mat);
        }
        for (i = 0; i < this.objects.size(); ++i) {
            ObjectInfo obj = (ObjectInfo)this.objects.elementAt(i);
            if (obj.object.getMaterial() != mat) continue;
            obj.setMaterial(null, null);
        }
    }

    public void addTexture(Texture tex) {
        this.textures.addElement(tex);
        for (int i = 0; i < this.textureListeners.size(); ++i) {
            ((ListChangeListener)this.textureListeners.elementAt(i)).itemAdded(this.textures.size() - 1, tex);
        }
    }

    public void removeTexture(int which) {
        int i;
        Texture tex = (Texture)this.textures.elementAt(which);
        this.textures.removeElementAt(which);
        for (int i2 = 0; i2 < this.textureListeners.size(); ++i2) {
            ((ListChangeListener)this.textureListeners.elementAt(i2)).itemRemoved(which, tex);
        }
        if (this.textures.size() == 0) {
            UniformTexture defTex = new UniformTexture();
            defTex.setName("Default Texture");
            this.textures.addElement(defTex);
            for (i = 0; i < this.textureListeners.size(); ++i) {
                ((ListChangeListener)this.textureListeners.elementAt(i)).itemAdded(0, defTex);
            }
        }
        Texture def = (Texture)this.textures.elementAt(0);
        for (i = 0; i < this.objects.size(); ++i) {
            ObjectInfo obj = (ObjectInfo)this.objects.elementAt(i);
            if (obj.object.getTexture() != tex) continue;
            obj.setTexture(def, def.getDefaultMapping(obj.object));
        }
        if (this.environTexture == tex) {
            this.environTexture = def;
            this.environMapping = def.getDefaultMapping(new Sphere(1.0, 1.0, 1.0));
        }
    }

    public void changeMaterial(int which) {
        int i;
        Material mat = (Material)this.materials.elementAt(which);
        for (i = 0; i < this.objects.size(); ++i) {
            Object3D obj = ((ObjectInfo)this.objects.elementAt((int)i)).object;
            if (obj.getMaterial() != mat) continue;
            obj.setMaterial(mat, obj.getMaterialMapping());
        }
        for (i = 0; i < this.materialListeners.size(); ++i) {
            ((ListChangeListener)this.materialListeners.elementAt(i)).itemChanged(which, mat);
        }
    }

    public void changeTexture(int which) {
        int i;
        Texture tex = (Texture)this.textures.elementAt(which);
        for (i = 0; i < this.objects.size(); ++i) {
            ObjectInfo obj = (ObjectInfo)this.objects.elementAt(i);
            if (obj.object.getTexture() != tex) continue;
            obj.setTexture(tex, obj.object.getTextureMapping());
        }
        for (i = 0; i < this.textureListeners.size(); ++i) {
            ((ListChangeListener)this.textureListeners.elementAt(i)).itemChanged(which, tex);
        }
    }

    public void addMaterialListener(ListChangeListener ls) {
        this.materialListeners.addElement(ls);
    }

    public void removeMaterialListener(ListChangeListener ls) {
        this.materialListeners.removeElement(ls);
    }

    public void addTextureListener(ListChangeListener ls) {
        this.textureListeners.addElement(ls);
    }

    public void removeTextureListener(ListChangeListener ls) {
        this.textureListeners.removeElement(ls);
    }

    public void showTexturesDialog(BFrame parent) {
        if (this.texDlg == null) {
            this.texDlg = new TexturesDialog(parent, this);
        } else {
            Rectangle r = this.texDlg.getBounds();
            this.texDlg.dispose();
            this.texDlg = new TexturesDialog(parent, this);
            this.texDlg.setBounds(r);
        }
        this.texDlg.setVisible(true);
    }

    public void showMaterialsDialog(BFrame parent) {
        if (this.matDlg == null) {
            this.matDlg = new MaterialsDialog(parent, this);
        } else {
            Rectangle r = this.matDlg.getBounds();
            this.matDlg.dispose();
            this.matDlg = new MaterialsDialog(parent, this);
            this.matDlg.setBounds(r);
        }
        this.matDlg.setVisible(true);
    }

    public void addImage(ImageMap im) {
        this.images.addElement(im);
    }

    public boolean removeImage(int which) {
        int i;
        ImageMap image = (ImageMap)this.images.elementAt(which);
        for (i = 0; i < this.textures.size(); ++i) {
            if (!((Texture)this.textures.elementAt(i)).usesImage(image)) continue;
            return false;
        }
        for (i = 0; i < this.materials.size(); ++i) {
            if (!((Material)this.materials.elementAt(i)).usesImage(image)) continue;
            return false;
        }
        this.images.removeElementAt(which);
        return true;
    }

    public void replaceObject(Object3D original, Object3D replaceWith, UndoRecord undo) {
        for (int i = 0; i < this.objects.size(); ++i) {
            ObjectInfo info = (ObjectInfo)this.objects.elementAt(i);
            if (info.object != original) continue;
            if (undo != null) {
                undo.addCommand(3, new Object[]{info, original});
            }
            info.object = replaceWith;
            info.clearCachedMeshes();
        }
    }

    public void objectModified(Object3D obj) {
        for (int i = 0; i < this.objects.size(); ++i) {
            ObjectInfo info = (ObjectInfo)this.objects.elementAt(i);
            if (info.object != obj) continue;
            info.clearCachedMeshes();
            info.pose = null;
        }
    }

    public void setSelection(int which) {
        this.clearSelection();
        this.addToSelection(which);
        this.updateSelectionInfo();
    }

    public void setSelection(int[] which) {
        this.clearSelection();
        for (int i = 0; i < which.length; ++i) {
            this.addToSelection(which[i]);
        }
        this.updateSelectionInfo();
    }

    public void addToSelection(int which) {
        ObjectInfo info = (ObjectInfo)this.objects.elementAt(which);
        if (!info.selected) {
            this.selection.addElement(new Integer(which));
        }
        info.selected = true;
        this.updateSelectionInfo();
    }

    public void clearSelection() {
        this.selection.removeAllElements();
        for (int i = 0; i < this.objects.size(); ++i) {
            ((ObjectInfo)this.objects.elementAt((int)i)).selected = false;
        }
        this.updateSelectionInfo();
    }

    public void removeFromSelection(int which) {
        ObjectInfo info = (ObjectInfo)this.objects.elementAt(which);
        this.selection.removeElement(new Integer(which));
        info.selected = false;
        this.updateSelectionInfo();
    }

    private void updateSelectionInfo() {
        int i;
        for (i = this.objects.size() - 1; i >= 0; --i) {
            ((ObjectInfo)this.objects.elementAt((int)i)).parentSelected = false;
        }
        block1: for (i = this.objects.size() - 1; i >= 0; --i) {
            ObjectInfo info = (ObjectInfo)this.objects.elementAt(i);
            ObjectInfo parent = info.parent;
            while (parent != null) {
                if (parent.selected || parent.parentSelected) {
                    info.parentSelected = true;
                    continue block1;
                }
                parent = parent.parent;
            }
        }
    }

    public int getNumObjects() {
        return this.objects.size();
    }

    public ObjectInfo getObject(int i) {
        return (ObjectInfo)this.objects.elementAt(i);
    }

    public ObjectInfo getObject(String name) {
        for (int i = 0; i < this.objects.size(); ++i) {
            ObjectInfo info = (ObjectInfo)this.objects.elementAt(i);
            if (!info.name.equals(name)) continue;
            return info;
        }
        return null;
    }

    public int indexOf(ObjectInfo info) {
        return this.objects.indexOf(info);
    }

    public int getNumTextures() {
        return this.textures.size();
    }

    public int indexOf(Texture tex) {
        return this.textures.indexOf(tex);
    }

    public Texture getTexture(int i) {
        return (Texture)this.textures.elementAt(i);
    }

    public Texture getTexture(String name) {
        for (int i = 0; i < this.textures.size(); ++i) {
            Texture tex = (Texture)this.textures.elementAt(i);
            if (!tex.getName().equals(name)) continue;
            return tex;
        }
        return null;
    }

    public int getNumMaterials() {
        return this.materials.size();
    }

    public Material getMaterial(int i) {
        return (Material)this.materials.elementAt(i);
    }

    public Material getMaterial(String name) {
        for (int i = 0; i < this.materials.size(); ++i) {
            Material mat = (Material)this.materials.elementAt(i);
            if (!mat.getName().equals(name)) continue;
            return mat;
        }
        return null;
    }

    public int indexOf(Material mat) {
        return this.materials.indexOf(mat);
    }

    public int getNumImages() {
        return this.images.size();
    }

    public ImageMap getImage(int i) {
        return (ImageMap)this.images.elementAt(i);
    }

    public int indexOf(ImageMap im) {
        return this.images.indexOf(im);
    }

    public Texture getDefaultTexture() {
        return (Texture)this.textures.elementAt(0);
    }

    public int[] getSelection() {
        int[] sel = new int[this.selection.size()];
        for (int i = 0; i < sel.length; ++i) {
            sel[i] = (Integer)this.selection.elementAt(i);
        }
        return sel;
    }

    public int[] getSelectionWithChildren() {
        int count = 0;
        for (int i = this.objects.size() - 1; i >= 0; --i) {
            ObjectInfo info = (ObjectInfo)this.objects.elementAt(i);
            if (!info.selected && !info.parentSelected) continue;
            ++count;
        }
        int[] sel = new int[count];
        count = 0;
        for (int i = this.objects.size() - 1; i >= 0; --i) {
            ObjectInfo info = (ObjectInfo)this.objects.elementAt(i);
            if (!info.selected && !info.parentSelected) continue;
            sel[count++] = i;
        }
        return sel;
    }

    public boolean errorsOccurredInLoading() {
        return this.errorsLoading;
    }

    public String getLoadingErrors() {
        return this.loadingErrors == null ? "" : this.loadingErrors.toString();
    }

    public Scene(File f, boolean fullScene) throws IOException, InvalidObjectException {
        DataInputStream in = new DataInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(f))));
        this.initFromStream(in, fullScene);
        in.close();
        this.setName(f.getName());
        this.setDirectory(f.getParent());
    }

    public Scene(DataInputStream in, boolean fullScene) throws IOException, InvalidObjectException {
        this.initFromStream(in, fullScene);
    }

    private void initFromStream(DataInputStream in, boolean fullScene) throws IOException, InvalidObjectException {
        byte[] bytes;
        int len;
        Constructor con;
        Class cls;
        String classname;
        int i;
        short version = in.readShort();
        if (version < 0 || version > 3) {
            throw new InvalidObjectException("");
        }
        this.loadingErrors = new StringBuffer();
        this.ambientColor = new RGBColor(in);
        this.fogColor = new RGBColor(in);
        this.fog = in.readBoolean();
        this.fogDist = in.readDouble();
        this.showGrid = in.readBoolean();
        this.snapToGrid = in.readBoolean();
        this.gridSpacing = in.readDouble();
        this.gridSubdivisions = in.readInt();
        this.framesPerSecond = in.readInt();
        this.nextID = 1;
        int count = in.readInt();
        this.images = new Vector(count);
        for (i = 0; i < count; ++i) {
            if (version == 0) {
                this.images.addElement(new MIPMappedImage(in, 0));
                continue;
            }
            classname = in.readUTF();
            try {
                cls = ModellingApp.getClass(classname);
                if (cls == null) {
                    throw new IOException("Unknown class: " + classname);
                }
                con = cls.getConstructor(class$java$io$DataInputStream == null ? Scene.class$("java.io.DataInputStream") : class$java$io$DataInputStream);
                this.images.addElement(con.newInstance(in));
                continue;
            }
            catch (Exception ex) {
                throw new IOException("Error loading image: " + ex.getMessage());
            }
        }
        count = in.readInt();
        this.materials = new Vector(count);
        for (i = 0; i < count; ++i) {
            try {
                classname = in.readUTF();
                len = in.readInt();
                bytes = new byte[len];
                in.readFully(bytes);
                cls = ModellingApp.getClass(classname);
                try {
                    if (cls == null) {
                        throw new IOException("Unknown class: " + classname);
                    }
                    con = cls.getConstructor(class$java$io$DataInputStream == null ? Scene.class$("java.io.DataInputStream") : class$java$io$DataInputStream, class$artofillusion$Scene == null ? Scene.class$("artofillusion.Scene") : class$artofillusion$Scene);
                    this.materials.addElement(con.newInstance(new DataInputStream(new ByteArrayInputStream(bytes)), this));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (ex instanceof ClassNotFoundException) {
                        this.loadingErrors.append(Translate.text("errorFindingClass", classname)).append('\n');
                    } else {
                        this.loadingErrors.append(Translate.text("errorInstantiatingClass", classname)).append('\n');
                    }
                    UniformMaterial m = new UniformMaterial();
                    m.setName("<unreadable>");
                    this.materials.addElement(m);
                    this.errorsLoading = true;
                }
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IOException();
            }
        }
        count = in.readInt();
        this.textures = new Vector(count);
        for (i = 0; i < count; ++i) {
            try {
                classname = in.readUTF();
                len = in.readInt();
                bytes = new byte[len];
                in.readFully(bytes);
                cls = ModellingApp.getClass(classname);
                try {
                    if (cls == null) {
                        throw new IOException("Unknown class: " + classname);
                    }
                    con = cls.getConstructor(class$java$io$DataInputStream == null ? Scene.class$("java.io.DataInputStream") : class$java$io$DataInputStream, class$artofillusion$Scene == null ? Scene.class$("artofillusion.Scene") : class$artofillusion$Scene);
                    this.textures.addElement(con.newInstance(new DataInputStream(new ByteArrayInputStream(bytes)), this));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (ex instanceof ClassNotFoundException) {
                        this.loadingErrors.append(Translate.text("errorFindingClass", classname)).append('\n');
                    } else {
                        this.loadingErrors.append(Translate.text("errorInstantiatingClass", classname)).append('\n');
                    }
                    UniformTexture t = new UniformTexture();
                    t.setName("<unreadable>");
                    this.textures.addElement(t);
                    this.errorsLoading = true;
                }
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IOException();
            }
        }
        count = in.readInt();
        this.objects = new Vector(count);
        Hashtable table = new Hashtable(count);
        for (i = 0; i < count; ++i) {
            this.objects.addElement(this.readObjectFromFile(in, table, version));
        }
        this.selection = new Vector();
        for (i = 0; i < this.objects.size(); ++i) {
            ObjectInfo info = (ObjectInfo)this.objects.elementAt(i);
            int num = in.readInt();
            for (int j = 0; j < num; ++j) {
                ObjectInfo child = (ObjectInfo)this.objects.elementAt(in.readInt());
                info.addChild(child, j);
            }
        }
        this.environMode = in.readShort();
        if (this.environMode == 0) {
            this.environColor = new RGBColor(in);
            this.environTexture = (Texture)this.textures.elementAt(0);
            this.environMapping = this.environTexture.getDefaultMapping(new Sphere(1.0, 1.0, 1.0));
            this.environParamValue = new ParameterValue[0];
        } else {
            int texIndex = in.readInt();
            if (texIndex == -1) {
                Sphere sphere = new Sphere(1.0, 1.0, 1.0);
                this.environTexture = new LayeredTexture(sphere);
                String mapClassName = in.readUTF();
                if (!LayeredMapping.class.getName().equals(mapClassName)) {
                    throw new InvalidObjectException("");
                }
                this.environMapping = this.environTexture.getDefaultMapping(sphere);
                ((LayeredMapping)this.environMapping).readFromFile(in, this);
            } else {
                this.environTexture = (Texture)this.textures.elementAt(texIndex);
                try {
                    Class mapClass = ModellingApp.getClass(in.readUTF());
                    con = mapClass.getConstructor(DataInputStream.class, Object3D.class, Texture.class);
                    this.environMapping = (TextureMapping)con.newInstance(in, new Sphere(1.0, 1.0, 1.0), this.environTexture);
                }
                catch (Exception ex) {
                    throw new IOException();
                }
            }
            this.environColor = new RGBColor(0.0f, 0.0f, 0.0f);
            this.environParamValue = new ParameterValue[this.environMapping.getParameters().length];
            if (version > 2) {
                for (i = 0; i < this.environParamValue.length; ++i) {
                    this.environParamValue[i] = Object3D.readParameterValue(in);
                }
            }
        }
        this.textureListeners = new Vector();
        this.materialListeners = new Vector();
        this.setTime(0.0);
    }

    private ObjectInfo readObjectFromFile(DataInputStream in, Hashtable table, int version) throws IOException, InvalidObjectException {
        Constructor con;
        Class cls;
        ObjectInfo info = new ObjectInfo(null, new CoordinateSystem(in), in.readUTF());
        info.id = in.readInt();
        if (info.id >= this.nextID) {
            this.nextID = info.id + 1;
        }
        info.visible = in.readBoolean();
        Integer key = new Integer(in.readInt());
        Object3D obj = (Object3D)table.get(key);
        if (obj == null) {
            try {
                String classname = in.readUTF();
                int len = in.readInt();
                byte[] bytes = new byte[len];
                in.readFully(bytes);
                try {
                    cls = ModellingApp.getClass(classname);
                    con = cls.getConstructor(DataInputStream.class, Scene.class);
                    obj = (Object3D)con.newInstance(new DataInputStream(new ByteArrayInputStream(bytes)), this);
                }
                catch (Exception ex) {
                    if (ex instanceof InvocationTargetException) {
                        ((InvocationTargetException)ex).getTargetException().printStackTrace();
                    } else {
                        ex.printStackTrace();
                    }
                    if (ex instanceof ClassNotFoundException) {
                        this.loadingErrors.append(info.name).append(": ").append(Translate.text("errorFindingClass", classname)).append('\n');
                    } else {
                        this.loadingErrors.append(info.name).append(": ").append(Translate.text("errorInstantiatingClass", classname)).append('\n');
                    }
                    obj = new NullObject();
                    info.name = "<unreadable> " + info.name;
                    this.errorsLoading = true;
                }
                table.put(key, obj);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IOException();
            }
        }
        info.object = obj;
        if (version < 2 && obj.getTexture() != null) {
            int i;
            TextureParameter[] texParam = obj.getTextureMapping().getParameters();
            ParameterValue[] paramValue = obj.getParameterValues();
            double[] val = new double[paramValue.length];
            boolean[] perVertex = new boolean[paramValue.length];
            for (i = 0; i < val.length; ++i) {
                val[i] = in.readDouble();
            }
            for (i = 0; i < perVertex.length; ++i) {
                perVertex[i] = in.readBoolean();
            }
            for (i = 0; i < paramValue.length; ++i) {
                if (paramValue[i] != null) continue;
                paramValue[i] = perVertex[i] ? new VertexParameterValue((Mesh)((Object)obj), texParam[i]) : new ConstantParameterValue(val[i]);
            }
            obj.setParameterValues(paramValue);
        }
        int tracks = in.readInt();
        try {
            for (int i = 0; i < tracks; ++i) {
                cls = ModellingApp.getClass(in.readUTF());
                con = cls.getConstructor(class$artofillusion$object$ObjectInfo == null ? Scene.class$("artofillusion.object.ObjectInfo") : class$artofillusion$object$ObjectInfo);
                Track tr = (Track)con.newInstance(info);
                tr.initFromStream(in, this);
                info.addTrack(tr, i);
            }
            if (info.tracks == null) {
                info.tracks = new Track[0];
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException();
        }
        return info;
    }

    public void writeToFile(File f) throws IOException {
        int mode = ModellingApp.getPreferences().getKeepBackupFiles() ? 128 : 0;
        SafeFileOutputStream safeOut = new SafeFileOutputStream(f, mode);
        DataOutputStream out = new DataOutputStream(new GZIPOutputStream(new BufferedOutputStream(safeOut)));
        this.writeToStream(out);
        out.close();
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        byte[] bytes;
        ByteArrayOutputStream bos;
        int i;
        int index = 0;
        Hashtable table = new Hashtable(this.objects.size());
        out.writeShort(3);
        this.ambientColor.writeToFile(out);
        this.fogColor.writeToFile(out);
        out.writeBoolean(this.fog);
        out.writeDouble(this.fogDist);
        out.writeBoolean(this.showGrid);
        out.writeBoolean(this.snapToGrid);
        out.writeDouble(this.gridSpacing);
        out.writeInt(this.gridSubdivisions);
        out.writeInt(this.framesPerSecond);
        out.writeInt(this.images.size());
        for (i = 0; i < this.images.size(); ++i) {
            ImageMap img = (ImageMap)this.images.elementAt(i);
            out.writeUTF(img.getClass().getName());
            img.writeToStream(out);
        }
        out.writeInt(this.materials.size());
        for (i = 0; i < this.materials.size(); ++i) {
            Material mat = (Material)this.materials.elementAt(i);
            out.writeUTF(mat.getClass().getName());
            bos = new ByteArrayOutputStream();
            mat.writeToFile(new DataOutputStream(bos), this);
            bytes = bos.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes, 0, bytes.length);
        }
        out.writeInt(this.textures.size());
        for (i = 0; i < this.textures.size(); ++i) {
            Texture tex = (Texture)this.textures.elementAt(i);
            out.writeUTF(tex.getClass().getName());
            bos = new ByteArrayOutputStream();
            tex.writeToFile(new DataOutputStream(bos), this);
            bytes = bos.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes, 0, bytes.length);
        }
        out.writeInt(this.objects.size());
        for (i = 0; i < this.objects.size(); ++i) {
            index = this.writeObjectToFile(out, (ObjectInfo)this.objects.elementAt(i), table, index);
        }
        for (i = 0; i < this.objects.size(); ++i) {
            ObjectInfo info = (ObjectInfo)this.objects.elementAt(i);
            out.writeInt(info.children.length);
            for (int j = 0; j < info.children.length; ++j) {
                out.writeInt(this.objects.indexOf(info.children[j]));
            }
        }
        out.writeShort((short)this.environMode);
        if (this.environMode == 0) {
            this.environColor.writeToFile(out);
        } else {
            out.writeInt(this.textures.lastIndexOf(this.environTexture));
            out.writeUTF(this.environMapping.getClass().getName());
            if (this.environMapping instanceof LayeredMapping) {
                ((LayeredMapping)this.environMapping).writeToFile(out, this);
            } else {
                this.environMapping.writeToFile(out);
            }
            for (i = 0; i < this.environParamValue.length; ++i) {
                out.writeUTF(this.environParamValue[i].getClass().getName());
                this.environParamValue[i].writeToStream(out);
            }
        }
    }

    private int writeObjectToFile(DataOutputStream out, ObjectInfo info, Hashtable table, int index) throws IOException {
        info.coords.writeToFile(out);
        out.writeUTF(info.name);
        out.writeInt(info.id);
        out.writeBoolean(info.visible);
        Integer key = (Integer)table.get(info.object);
        if (key == null) {
            out.writeInt(index);
            out.writeUTF(info.object.getClass().getName());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            info.object.writeToFile(new DataOutputStream(bos), this);
            byte[] bytes = bos.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes, 0, bytes.length);
            key = new Integer(index++);
            table.put(info.object, key);
        } else {
            out.writeInt(key);
        }
        out.writeInt(info.tracks.length);
        for (int i = 0; i < info.tracks.length; ++i) {
            out.writeUTF(info.tracks[i].getClass().getName());
            info.tracks[i].writeToStream(out, this);
        }
        return index;
    }
}

