/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ModellingApp;
import artofillusion.MoveViewTool;
import artofillusion.RenderingMesh;
import artofillusion.RotateViewTool;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.view.ConstantVertexShader;
import artofillusion.view.FlatVertexShader;
import artofillusion.view.SmoothVertexShader;
import artofillusion.view.TexturedVertexShader;
import artofillusion.view.VertexShader;
import buoy.event.WidgetMouseEvent;
import buoy.widget.RowContainer;
import java.awt.Dimension;
import java.awt.Rectangle;

public class ObjectPreviewCanvas
extends ViewerCanvas {
    private ObjectInfo objInfo;
    private boolean sizeSet;
    private boolean hasBeenDrawn;

    public ObjectPreviewCanvas(ObjectInfo obj) {
        this(obj, new RowContainer());
    }

    public ObjectPreviewCanvas(ObjectInfo obj, RowContainer p) {
        super(ModellingApp.getPreferences().getUseOpenGL() && ObjectPreviewCanvas.isOpenGLAvailable());
        if (obj != null) {
            this.objInfo = obj.duplicate();
            this.objInfo.coords.setOrigin(new Vec3());
            this.objInfo.coords.setOrientation(Vec3.vz(), Vec3.vy());
            this.objInfo.clearDistortion();
        }
        this.buildChoices(p);
        this.setTool(new RotateViewTool(null));
        this.setMetaTool(new MoveViewTool(null));
        this.setRenderMode(2);
        this.hideBackfaces = false;
        this.prefSize = new Dimension(200, 200);
    }

    public void objectChanged() {
        this.getObject().clearCachedMeshes();
    }

    public ObjectInfo getObject() {
        return this.objInfo;
    }

    public void setObject(Object3D obj) {
        if (this.objInfo == null) {
            this.objInfo = new ObjectInfo(obj, new CoordinateSystem(), "");
        } else {
            this.objInfo.object = obj;
        }
        this.objInfo.clearCachedMeshes();
    }

    public double[] estimateDepthRange() {
        Mat4 toView = this.theCamera.getWorldToView();
        BoundingBox bounds = this.objInfo.getBounds();
        double dx = bounds.maxx - bounds.minx;
        double dy = bounds.maxy - bounds.miny;
        double dz = bounds.maxz - bounds.minz;
        double size = 0.5 * Math.sqrt(dx * dx + dy * dy + dz * dz);
        double depth = toView.times((Vec3)new Vec3()).z;
        return new double[]{depth - size, depth + size};
    }

    public synchronized void updateImage() {
        this.adjustCamera(this.isPerspective());
        super.updateImage();
        if (this.objInfo == null) {
            return;
        }
        this.theCamera.setObjectTransform(this.objInfo.coords.fromLocal());
        this.renderObject();
        this.drawBorder();
        if (this.showAxes) {
            this.drawCoordinateAxes();
        }
        if (!this.hasBeenDrawn) {
            this.hasBeenDrawn = true;
            this.repaint();
        }
    }

    protected void renderObject() {
        if (this.objInfo == null) {
            return;
        }
        if (!this.sizeSet) {
            Rectangle dim = this.getBounds();
            Vec3 objSize = this.objInfo.object.getBounds().getSize();
            double scale = 0.8 * (double)Math.min(dim.width, dim.height) / Math.max(Math.max(objSize.x, objSize.y), objSize.z);
            this.setScale(scale);
            this.theCamera.setScreenParams(0.0, scale, dim.width, dim.height);
            this.sizeSet = true;
        }
        if (this.renderMode == 0) {
            this.renderWireframe(this.objInfo.getWireframePreview(), this.theCamera, lineColor);
        } else if (this.renderMode == 4) {
            RenderingMesh mesh = this.objInfo.getPreviewMesh();
            if (mesh != null) {
                this.renderMeshTransparent(mesh, new ConstantVertexShader(transparentColor), this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), null);
            }
        } else {
            RenderingMesh mesh = this.objInfo.getPreviewMesh();
            Vec3 viewDir = this.theCamera.getViewToWorld().timesDirection(Vec3.vz());
            VertexShader shader = this.renderMode == 1 ? new FlatVertexShader(mesh, surfaceRGBColor, viewDir) : (this.renderMode == 2 ? new SmoothVertexShader(mesh, surfaceRGBColor, viewDir) : new TexturedVertexShader(mesh, this.objInfo.object, 0.0, viewDir).optimize());
            this.renderMesh(mesh, shader, this.theCamera, this.objInfo.object.isClosed(), null);
        }
    }

    protected void mousePressed(WidgetMouseEvent e) {
        this.requestFocus();
        this.activeTool = this.currentTool;
        if (this.metaTool != null && e.isMetaDown()) {
            this.activeTool = this.metaTool;
        }
        this.activeTool.mousePressed(e, this);
    }

    protected void mouseDragged(WidgetMouseEvent e) {
        this.activeTool.mouseDragged(e, this);
    }

    protected void mouseReleased(WidgetMouseEvent e) {
        this.activeTool.mouseReleased(e, this);
    }
}

