/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.ModellingApp;
import artofillusion.RenderListener;
import artofillusion.Renderer;
import artofillusion.Scene;
import artofillusion.WireframeMesh;
import artofillusion.image.ComplexImage;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Cube;
import artofillusion.object.Cylinder;
import artofillusion.object.DirectionalLight;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.Sphere;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.UniformTexture;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.MouseClickedEvent;
import buoy.event.MouseDraggedEvent;
import buoy.event.MouseEnteredEvent;
import buoy.event.MouseExitedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.event.RepaintEvent;
import buoy.widget.BComboBox;
import buoy.widget.CustomWidget;
import buoy.widget.Widget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;

public class MaterialPreviewer
extends CustomWidget
implements RenderListener {
    Scene theScene;
    Camera theCamera;
    ObjectInfo info;
    CoordinateSystem objectCoords;
    Image theImage;
    boolean mouseInside;
    boolean renderInProgress;
    Point clickPoint;
    private Mat4 dragTransform;
    private Object3D[] shape;
    public static final int HANDLE_SIZE = 5;
    static final double DRAG_SCALE = Math.PI / 360;

    public MaterialPreviewer(Texture tex, Material mat, int width, int height) {
        this.shape = new Object3D[]{new Sphere(1.0, 1.0, 1.0), new Cube(2.0, 2.0, 2.0), new Cylinder(2.0, 1.0, 1.0, 1.0), new Cylinder(2.0, 1.0, 1.0, 0.0)};
        ObjectInfo objInfo = new ObjectInfo(this.shape[0], new CoordinateSystem(), "");
        this.initObject(tex, mat, objInfo);
        this.init(objInfo, width, height);
    }

    public MaterialPreviewer(Texture tex, Material mat, Object3D obj, int width, int height) {
        ObjectInfo objInfo = new ObjectInfo(obj, new CoordinateSystem(), "");
        this.initObject(tex, mat, objInfo);
        this.init(objInfo, width, height);
    }

    public MaterialPreviewer(ObjectInfo obj, int width, int height) {
        this.init(obj.duplicate(), width, height);
    }

    private void initObject(Texture tex, Material mat, ObjectInfo objInfo) {
        if (tex == null) {
            tex = UniformTexture.invisibleTexture();
        }
        objInfo.setTexture(tex, tex.getDefaultMapping(objInfo.object));
        if (mat != null) {
            objInfo.setMaterial(mat, mat.getDefaultMapping(objInfo.object));
        }
    }

    private void init(ObjectInfo obj, int width, int height) {
        BoundingBox bounds = obj.getBounds();
        Vec3 size = bounds.getSize();
        double max = Math.max(size.x, Math.max(size.y, size.z)) / 2.0;
        double floor = -bounds.getSize().length() / 2.0;
        CoordinateSystem coords = new CoordinateSystem(new Vec3(0.0, 0.0, 10.0 * max), new Vec3(0.0, 0.0, -1.0), Vec3.vy());
        if (max > 10.0) {
            max = 10.0;
        }
        Vec3[] vert = new Vec3[]{new Vec3(100.0 * max, floor, 100.0 * max), new Vec3(-100.0 * max, floor, 100.0 * max), new Vec3(0.0, floor, -100.0 * max)};
        int[][] face = new int[][]{{0, 1, 2}};
        this.theScene = new Scene();
        this.theCamera = new Camera();
        this.theCamera.setCameraCoordinates(coords);
        coords = new CoordinateSystem(new Vec3(), new Vec3(-0.5, -0.4, -1.0), Vec3.vy());
        this.theScene.addObject(new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 0.8f), coords, "", null);
        coords = new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy());
        TriangleMesh tri = new TriangleMesh(vert, (int[][])face);
        this.theScene.addObject(tri, coords, "", null);
        Texture tex = this.theScene.getDefaultTexture();
        tri.setTexture(tex, tex.getDefaultMapping(tri));
        this.info = obj;
        this.objectCoords = this.info.coords = new CoordinateSystem();
        this.theScene.addObject(this.info, null);
        this.setPreferredSize(new Dimension(width, height));
        this.addEventLink(MousePressedEvent.class, (Object)this, "mousePressed");
        this.addEventLink(MouseReleasedEvent.class, (Object)this, "mouseReleased");
        this.addEventLink(MouseClickedEvent.class, (Object)this, "mouseClicked");
        this.addEventLink(MouseEnteredEvent.class, (Object)this, "mouseEntered");
        this.addEventLink(MouseExitedEvent.class, (Object)this, "mouseExited");
        this.addEventLink(MouseDraggedEvent.class, (Object)this, "mouseDragged");
        this.addEventLink(RepaintEvent.class, (Object)this, "paint");
        this.getComponent().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent ev) {
                MaterialPreviewer.this.render();
            }
        });
        this.getComponent().addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent ev) {
                Renderer rend;
                if ((ev.getChangeFlags() & 2L) != 0L && !MaterialPreviewer.this.getComponent().isDisplayable() && (rend = ModellingApp.getPreferences().getTexturePreviewRenderer()) != null) {
                    rend.cancelRendering(MaterialPreviewer.this.theScene);
                }
            }
        });
        this.render();
    }

    public ObjectInfo getObject() {
        return this.info;
    }

    public void setTexture(Texture tex, TextureMapping map) {
        if (tex == null) {
            tex = UniformTexture.invisibleTexture();
        }
        if (map == null) {
            map = tex.getDefaultMapping(this.info.object);
        }
        this.info.setTexture(tex, map);
    }

    public void setMaterial(Material mat, MaterialMapping map) {
        this.info.setMaterial(mat, map);
    }

    public synchronized void render() {
        Renderer rend = ModellingApp.getPreferences().getTexturePreviewRenderer();
        if (rend == null) {
            return;
        }
        rend.cancelRendering(this.theScene);
        Rectangle bounds = this.getBounds();
        if (bounds.width == 0 || bounds.height == 0) {
            return;
        }
        this.theCamera.setSize(bounds.width, bounds.height);
        this.theCamera.setDistToScreen((double)bounds.height / 200.0 / Math.tan(0.14));
        rend.configurePreview();
        rend.renderScene(this.theScene, this.theCamera, this, null);
        this.renderInProgress = true;
        this.repaint();
    }

    public synchronized void cancelRendering() {
        Renderer rend = ModellingApp.getPreferences().getTexturePreviewRenderer();
        if (rend != null) {
            rend.cancelRendering(this.theScene);
        }
    }

    private void paint(RepaintEvent ev) {
        Graphics2D g = ev.getGraphics();
        if (this.theImage != null) {
            g.drawImage(this.theImage, 0, 0, this.getComponent());
        }
        if (this.mouseInside) {
            this.drawHilight(g);
        }
        if (this.renderInProgress) {
            Rectangle bounds = this.getBounds();
            g.setColor(Color.red);
            g.drawRect(0, 0, bounds.width - 1, bounds.height - 1);
        }
    }

    private void drawHilight(Graphics g) {
        Rectangle bounds = this.getBounds();
        g.setColor(Color.red);
        g.fillRect(0, 0, 5, 5);
        g.fillRect(bounds.width - 5, 0, 5, 5);
        g.fillRect(0, bounds.height - 5, 5, 5);
        g.fillRect(bounds.width - 5, bounds.height - 5, 5, 5);
    }

    private void drawObject(Graphics g) {
        g.setColor(Color.gray);
        Vec3 origin = this.objectCoords.getOrigin();
        Mat4 m = this.objectCoords.fromLocal();
        m = Mat4.translation(-origin.x, -origin.y, -origin.z).times(m);
        m = this.dragTransform.times(m);
        m = Mat4.translation(origin.x, origin.y, origin.z).times(m);
        this.theCamera.setObjectTransform(m);
        WireframeMesh mesh = this.info.object.getWireframeMesh();
        int[] from = mesh.from;
        int[] to = mesh.to;
        int last = -1;
        Vec3[] vert = mesh.vert;
        for (int i = 0; i < mesh.from.length; ++i) {
            if (from[i] == last) {
                last = to[i];
                this.theCamera.drawClippedLineTo(g, vert[last]);
                continue;
            }
            last = to[i];
            this.theCamera.drawClippedLine(g, vert[from[i]], vert[last]);
        }
    }

    private void changeView(int view) {
        double[][] angles = new double[][]{{0.0, 0.0, 0.0}, {0.0, 180.0, 0.0}, {0.0, -90.0, 0.0}, {0.0, 90.0, 0.0}, {-90.0, 0.0, 0.0}, {90.0, 0.0, 0.0}};
        this.objectCoords.setOrientation(angles[view][0], angles[view][1], angles[view][2]);
        this.objectCoords.setOrigin(new Vec3());
        this.render();
    }

    private void changeObject(int object) {
        this.shape[object].setTexture(this.info.object.getTexture(), this.info.object.getTextureMapping());
        this.shape[object].setMaterial(this.info.object.getMaterial(), this.info.object.getMaterialMapping());
        this.info.object = this.shape[object];
        this.render();
    }

    public void imageUpdated(Image image) {
        this.theImage = image;
        this.repaint();
    }

    public void statusChanged(String status) {
    }

    public void imageComplete(ComplexImage image) {
        this.theImage = image.getImage();
        this.renderInProgress = false;
        this.repaint();
    }

    public void renderingCanceled() {
    }

    private void mouseEntered(MouseEnteredEvent e) {
        this.mouseInside = true;
        Graphics g = this.getComponent().getGraphics();
        this.drawHilight(g);
        g.dispose();
    }

    private void mouseExited(MouseExitedEvent e) {
        this.mouseInside = false;
        this.repaint();
    }

    private void mousePressed(MousePressedEvent e) {
        Graphics g = this.getComponent().getGraphics();
        this.clickPoint = e.getPoint();
        Renderer rend = ModellingApp.getPreferences().getTexturePreviewRenderer();
        if (rend != null) {
            rend.cancelRendering(this.theScene);
        }
        this.dragTransform = Mat4.identity();
        this.drawObject(g);
        g.dispose();
    }

    private void mouseReleased(MouseReleasedEvent e) {
        if (this.clickPoint == null) {
            return;
        }
        Point dragPoint = e.getPoint();
        if (!this.clickPoint.equals(dragPoint)) {
            if (e.isMetaDown()) {
                this.dragTransform = e.isControlDown() ? Mat4.translation(0.0, 0.0, (double)(dragPoint.y - this.clickPoint.y) * 0.01) : Mat4.translation((double)(dragPoint.x - this.clickPoint.x) * 0.01, (double)(this.clickPoint.y - dragPoint.y) * 0.01, 0.0);
                this.objectCoords.transformOrigin(this.dragTransform);
            } else {
                Vec3 rotAxis = new Vec3((double)(this.clickPoint.y - dragPoint.y) * (Math.PI / 360), (double)(dragPoint.x - this.clickPoint.x) * (Math.PI / 360), 0.0);
                double angle = rotAxis.length();
                rotAxis = rotAxis.times(1.0 / angle);
                rotAxis = this.theCamera.getViewToWorld().timesDirection(rotAxis);
                this.dragTransform = Mat4.axisRotation(rotAxis, angle);
                this.objectCoords.transformAxes(this.dragTransform);
            }
        }
        this.render();
    }

    private void mouseClicked(MouseClickedEvent e) {
        if (e.getClickCount() == 2) {
            this.showConfigurationDialog();
        }
    }

    private void mouseDragged(MouseDraggedEvent e) {
        if (this.clickPoint == null) {
            return;
        }
        Graphics g = this.getComponent().getGraphics();
        Point dragPoint = e.getPoint();
        if (e.isMetaDown()) {
            this.dragTransform = e.isControlDown() ? Mat4.translation(0.0, 0.0, (double)(dragPoint.y - this.clickPoint.y) * 0.01) : Mat4.translation((double)(dragPoint.x - this.clickPoint.x) * 0.01, (double)(this.clickPoint.y - dragPoint.y) * 0.01, 0.0);
        } else {
            Vec3 rotAxis = new Vec3((double)(this.clickPoint.y - dragPoint.y) * (Math.PI / 360), (double)(dragPoint.x - this.clickPoint.x) * (Math.PI / 360), 0.0);
            double angle = rotAxis.length();
            rotAxis = rotAxis.times(1.0 / angle);
            rotAxis = this.theCamera.getViewToWorld().timesDirection(rotAxis);
            this.dragTransform = Mat4.axisRotation(rotAxis, angle);
        }
        g.drawImage(this.theImage, 0, 0, this.getComponent());
        this.drawHilight(g);
        this.drawObject(g);
        g.dispose();
    }

    private void showConfigurationDialog() {
        ComponentsDialog dlg;
        BComboBox viewChoice = new BComboBox(new String[]{"", Translate.text("Front"), Translate.text("Back"), Translate.text("Left"), Translate.text("Right"), Translate.text("Top"), Translate.text("Bottom")});
        BComboBox shapeChoice = new BComboBox(new String[]{Translate.text("menu.sphere"), Translate.text("menu.cube"), Translate.text("menu.cylinder"), Translate.text("menu.cone")});
        if (this.shape == null) {
            dlg = new ComponentsDialog(UIUtilities.findWindow(this), Translate.text("configurePreview"), new Widget[]{viewChoice}, new String[]{Translate.text("resetViewTo")});
        } else {
            for (int i = 0; i < this.shape.length; ++i) {
                if (this.shape[i] != this.info.object) continue;
                shapeChoice.setSelectedIndex(i);
            }
            dlg = new ComponentsDialog(UIUtilities.findWindow(this), Translate.text("configurePreview"), new Widget[]{shapeChoice, viewChoice}, new String[]{Translate.text("Shape"), Translate.text("resetViewTo")});
        }
        if (!dlg.clickedOk()) {
            return;
        }
        if (this.shape != null && this.shape[shapeChoice.getSelectedIndex()] != this.info.object) {
            this.changeObject(shapeChoice.getSelectedIndex());
        }
        if (viewChoice.getSelectedIndex() > 0) {
            this.changeView(viewChoice.getSelectedIndex() - 1);
        }
    }
}

