/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.MaterialPreviewer;
import artofillusion.ModellingApp;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.object.Object3D;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.ValueChangedEvent;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Insets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;

public class MaterialMappingDialog
extends BDialog {
    private BFrame fr;
    private Object3D obj;
    private Vector mappings;
    private BComboBox mapChoice;
    private MaterialPreviewer preview;
    private MaterialMapping map;
    private MaterialMapping oldMapping;
    private Widget editingPanel;
    static /* synthetic */ Class class$artofillusion$object$Object3D;

    public MaterialMappingDialog(BFrame parent, Object3D obj) {
        super(parent, "Material Mapping", true);
        this.fr = parent;
        this.obj = obj;
        this.map = obj.getMaterialMapping();
        this.oldMapping = this.map.duplicate();
        this.mappings = new Vector();
        Class[] allMappings = ModellingApp.getMaterialMappings();
        for (int i = 0; i < allMappings.length; ++i) {
            try {
                Method mtd = allMappings[i].getMethod("legalMapping", class$artofillusion$object$Object3D == null ? MaterialMappingDialog.class$("artofillusion.object.Object3D") : class$artofillusion$object$Object3D, class$artofillusion$material$Material == null ? MaterialMappingDialog.class$("artofillusion.material.Material") : class$artofillusion$material$Material);
                Material mat = obj.getMaterial();
                Boolean result = (Boolean)mtd.invoke(null, obj, mat);
                if (!result.booleanValue()) continue;
                this.mappings.addElement(allMappings[i]);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        FormContainer content = new FormContainer(new double[]{1.0}, new double[]{1.0, 0.0, 0.0, 0.0});
        this.setContent(BOutline.createEmptyBorder(content, ModellingApp.standardDialogInsets));
        this.preview = new MaterialPreviewer(obj.getTexture(), obj.getMaterial(), obj.duplicate(), 160, 160);
        content.add(this.preview, 0, 0, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, new Insets(0, 50, 0, 50), null));
        this.preview.setMaterial(obj.getMaterial(), obj.getMaterialMapping());
        RowContainer choiceRow = new RowContainer();
        content.add(choiceRow, 0, 1);
        choiceRow.add(new BLabel(Translate.text("Mapping") + ":"));
        this.mapChoice = new BComboBox();
        choiceRow.add(this.mapChoice);
        for (int i = 0; i < this.mappings.size(); ++i) {
            try {
                Method mtd = ((Class)this.mappings.elementAt(i)).getMethod("getName", null);
                this.mapChoice.add((String)mtd.invoke(null, null));
                if (this.mappings.elementAt(i) != this.map.getClass()) continue;
                this.mapChoice.setSelectedIndex(i);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.mapChoice.addEventLink(ValueChangedEvent.class, (Object)this, "mappingChanged");
        this.editingPanel = this.map.getEditingPanel(obj, this.preview);
        content.add(this.editingPanel, 0, 2);
        RowContainer row = new RowContainer();
        content.add(row, 0, 3);
        row.add(Translate.button("ok", this, "dispose"));
        row.add(Translate.button("cancel", this, "doCancel"));
        this.pack();
        UIUtilities.centerWindow(this);
        this.setVisible(true);
    }

    private void doCancel() {
        this.setMapping(this.oldMapping);
        this.dispose();
    }

    private void mappingChanged() {
        try {
            Class cls = (Class)this.mappings.elementAt(this.mapChoice.getSelectedIndex());
            if (cls == this.map.getClass()) {
                return;
            }
            Constructor con = cls.getConstructor(Material.class);
            Material mat = this.obj.getMaterial();
            this.setMapping((MaterialMapping)con.newInstance(mat));
            FormContainer content = (FormContainer)this.getContent();
            content.remove(this.editingPanel);
            this.editingPanel = this.map.getEditingPanel(this.obj, this.preview);
            content.add(this.editingPanel, 0, 2, 2, 1);
            this.pack();
            this.preview.render();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setMapping(MaterialMapping newmap) {
        this.map = newmap;
        this.obj.setMaterial(this.obj.getMaterial(), newmap);
        this.preview.setMaterial(this.obj.getMaterial(), newmap);
        this.preview.render();
    }
}

