/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BComboBox;
import buoy.widget.BStandardDialog;
import buoy.widget.Widget;
import java.awt.Point;
import java.awt.Polygon;

public class CreatePolygonTool
extends EditingTool {
    private static int counter = 1;
    private static int sides = 3;
    private static int shape = 0;
    private Point clickPoint;
    private Vec2[] points;
    private double centerx;
    private double centery;
    private double[] sine;
    private double[] cosine;
    private double minsine;
    private double maxsine;
    private double mincosine;
    private double maxcosine;

    public CreatePolygonTool(EditingWindow fr) {
        super(fr);
        this.initButton("polygon");
        this.tabulateSines();
    }

    public void activate() {
        super.activate();
        this.setHelpText();
    }

    private void setHelpText() {
        String type = shape == 0 ? "polygon" : (shape == 2 ? "interpolatingCurve" : "approximatingCurve");
        this.theWindow.setHelpText(Translate.text("createPolygonTool.helpText", Integer.toString(sides), Translate.text("createPolygonTool." + type)));
    }

    public int whichClicks() {
        return 1;
    }

    public String getToolTipText() {
        return Translate.text("createPolygonTool.tipText");
    }

    void tabulateSines() {
        this.sine = new double[sides];
        this.cosine = new double[sides];
        this.mincosine = 1.0;
        this.minsine = 1.0;
        this.maxcosine = -1.0;
        this.maxsine = -1.0;
        for (int i = 0; i < sides; ++i) {
            this.sine[i] = Math.sin(((double)i + 0.5) * 2.0 * Math.PI / (double)sides);
            this.sine[i] = 1.0E-10 * (double)Math.round(this.sine[i] * 1.0E10);
            this.cosine[i] = Math.cos(((double)i + 0.5) * 2.0 * Math.PI / (double)sides);
            this.cosine[i] = 1.0E-10 * (double)Math.round(this.cosine[i] * 1.0E10);
            if (this.sine[i] < this.minsine) {
                this.minsine = this.sine[i];
            }
            if (this.sine[i] > this.maxsine) {
                this.maxsine = this.sine[i];
            }
            if (this.cosine[i] < this.mincosine) {
                this.mincosine = this.cosine[i];
            }
            if (!(this.cosine[i] > this.maxcosine)) continue;
            this.maxcosine = this.cosine[i];
        }
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        this.clickPoint = e.getPoint();
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        this.findPoints(e.getPoint(), e.isShiftDown());
        int[] x = new int[this.points.length];
        int[] y = new int[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            x[i] = (int)this.points[i].x;
            y[i] = (int)this.points[i].y;
        }
        view.drawDraggedShape(new Polygon(x, y, x.length));
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        Object3D obj;
        int i;
        Vec3[] vertex;
        Scene theScene = ((LayoutWindow)this.theWindow).getScene();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        float[] s = null;
        this.findPoints(dragPoint, e.isShiftDown());
        if (e.isControlDown()) {
            vertex = new Vec3[this.points.length + 1];
            vertex[this.points.length] = new Vec3();
        } else {
            vertex = new Vec3[this.points.length];
            s = new float[this.points.length];
            for (i = 0; i < this.points.length; ++i) {
                s[i] = 1.0f;
            }
        }
        Vec3 orig = cam.convertScreenToWorld(new Point((int)this.centerx, (int)this.centery), 20.0, false);
        Vec3 temp = cam.convertScreenToWorld(new Point(1 + (int)this.centerx, (int)this.centery), 20.0, false);
        double scale = temp.minus(orig).length();
        for (i = 0; i < this.points.length; ++i) {
            vertex[i] = new Vec3(scale * (this.points[i].x - this.centerx), -scale * (this.points[i].y - this.centery), 0.0);
        }
        Vec3 ydir = cam.getViewToWorld().timesDirection(Vec3.vy());
        Vec3 zdir = cam.getViewToWorld().timesDirection(new Vec3(0.0, 0.0, -1.0));
        CoordinateSystem coords = new CoordinateSystem(orig, zdir, ydir);
        if (e.isControlDown()) {
            int[][] faces = new int[sides][];
            faces[0] = new int[]{sides - 1, 0, sides};
            for (int i2 = 1; i2 < sides; ++i2) {
                faces[i2] = new int[]{i2 - 1, i2, sides};
            }
            obj = new TriangleMesh(vertex, (int[][])faces);
            ((TriangleMesh)obj).setSmoothingMethod(shape);
        } else {
            obj = new Curve(vertex, s, shape, true);
        }
        ObjectInfo info = new ObjectInfo(obj, coords, "Polygon " + counter++);
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        UndoRecord undo = new UndoRecord(this.theWindow, false);
        int[] sel = theScene.getSelection();
        ((LayoutWindow)this.theWindow).addObject(info, undo);
        undo.addCommand(16, new Object[]{sel});
        this.theWindow.setUndoRecord(undo);
        ((LayoutWindow)this.theWindow).setSelection(((LayoutWindow)this.theWindow).getScene().getNumObjects() - 1);
        this.points = null;
        this.theWindow.updateImage();
    }

    void findPoints(Point dragPoint, boolean shiftDown) {
        int w = dragPoint.x - this.clickPoint.x;
        int h = dragPoint.y - this.clickPoint.y;
        double xscale = Math.abs((double)w / (this.maxsine - this.minsine));
        double yscale = Math.abs((double)h / (this.maxcosine - this.mincosine));
        if (shiftDown) {
            xscale = yscale = Math.min(xscale, yscale);
        }
        this.centerx = w > 0 ? (double)this.clickPoint.x - this.minsine * xscale : (double)this.clickPoint.x - this.maxsine * xscale;
        this.centery = h > 0 ? (double)this.clickPoint.y - this.mincosine * yscale : (double)this.clickPoint.y - this.maxcosine * yscale;
        if (this.points == null || this.points.length != sides) {
            this.points = new Vec2[sides];
        }
        for (int i = 0; i < sides; ++i) {
            this.points[i] = new Vec2(this.centerx + this.sine[i] * xscale, this.centery + this.cosine[i] * yscale);
        }
    }

    public void iconDoubleClicked() {
        ValueField sidesField = new ValueField((double)sides, 5);
        BComboBox shapeChoice = new BComboBox(new String[]{Translate.text("Angled"), Translate.text("Interpolating"), Translate.text("Approximating")});
        if (shape == 0) {
            shapeChoice.setSelectedIndex(0);
        } else if (shape == 2) {
            shapeChoice.setSelectedIndex(1);
        } else {
            shapeChoice.setSelectedIndex(2);
        }
        ComponentsDialog dlg = new ComponentsDialog(this.theFrame, Translate.text("enterNumSides"), new Widget[]{sidesField, shapeChoice}, new String[]{Translate.text("Sides"), Translate.text("Shape")});
        if (!dlg.clickedOk()) {
            return;
        }
        int i = (int)sidesField.getValue();
        if (i < 3) {
            new BStandardDialog("", Translate.text("threeSidesRequired"), BStandardDialog.ERROR).showMessageDialog(this.theFrame);
            return;
        }
        sides = i;
        i = shapeChoice.getSelectedIndex();
        shape = i == 0 ? 0 : (i == 1 ? 2 : 3);
        this.tabulateSines();
        this.setHelpText();
    }
}

