/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.TriMeshBeveler;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.Vec3;
import artofillusion.object.TriangleMesh;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MeshEditController;
import artofillusion.ui.MeshEditingTool;
import artofillusion.ui.NinePointManipulator;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BComboBox;
import buoy.widget.Widget;
import java.awt.Image;
import java.awt.Point;

public class BevelExtrudeTool
extends MeshEditingTool {
    private boolean dragInProgress;
    private boolean separateFaces;
    private TriangleMesh origMesh;
    private TriMeshBeveler beveler;
    private Point clickPoint;
    private double width;
    private double height;
    private final NinePointManipulator manipulator;

    public BevelExtrudeTool(EditingWindow fr, MeshEditController controller) {
        super(fr, controller);
        this.initButton("bevel");
        this.manipulator = new NinePointManipulator(new Image[]{null, null, null, null, NinePointManipulator.ARROWS_ALL, null, null, null, null});
        this.manipulator.addEventLink(NinePointManipulator.HandlePressedEvent.class, (Object)this, "handlePressed");
        this.manipulator.addEventLink(NinePointManipulator.HandleDraggedEvent.class, (Object)this, "handleDragged");
        this.manipulator.addEventLink(NinePointManipulator.HandleReleasedEvent.class, (Object)this, "handleReleased");
    }

    public int whichClicks() {
        return 1;
    }

    public boolean allowSelectionChanges() {
        return !this.dragInProgress;
    }

    public String getToolTipText() {
        return Translate.text("bevelExtrudeTool.tipText");
    }

    public void drawOverlay(ViewerCanvas view) {
        BoundingBox selectionBounds = this.findSelectionBounds(view.getCamera());
        if (!this.dragInProgress) {
            if (selectionBounds != null) {
                this.manipulator.draw(view, selectionBounds);
                this.theWindow.setHelpText(Translate.text("bevelExtrudeTool.helpText"));
            } else {
                this.theWindow.setHelpText(Translate.text("bevelExtrudeTool.errorText"));
            }
        }
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        BoundingBox selectionBounds = this.findSelectionBounds(view.getCamera());
        this.dragInProgress = false;
        if (selectionBounds != null) {
            this.dragInProgress = this.manipulator.mousePressed(e, view, selectionBounds);
        }
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        this.manipulator.mouseDragged(e, view);
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        this.manipulator.mouseReleased(e, view);
    }

    protected void handlePressed(NinePointManipulator.HandlePressedEvent ev) {
        boolean[] selected = this.controller.getSelection();
        TriangleMesh mesh = (TriangleMesh)this.controller.getObject().object;
        this.origMesh = (TriangleMesh)mesh.duplicate();
        int selectMode = this.controller.getSelectionMode();
        int mode = selectMode == 0 ? 3 : (selectMode == 1 ? 2 : (this.separateFaces ? 0 : 1));
        this.beveler = new TriMeshBeveler(this.origMesh, selected, mode);
        this.clickPoint = ev.getMouseEvent().getPoint();
    }

    protected void handleDragged(NinePointManipulator.HandleDraggedEvent ev) {
        TriangleMesh mesh = (TriangleMesh)this.controller.getObject().object;
        Camera cam = ev.getView().getCamera();
        Point dragPoint = ev.getMouseEvent().getPoint();
        Vec3 dragVec = cam.convertScreenToWorld(dragPoint, cam.getDistToScreen()).minus(cam.convertScreenToWorld(this.clickPoint, cam.getDistToScreen()));
        this.width = 0.5 * dragVec.x;
        this.height = dragVec.y;
        if (this.controller.getSelectionMode() == 2) {
            if (ev.getMouseEvent().isShiftDown()) {
                if (Math.abs(this.width) > Math.abs(this.height)) {
                    this.height = 0.0;
                } else {
                    this.width = 0.0;
                }
            }
        } else {
            if (ev.getMouseEvent().isShiftDown()) {
                this.height = 0.0;
            }
            if (this.width < 0.0) {
                this.width = 0.0;
            }
        }
        mesh.copyObject(this.beveler.bevelMesh(this.height, this.width));
        this.controller.setMesh(mesh);
        this.controller.setSelection(this.beveler.getNewSelection());
        this.theWindow.setHelpText(Translate.text("bevelExtrudeTool.dragText", new Double(this.width), new Double(this.height)));
    }

    protected void handleReleased(NinePointManipulator.HandleReleasedEvent ev) {
        if (this.width != 0.0 || this.height != 0.0) {
            TriangleMesh mesh = (TriangleMesh)this.controller.getObject().object;
            this.theWindow.setUndoRecord(new UndoRecord(this.theWindow, false, 0, new Object[]{mesh, this.origMesh}));
            this.controller.objectChanged();
        }
        this.theWindow.updateImage();
        this.dragInProgress = false;
    }

    public void iconDoubleClicked() {
        BComboBox c = new BComboBox(new String[]{Translate.text("selectionAsWhole"), Translate.text("individualFaces")});
        c.setSelectedIndex(this.separateFaces ? 1 : 0);
        ComponentsDialog dlg = new ComponentsDialog(this.theFrame, Translate.text("applyExtrudeTo"), new Widget[]{c}, new String[]{null});
        if (dlg.clickedOk()) {
            this.separateFaces = c.getSelectedIndex() == 1;
        }
    }
}

