/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.spmanager;

import buoy.event.CommandEvent;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BCheckBoxMenuItem;
import buoy.widget.BLabel;
import buoy.widget.BMenu;
import buoy.widget.BMenuItem;
import buoy.widget.BRadioButton;
import buoy.widget.RadioButtonGroup;
import buoy.widget.Shortcut;
import java.awt.Button;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SPMTranslate {
    private static Locale locale = Locale.getDefault();
    private static ResourceBundle resources;

    public static void setLocale(Locale l) {
        locale = l;
        resources = ResourceBundle.getBundle("spmanager", locale);
    }

    public static Locale getLocale() {
        return locale;
    }

    public static BMenu bMenu(String name) {
        try {
            return new BMenu(resources.getString("menu." + name));
        }
        catch (MissingResourceException ex) {
            return new BMenu(name);
        }
    }

    public static BMenuItem bMenuItem(String name) {
        return SPMTranslate.bMenuItem(name, null, null, null);
    }

    public static BMenuItem bMenuItem(String name, Object target, String method) {
        return SPMTranslate.bMenuItem(name, CommandEvent.class, target, method);
    }

    public static BMenuItem bMenuItem(String name, Class eventType, Object target, String method) {
        String command = name;
        BMenuItem item = null;
        try {
            command = resources.getString("menu." + name);
            String shortcut = resources.getString("menu." + name + ".shortcut");
            if (shortcut.length() > 1 && shortcut.charAt(0) == '^') {
                item = new BMenuItem(command, new Shortcut(shortcut.charAt(1), 65537));
            } else if (shortcut.length() > 0) {
                item = new BMenuItem(command, new Shortcut(shortcut.charAt(0)));
            }
        }
        catch (MissingResourceException ex) {
            item = new BMenuItem(command);
        }
        if (eventType != null) {
            item.addEventLink(eventType, target, method);
        }
        return item;
    }

    public static BCheckBoxMenuItem bCheckBoxMenuItem(String name, boolean state) {
        String command = name;
        try {
            command = resources.getString("menu." + name);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        BCheckBoxMenuItem item = new BCheckBoxMenuItem(command, state);
        return item;
    }

    public static BButton bButton(String name) {
        return SPMTranslate.bButton(name, null, null, null);
    }

    public static BButton bButton(String name, Object target, String method) {
        return SPMTranslate.bButton(name, CommandEvent.class, target, method);
    }

    public static BButton bButton(String name, Class eventType, Object target, String method) {
        String command = name;
        try {
            command = resources.getString("button." + name);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        BButton button = new BButton(command);
        if (eventType != null) {
            button.addEventLink(eventType, target, method);
        }
        return button;
    }

    public static BRadioButton bRadioButton(String name, boolean state, RadioButtonGroup group) {
        return SPMTranslate.bRadioButton(name, state, group, null, null);
    }

    public static BRadioButton bRadioButton(String name, boolean state, RadioButtonGroup group, Object target, String method) {
        String command = name;
        try {
            command = resources.getString("radio." + name);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        BRadioButton radio = new BRadioButton(command, state, group);
        if (target != null) {
            group.addEventLink(SelectionChangedEvent.class, target, method);
        }
        return radio;
    }

    public static Button button(String name, ActionListener listener) {
        return SPMTranslate.button(name, null, listener);
    }

    public static Button button(String name, String suffix, ActionListener listener) {
        String command = name;
        try {
            command = resources.getString("button." + name);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        if (suffix != null) {
            command = command + suffix;
        }
        Button b = new Button(command);
        if (listener != null) {
            b.setActionCommand(name);
            b.addActionListener(listener);
        }
        return b;
    }

    public static BCheckBox bCheckBox(String name, boolean state) {
        return SPMTranslate.bCheckBox(name, state, null, null);
    }

    public static BCheckBox bCheckBox(String name, boolean state, Object target, String method) {
        String command = name;
        try {
            command = resources.getString("checkbox." + name);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        BCheckBox b = new BCheckBox(command, state);
        if (target != null) {
            b.addEventLink(ValueChangedEvent.class, target, method);
        }
        return b;
    }

    public static BLabel bLabel(String name) {
        return SPMTranslate.bLabel(name, null);
    }

    public static BLabel bLabel(String name, Object[] args) {
        try {
            name = resources.getString("label." + name);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (args != null) {
            return new BLabel(MessageFormat.format(name, args));
        }
        return new BLabel(name);
    }

    public static String text(String name) {
        try {
            return resources.getString("text." + name);
        }
        catch (MissingResourceException ex) {
            return name;
        }
    }

    public static String text(String name, Object arg1) {
        String pattern = name;
        try {
            pattern = resources.getString("text." + name);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return MessageFormat.format(pattern, arg1);
    }

    public static String text(String name, Object arg1, Object arg2) {
        String pattern = name;
        try {
            pattern = resources.getString("text" + name);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        return MessageFormat.format(pattern, arg1, arg2);
    }

    public static String text(String name, Object[] args) {
        String pattern = name;
        try {
            pattern = resources.getString("text." + name);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return MessageFormat.format(pattern, args);
    }
}

