/*
 * Decompiled with CFR 0.152.
 */
package nik777.chat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.StringTokenizer;
import java.util.Vector;

public class ChatTextArea
extends Panel {
    private static final int NAME = 0;
    private static final int NAMECOLOR = 1;
    private static final int MSG = 2;
    private static final int MSGCOLOR = 3;
    private int miRows;
    private int miColumns;
    private int miNbrLinesPerPage;
    private int miWidth;
    private int miHeight;
    private int miNameColWidth;
    private int miTopLine = 0;
    private int miFontHeight;
    private boolean mbReformatLines = true;
    private boolean mbHangingIndent = true;
    private Image mImage;
    private Graphics mGraphics;
    private Font mFont;
    private FontMetrics mFontMetrics;
    private Scrollbar mScrollbar;
    private Vector mvLines;
    private Vector mvFormatedLines;
    private int miColSize = 20;
    private boolean mbColSizeIsPercent = true;

    public ChatTextArea() {
        this("", 0, 0, false);
    }

    public ChatTextArea(String text) {
        this(text, 0, 0, false);
    }

    public ChatTextArea(int rows, int cols, boolean hangingIndent) {
        this("", rows, cols, hangingIndent);
    }

    public ChatTextArea(String Text, int rows, int cols, boolean hangingIndent) {
        this.miRows = rows;
        this.miColumns = cols;
        this.mbHangingIndent = hangingIndent;
        this.mFont = new Font("Dialog", 0, 12);
        this.setLayout(new BorderLayout());
        this.mScrollbar = new Scrollbar(1, 0, 1, 0, 0);
        this.add("East", this.mScrollbar);
        this.mScrollbar.setValues(0, 1, 0, 100);
        this.mScrollbar.setUnitIncrement(10);
        this.mScrollbar.setUnitIncrement(30);
        this.mvLines = new Vector();
        this.mvFormatedLines = new Vector();
        this.repaint();
        this.mScrollbar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                ChatTextArea.this.computeScrollbar(false);
                ChatTextArea.this.repaint();
            }
        });
        if (Text.length() > 0) {
            this.append(Text);
        }
    }

    public void append(String str) {
        this.appendChatText(str, "000000", "", "");
    }

    public void append(String str, String RGB) {
        this.appendChatText(str, RGB, "", "");
    }

    public void appendChatText(String name, String msg, String RGB) {
        this.appendChatText(name, RGB, msg, RGB);
    }

    public void appendChatText(String name, String nameRGB, String msg, String msgRGB) {
        String[] line = new String[]{name, nameRGB, msg, msgRGB};
        this.mvLines.addElement(line);
        Rectangle rect = this.getBounds();
        if (rect.width > 0) {
            this.wordWrap(this.mvLines.size() - 1);
            this.computeScrollbar(true);
            this.repaint();
        }
    }

    public String getText() {
        String sBuffer = "";
        for (int i = 0; i < this.mvLines.size(); ++i) {
            String[] saNextLine = (String[])this.mvLines.elementAt(i);
            sBuffer = sBuffer + saNextLine[0] + " " + saNextLine[2] + "\n";
        }
        return sBuffer;
    }

    public void clearText() {
        this.mvLines.removeAllElements();
        this.mvFormatedLines.removeAllElements();
        this.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.mImage == null) {
            this.mImage = this.createImage(this.miWidth, this.miHeight);
            this.mGraphics = this.mImage.getGraphics();
            this.mGraphics.setFont(this.mFont);
            this.mFontMetrics = this.mGraphics.getFontMetrics();
            this.miFontHeight = this.mFontMetrics.getHeight();
            this.miNbrLinesPerPage = this.miHeight / this.miFontHeight;
            this.render();
        }
        g.drawImage(this.mImage, 0, 0, this);
    }

    public void update() {
        this.update(this.getGraphics());
    }

    public void update(Graphics g) {
        if (this.mFontMetrics != null) {
            this.render();
            this.paint(g);
        }
    }

    public int getRows() {
        return this.miRows;
    }

    public int getColumns() {
        return this.miColumns;
    }

    public Dimension getPreferredSize(int rows, int cols) {
        return super.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return this.miRows > 0 && this.miColumns > 0 ? this.getPreferredSize(this.miRows, this.miColumns) : super.getPreferredSize();
    }

    public Dimension getMinimumSize(int rows, int cols) {
        return super.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return super.getMinimumSize();
    }

    public void setBounds(int x, int y, int w, int h) {
        if (w != this.miWidth || h != this.miHeight) {
            this.miWidth = w;
            this.miHeight = h;
            this.setNameColumnWidth(this.miColSize, this.mbColSizeIsPercent);
            this.mImage = null;
            this.mbReformatLines = true;
            this.repaint();
        }
        super.setBounds(x, y, w, h);
    }

    public void setFont(Font font) {
        this.mFont = font;
        this.repaint();
    }

    public synchronized void setText(String str) {
        this.setText(str, "000000");
    }

    public synchronized void setText(String str, String RGB) {
        this.clearText();
        if (str.length() > 0) {
            this.append(str, RGB);
        }
    }

    public synchronized void setNameColumnWidth(int width, boolean isPercent) {
        this.miColSize = width;
        this.mbColSizeIsPercent = isPercent;
        if (isPercent) {
            if (width < 0 || width > 95) {
                width = 20;
            }
            double dNameColWidthPercent = (double)width * 0.01;
            this.miNameColWidth = (int)((double)this.miWidth * dNameColWidthPercent);
        } else {
            if (width < 0 || width > this.miWidth) {
                width = this.miWidth / 3;
            }
            this.miNameColWidth = width;
        }
    }

    private void wordWrap(int lineIndex) {
        String[] saNewLine = (String[])this.mvLines.elementAt(lineIndex);
        boolean bChatMsg = saNewLine[2].length() > 0;
        try {
            String[] NewLine;
            String sNextWord = new String();
            String sChopped = new String();
            boolean bAddUserName = true;
            boolean bWasChatMsg = false;
            int iBodyWidth = bChatMsg ? (this.mbHangingIndent ? this.miWidth - this.miNameColWidth - 50 : this.miWidth - (50 + this.mFontMetrics.stringWidth(saNewLine[0]))) : this.miWidth - 50;
            StringTokenizer tokenizer = new StringTokenizer(bChatMsg ? saNewLine[2] : saNewLine[0]);
            while (tokenizer.hasMoreTokens()) {
                sNextWord = tokenizer.nextToken().toString();
                if (this.mFontMetrics.stringWidth(sNextWord) > iBodyWidth) {
                    sChopped = sChopped + " " + this.chopWord(sNextWord, iBodyWidth);
                    continue;
                }
                sChopped = sChopped + " " + sNextWord;
            }
            tokenizer = new StringTokenizer(sChopped);
            StringBuffer buffer = new StringBuffer(tokenizer.nextToken());
            while (tokenizer.hasMoreTokens()) {
                sNextWord = tokenizer.nextToken();
                if (this.mFontMetrics.stringWidth(buffer.toString()) + this.mFontMetrics.stringWidth(sNextWord) > iBodyWidth) {
                    NewLine = new String[4];
                    NewLine[1] = saNewLine[1];
                    NewLine[3] = saNewLine[3];
                    if (!this.mbHangingIndent && bWasChatMsg) {
                        NewLine[1] = saNewLine[3];
                    }
                    if (bChatMsg) {
                        NewLine[0] = bAddUserName ? saNewLine[0] : "";
                        NewLine[2] = buffer.toString();
                        bWasChatMsg = true;
                    } else {
                        NewLine[0] = buffer.toString();
                        NewLine[2] = "";
                    }
                    this.mvFormatedLines.addElement(NewLine);
                    buffer = new StringBuffer(sNextWord);
                    bAddUserName = false;
                    if (this.mbHangingIndent || !bWasChatMsg) continue;
                    iBodyWidth = this.miWidth - 50;
                    bChatMsg = false;
                    continue;
                }
                buffer.append(" " + sNextWord);
            }
            NewLine = new String[4];
            NewLine[1] = saNewLine[1];
            NewLine[3] = saNewLine[3];
            if (!this.mbHangingIndent && bWasChatMsg) {
                NewLine[1] = saNewLine[3];
            }
            if (bChatMsg) {
                NewLine[0] = bAddUserName ? saNewLine[0] : "";
                NewLine[2] = "" + buffer;
            } else {
                NewLine[0] = "" + buffer;
                NewLine[2] = "";
            }
            this.mvFormatedLines.addElement(NewLine);
        }
        catch (Exception e) {
            String[] UnformattedLine = new String[4];
            UnformattedLine[1] = saNewLine[1];
            UnformattedLine[3] = saNewLine[3];
            UnformattedLine[0] = saNewLine[0];
            UnformattedLine[2] = saNewLine[2];
            this.mvFormatedLines.addElement(UnformattedLine);
        }
    }

    private String chopWord(String word, int bodyWidth) {
        String sChoppedWord = "";
        for (int i = 0; i < word.length(); ++i) {
            if (this.mFontMetrics.stringWidth(sChoppedWord + word.substring(i, i + 1)) >= bodyWidth) {
                word = word.substring(i - 1);
                sChoppedWord = sChoppedWord + " " + this.chopWord(word, bodyWidth);
                return sChoppedWord;
            }
            sChoppedWord = sChoppedWord + word.substring(i, i + 1);
        }
        return sChoppedWord;
    }

    private void render() {
        int i;
        if (this.mbReformatLines) {
            this.mvFormatedLines.removeAllElements();
            for (i = 0; i < this.mvLines.size(); ++i) {
                this.wordWrap(i);
            }
            this.computeScrollbar(true);
            this.mbReformatLines = false;
        }
        this.miTopLine = this.mScrollbar.getValue();
        this.mGraphics.setColor(Color.white);
        this.mGraphics.fillRect(0, 0, this.miWidth, this.miHeight);
        for (i = this.miTopLine; i < this.mvFormatedLines.size(); ++i) {
            String[] saCurrentLine = (String[])this.mvFormatedLines.elementAt(i);
            this.mGraphics.setColor(this.getColor(saCurrentLine[1]));
            this.mGraphics.drawString(saCurrentLine[0], 2, (i - this.miTopLine + 1) * this.miFontHeight);
            if (saCurrentLine[2].length() == 0) continue;
            int vbase = (i - this.miTopLine + 1) * this.miFontHeight;
            if (this.mbHangingIndent) {
                this.mGraphics.setColor(Color.white);
                this.mGraphics.fillRect(this.miNameColWidth - 10, vbase - (int)((double)this.miFontHeight * 0.7), this.miWidth, this.miFontHeight + (int)((double)(2 * this.miFontHeight) * 0.7));
                this.mGraphics.setColor(this.getColor(saCurrentLine[3]));
                this.mGraphics.drawString(saCurrentLine[2], this.miNameColWidth, vbase);
                continue;
            }
            this.mGraphics.setColor(this.getColor(saCurrentLine[3]));
            int iStart = 10 + this.mFontMetrics.stringWidth(saCurrentLine[0]);
            this.mGraphics.drawString(saCurrentLine[2], iStart, vbase);
        }
    }

    void computeScrollbar(boolean scrollToBottom) {
        if (this.mFontMetrics == null) {
            return;
        }
        int iSBTop = scrollToBottom ? this.mvFormatedLines.size() - this.miNbrLinesPerPage + 1 : (this.mvFormatedLines.size() > this.miNbrLinesPerPage ? this.mScrollbar.getValue() : 0);
        this.mScrollbar.setValues(iSBTop, 10, 0, this.mvFormatedLines.size());
    }

    private Color getColor(String RGB) {
        try {
            int red = Integer.decode("0x" + RGB.substring(0, 2));
            int green = Integer.decode("0x" + RGB.substring(2, 4));
            int blue = Integer.decode("0x" + RGB.substring(4, 6));
            return new Color(red, green, blue);
        }
        catch (Exception e) {
            return Color.black;
        }
    }
}

