/*
 * Decompiled with CFR 0.152.
 */
package nik777.chat;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import nik777.chat.Chat;
import nik777.chat.ChatTextArea;
import nik777.chat.UniqueColors;

public class ChatFrame
extends Frame
implements ActionListener,
FocusListener,
KeyListener,
WindowListener,
Chat.Connector {
    public Chat.Connector chat;
    protected int chatid = -1;
    private MyPanel pnlHeader = new MyPanel();
    private Label lblUsername = new Label("");
    private List userList;
    private TextField txtSendMsg;
    private boolean bIconified = false;
    private int nMsgCount = 0;
    private String me;
    private ArrayList session;
    private Date now = new Date();
    private long lastMsg = this.now.getTime();
    private DateFormat inFmt = new SimpleDateFormat("yyyyMMdd'T'hh:mm:ss z");
    private DateFormat outFmt = DateFormat.getDateTimeInstance(2, 1);
    private long maxIdle = 1800000L;
    public String you;
    public boolean doRecord = false;
    protected static int SB_MAX_CAPACITY = 10000;
    protected static String NEWLINE = System.getProperty("line.separator");
    private StringBuffer historyBuff = new StringBuffer(SB_MAX_CAPACITY);
    public Color clientColor;
    public Font clientFont;
    private Hashtable mhashNameColors = new Hashtable();
    private String msButtonWithFocus = "";
    private boolean bGroupChat = false;
    private UniqueColors clr = new UniqueColors();
    private static final String COLOR_MSG = "000000";
    private static final String COLOR_ACTION = "8B008B";
    private static final String COLOR_STATUS = "2E8B57";
    private Vector mvChatHistory = new Vector(200, 50);
    Button btnRecord = null;

    private String nameColor(String name) {
        String sColor = (String)this.mhashNameColors.get(name);
        if (sColor == null) {
            sColor = this.clr.getNextRGB();
            this.mhashNameColors.put(name, new String(sColor));
        }
        return sColor;
    }

    public ChatFrame(Color clientColor, Font clientFont, String itsMe, String idyou, boolean bHeader) {
        this(clientColor, clientFont, itsMe, idyou, bHeader, false);
    }

    public ChatFrame(Color clientColor, Font clientFont, String itsMe, String idYou, boolean bHeader, boolean inviteButton) {
        this.you = idYou;
        this.clientColor = clientColor;
        this.setBackground(clientColor);
        this.clientFont = clientFont;
        this.setFont(clientFont);
        this.setBackground(new Color(255, 255, 255));
        if (bHeader) {
            this.lblUsername.setAlignment(1);
            this.lblUsername.setText("          " + this.you + "          ");
            this.pnlHeader.add(this.lblUsername);
            this.pnlHeader.setBackground(clientColor);
        }
        ChatTextArea txtChatHistory = new ChatTextArea();
        txtChatHistory.setFont(clientFont);
        this.userList = new List();
        String sTime = "On: " + this.outFmt.format(this.now);
        txtChatHistory.append(sTime, COLOR_STATUS);
        txtChatHistory.addFocusListener(this);
        if (this.session == null) {
            this.session = new ArrayList(16);
        }
        this.session.add(txtChatHistory);
        this.chatHistory(sTime, COLOR_STATUS);
        this.txtSendMsg = new TextField();
        this.txtSendMsg.addActionListener(this);
        this.txtSendMsg.addKeyListener(this);
        Button btnSend = new Button("Send");
        btnSend.addActionListener(this);
        btnSend.addFocusListener(this);
        Button btnInvite = new Button("Invite");
        btnInvite.addActionListener(this);
        btnInvite.addFocusListener(this);
        this.btnRecord = new Button(" Log ");
        this.btnRecord.addActionListener(this);
        this.btnRecord.addFocusListener(this);
        int x = 0;
        int y = 0;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 2;
        gbConstraints.gridx = x;
        gbConstraints.gridy = y;
        this.bGroupChat = inviteButton;
        gbConstraints.gridwidth = inviteButton ? 4 : 3;
        gbConstraints.gridheight = 1;
        gbConstraints.ipadx = 0;
        gbConstraints.ipady = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 0.0;
        if (bHeader) {
            this.add((Component)this.pnlHeader, gbConstraints);
        }
        gbConstraints.gridx = x;
        gbConstraints.gridy = ++y;
        gbConstraints.gridwidth -= 2;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.fill = 1;
        this.add((Component)txtChatHistory, gbConstraints);
        gbConstraints.gridx = x += gbConstraints.gridwidth;
        gbConstraints.gridy = y++;
        gbConstraints.gridwidth = 2;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.fill = 1;
        this.add((Component)this.userList, gbConstraints);
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 0.0;
        x = 0;
        gbConstraints.gridx = x++;
        gbConstraints.gridy = y;
        gbConstraints.gridwidth = 1;
        gbConstraints.fill = 2;
        gbConstraints.weightx = 1.0;
        this.add((Component)this.txtSendMsg, gbConstraints);
        gbConstraints.gridx = x++;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 1;
        gbConstraints.fill = 0;
        this.add((Component)btnSend, gbConstraints);
        if (inviteButton) {
            gbConstraints.gridx = x;
            gbConstraints.weightx = 0.0;
            gbConstraints.fill = 0;
            this.add((Component)btnInvite, gbConstraints);
        }
        gbConstraints.gridx = ++x;
        gbConstraints.weightx = 0.0;
        gbConstraints.fill = 0;
        this.add((Component)this.btnRecord, gbConstraints);
        this.addWindowListener(this);
        SymComponent aSymComponent = new SymComponent();
        this.addComponentListener(aSymComponent);
        this.pack();
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 450);
    }

    public void open(Chat.Connector chat) {
        this.chat = chat;
        chat.open(this);
    }

    public void close(Chat.Connector chat) {
        if (chat != null && this.chatid >= 0) {
            chat.leave(this.chatid);
        }
        chat = null;
    }

    public int join(String conn, String name, String password) {
        this.me = name;
        this.chatid = this.chat.join(conn, name, password);
        return this.chatid;
    }

    public void leave(int id) {
        this.chat.leave(this.chatid);
    }

    public void add(String conn, String name, String detials) {
        this.userList.add(name);
        this.userList.invalidate();
    }

    public void remove(String conn, String name) {
        this.userList.remove(name);
        this.userList.invalidate();
    }

    public void accept(int id, String from, String to, String msg) {
        this.msgReceived(id, from, msg);
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127 || evt.getKeyCode() == 18 || evt.getKeyCode() == 17 || !evt.isAltDown() || evt.isControlDown()) {
            // empty if block
        }
        if (evt.getKeyCode() == 9) {
            // empty if block
        }
        if (evt.getKeyCode() == 10) {
            if (this.msButtonWithFocus.length() > 0) {
                if (this.msButtonWithFocus.compareTo("Send") == 0) {
                    this.msgSend();
                } else if (this.msButtonWithFocus.compareTo("Invite") == 0) {
                    this.invite();
                } else {
                    this.record(this.msButtonWithFocus);
                }
            } else {
                this.msgSend();
            }
        }
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().compareTo("Send") == 0) {
            this.msgSend();
        } else if (ae.getActionCommand().compareTo("Invite") == 0) {
            this.invite();
        } else {
            this.record(ae.getActionCommand());
        }
    }

    public void displayChatHistory() {
        TextArea ta = new TextArea(this.chatHistoryToString());
        final Dialog dialog = new Dialog(this, "CHAT HISTORY: please cut and paste the message to a text document.", true);
        dialog.add(ta);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                dialog.dispose();
            }
        });
        dialog.pack();
        dialog.show();
    }

    public void msgReceived(int sessn, String id, String sResponse) {
        this.msgReceived(sessn, id, sResponse, null);
    }

    public void msgReceived(int sessn, String id, String sResponse, String sTimestamp) {
        ChatTextArea txtChatHistory;
        System.out.println("msgReceived: " + id + "; " + sResponse);
        this.nMsgCount = this.bIconified ? ++this.nMsgCount : 0;
        this.updateCount(this.nMsgCount);
        if (sessn >= 0 && sessn < this.session.size()) {
            txtChatHistory = (ChatTextArea)this.session.get(sessn);
        } else {
            System.out.println();
            txtChatHistory = (ChatTextArea)this.session.get(0);
        }
        if (id == null || id.length() == 0) {
            txtChatHistory.append(sResponse, COLOR_STATUS);
            this.chatHistory(sResponse, COLOR_STATUS);
        } else if (sResponse.startsWith("/me")) {
            sResponse = sResponse.substring(3);
            txtChatHistory.append("* " + id + " " + sResponse, COLOR_ACTION);
            this.chatHistory(id + " " + sResponse, COLOR_ACTION);
        } else {
            if (sTimestamp != null && sTimestamp.length() > 0) {
                try {
                    this.now = this.inFmt.parse(sTimestamp + " GMT");
                }
                catch (ParseException e) {
                    System.out.println("timestamp parse error: " + e);
                }
            } else {
                this.now.setTime(System.currentTimeMillis());
                System.out.println("now = " + this.now.toString());
            }
            System.out.println("now - lastMsg = " + Math.abs(this.now.getTime() - this.lastMsg));
            if (Math.abs(this.now.getTime() - this.lastMsg) > this.maxIdle) {
                this.systemMsg("Sent: " + this.outFmt.format(this.now));
            }
            this.lastMsg = this.now.getTime();
            txtChatHistory.appendChatText(id + " says:", this.nameColor(id), sResponse, COLOR_MSG);
            this.chatHistory(id + " says:", this.nameColor(id), sResponse, COLOR_MSG);
        }
        if (!this.bGroupChat) {
            this.lblUsername.setText(this.you);
        }
    }

    public void systemMsg(String sMsg) {
        for (int i = 0; i < this.session.size(); ++i) {
            ((ChatTextArea)this.session.get(i)).append(sMsg, COLOR_STATUS);
        }
        this.chatHistory(sMsg, COLOR_STATUS);
    }

    public void msgReplyStarted(String id, String msg) {
        this.lblUsername.setText(this.you + " " + msg);
    }

    public void changeStatus(String id, String sStatus) {
    }

    protected void popTop() {
        this.toFront();
    }

    public void focusGained(FocusEvent fe) {
        if (fe.getComponent() instanceof Button) {
            this.msButtonWithFocus = ((Button)fe.getComponent()).getLabel();
        }
    }

    public void focusLost(FocusEvent fe) {
        this.msButtonWithFocus = "";
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosed(WindowEvent event) {
        this.leave(this.chatid);
    }

    public void windowClosing(WindowEvent event) {
        this.leave(this.chatid);
        this.setVisible(false);
        this.dispose();
    }

    public void windowDeiconified(WindowEvent event) {
        Object object = event.getSource();
        if (object == this) {
            this.ChatFrame_WindowDeiconified(event);
        }
    }

    public void windowIconified(WindowEvent event) {
        Object object = event.getSource();
        if (object == this) {
            this.ChatFrame_WindowIconified(event);
        }
    }

    private void msgSend() {
        if (this.txtSendMsg.getText().length() > 0) {
            String msg = this.txtSendMsg.getText();
            this.txtSendMsg.setText("");
            this.msgReceived(-1, this.me, msg);
            this.chat.accept(this.chatid, this.me, this.you, msg);
        }
        this.txtSendMsg.requestFocus();
        this.nMsgCount = 0;
        this.updateCount(this.nMsgCount);
    }

    public void inviteeSelected(String sXML) {
    }

    private void invite() {
    }

    private void record(String actionCommand) {
        if (actionCommand.equals(" Record ")) {
            this.doRecord = true;
            this.btnRecord.setLabel("Stop Rec");
            this.updateCount(this.nMsgCount);
        } else if (actionCommand.equals("Stop Rec")) {
            this.btnRecord.setLabel(" Record ");
            this.doRecord = false;
            this.updateCount(this.nMsgCount);
            this.displayChatHistory();
        }
    }

    private void ChatFrame_WindowIconified(WindowEvent event) {
        this.bIconified = true;
        this.updateCount(this.nMsgCount);
    }

    private void updateCount(int n) {
        String title = "";
        title = n == 0 ? this.you : "(" + n + ") " + this.you;
        if (this.doRecord) {
            title = title + ", Recording...";
        }
        this.setTitle(title);
    }

    private void ChatFrame_WindowDeiconified(WindowEvent event) {
        this.bIconified = false;
        this.nMsgCount = 0;
        this.updateCount(this.nMsgCount);
    }

    public void ChatFrame_ComponentResized(ComponentEvent event) {
        if (this.getSize().width < 200) {
            this.setSize(200, this.getSize().height);
        }
        if (this.getSize().height < 200) {
            this.setSize(this.getSize().width, 200);
        }
    }

    private void chatHistory(String sMsg, String sMsgColor) {
        this.chatHistory("", "", sMsg, sMsgColor);
    }

    private void chatHistory(String sName, String sNameColor, String sMsg, String sMsgColor) {
        if (!this.doRecord) {
            return;
        }
        int nameLen = 0;
        int msgLen = 0;
        if (sName != null) {
            nameLen += sName.length();
        }
        if (sMsg != null) {
            msgLen += sMsg.length();
        }
        if (nameLen + msgLen + 20 + this.historyBuff.length() > this.historyBuff.capacity()) {
            this.displayChatHistory();
        }
        if (sName.length() > 0) {
            this.historyBuff.append(sName);
            int pad = 20 - nameLen;
            for (int i = 0; i < pad; ++i) {
                this.historyBuff.append(" ");
            }
        }
        this.historyBuff.append(sMsg + NEWLINE);
    }

    private String chatHistoryToString() {
        String s = this.historyBuff.toString();
        this.historyBuff = new StringBuffer(SB_MAX_CAPACITY);
        return s;
    }

    class SymComponent
    extends ComponentAdapter {
        SymComponent() {
        }

        public void componentResized(ComponentEvent event) {
            Object object = event.getSource();
            if (object == ChatFrame.this) {
                ChatFrame.this.ChatFrame_ComponentResized(event);
            }
        }
    }

    class MyPanel
    extends Panel {
        MyPanel() {
        }

        public void paint(Graphics g) {
            g.setColor(ChatFrame.this.clientColor);
            g.draw3DRect(2, 4, this.getBounds().width - 4, this.getBounds().height - 8, false);
            FontMetrics fnt = g.getFontMetrics();
            int nWidth = fnt.stringWidth("Channel");
            int nHeight = fnt.getDescent();
            g.setColor(ChatFrame.this.clientColor);
            g.fillRect(5, 0, nWidth + 5, 18);
            g.setColor(Color.black);
            g.drawString("Channel", 8, 10);
        }
    }
}

