/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.spmanager;

import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.spmanager.SPManagerPlugin;
import artofillusion.ui.EditingWindow;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SPManagerUtils {
    public static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    public static DocumentBuilder builder;

    public static int[] increaseIntArray(int[] intArray) {
        if (intArray == null) {
            int[] tmpArray = new int[1];
            return tmpArray;
        }
        int[] tmpArray = new int[intArray.length + 1];
        System.arraycopy(intArray, 0, tmpArray, 0, intArray.length);
        return tmpArray;
    }

    public static int[] deleteIntArrayElement(int[] intArray, int element) {
        if (intArray == null) {
            return null;
        }
        if (intArray.length == 1) {
            return null;
        }
        int[] tmpArray = new int[intArray.length - 1];
        if (element > 0) {
            System.arraycopy(intArray, 0, tmpArray, 0, element);
        }
        if (element < intArray.length - 1) {
            System.arraycopy(intArray, element + 1, tmpArray, element, tmpArray.length - element);
        }
        return tmpArray;
    }

    public static void setDialogLocation(JFrame frame, JFrame parentFrame) {
        Point location = new Point();
        location.x = parentFrame.getLocation().x + parentFrame.getWidth() / 2 - frame.getWidth() / 2;
        location.y = parentFrame.getLocation().y + parentFrame.getHeight() / 2 - frame.getHeight() / 2;
        if (location.x < 0) {
            location.x = 0;
        }
        if (location.y < 0) {
            location.y = 0;
        }
        frame.setLocation(location);
    }

    public static void updateAllAoIWindows() {
        try {
            EditingWindow[] allWindows = ModellingApp.getWindows();
            for (int i = 0; i < allWindows.length; ++i) {
                if (!(allWindows[i] instanceof LayoutWindow)) continue;
                ((LayoutWindow)allWindows[i]).rebuildScriptsMenu();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static byte[] getJarFileContent(String filename) {
        File dir = new File(SPManagerPlugin.PLUGIN_DIR);
        if (dir.exists()) {
            String[] files = dir.list();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].startsWith("SPManager")) continue;
                ZipFile zf = null;
                try {
                    zf = new ZipFile(new File(dir, files[i]));
                }
                catch (IOException ex) {
                    continue;
                }
                if (zf == null) continue;
                ZipEntry ze = zf.getEntry(filename);
                if (ze != null) {
                    int size = (int)ze.getSize();
                    byte[] data = new byte[size];
                    try {
                        BufferedInputStream in = new BufferedInputStream(zf.getInputStream(ze));
                        for (int j = 0; j < size; ++j) {
                            data[j] = (byte)in.read();
                        }
                        in.close();
                    }
                    catch (IOException ex) {
                        System.out.println("IOException in getJarFileContent");
                    }
                    return data;
                }
                System.out.println("File " + filename + " not found within zip file");
            }
        } else {
            System.out.println("Dir does not exist");
        }
        return null;
    }

    public static byte[] getJarFileContent(String jarPath, String filename) {
        ZipFile zf = null;
        try {
            zf = new ZipFile(new File(jarPath));
        }
        catch (IOException ex) {
            return null;
        }
        if (zf != null) {
            ZipEntry ze = zf.getEntry(filename);
            if (ze != null) {
                int size = (int)ze.getSize();
                byte[] data = new byte[size];
                try {
                    BufferedInputStream in = new BufferedInputStream(zf.getInputStream(ze));
                    for (int j = 0; j < size; ++j) {
                        data[j] = (byte)in.read();
                    }
                    in.close();
                }
                catch (IOException ex) {
                    System.out.println("IOException in getJarFileContent");
                }
                return data;
            }
            System.out.println("File " + filename + " not found within zip file");
        }
        return null;
    }

    public static Node getNodeFromNodeList(NodeList nl, String nodeName, int index) {
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals(nodeName) || index-- != 0) continue;
            return n;
        }
        return null;
    }

    public static String getAttribute(Node node, String name) {
        NamedNodeMap nm = node.getAttributes();
        if (nm == null) {
            return null;
        }
        Node nn = nm.getNamedItem(name);
        if (nn == null) {
            return null;
        }
        return nn.getNodeValue();
    }

    public static String getNodeValue(Node node, String name, String defaultVal, int index) {
        NodeList nl = node.getChildNodes();
        if (nl.getLength() == 0) {
            return defaultVal;
        }
        Node n = SPManagerUtils.getNodeFromNodeList(nl, name, index);
        if (n == null) {
            return defaultVal;
        }
        if ((n = n.getChildNodes().item(0)) == null) {
            return defaultVal;
        }
        String value = n.getNodeValue();
        if (value == null) {
            value = defaultVal;
        }
        return value;
    }

    public static int parseInt(String val, int start, int max) {
        char c;
        if (max < 0 || max > val.length()) {
            max = val.length();
        }
        int result = 0;
        for (int i = start; i < max && Character.isDigit(c = val.charAt(i)); ++i) {
            result = result * 10 + Character.digit(c, 10);
        }
        return result;
    }

    static {
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        }
    }
}

