/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.spmanager;

import artofillusion.spmanager.HttpSPMFileSystem;
import artofillusion.spmanager.SPMFileSystem;
import artofillusion.spmanager.SPMObjectInfo;
import artofillusion.spmanager.SPMSplitPane;
import artofillusion.spmanager.SPMTranslate;
import artofillusion.spmanager.SPManagerPlugin;
import artofillusion.spmanager.SPManagerUtils;
import artofillusion.spmanager.StatusDialog;
import buoy.event.ValueChangedEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BLabel;
import buoy.widget.BScrollPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BTextArea;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class InstallSplitPane
extends SPMSplitPane {
    private URL repository;
    private BButton installAllButton;
    private BButton installSingleButton;
    private BButton selectAllButton;
    private BCheckBox selectCB;
    private boolean setup = false;
    private boolean unknownHost = false;
    private StatusDialog status;
    private long downloadedLength = 0L;
    private long lengthToDownload;
    private boolean isDownloading;
    private SPMObjectInfo installNodeInfo;
    protected ArrayList errors = null;
    protected static final String[] CONTINUE_IGNORE = new String[]{SPMTranslate.text("Continue"), SPMTranslate.text("Stop"), SPMTranslate.text("Ignore")};

    public InstallSplitPane(short workMode, URL repository) {
        super(workMode == 2 ? "installScriptsPlugins" : "updateScriptsPlugins", workMode);
        this.fs = new HttpSPMFileSystem(repository);
        this.initialize();
    }

    public InstallSplitPane(short workMode, SPMFileSystem fs) {
        super(workMode == 2 ? "installScriptsPlugins" : "updateScriptsPlugins", workMode);
        this.fs = fs;
        this.initialize();
    }

    private void initialize() {
        LayoutInfo layout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(0, 5, 0, 5), new Dimension(0, 0));
        if (this.workMode == 1) {
            this.installAllButton = SPMTranslate.bButton("updateAllSelected", (Object)this, "doInstallAll");
            this.buttonRow.add((Widget)this.installAllButton, layout);
            this.installAllButton.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/artofillusion/spmanager/icons/Refresh16.gif")));
            this.installSingleButton = SPMTranslate.bButton("updateSingle", (Object)this, "doInstallSingle");
            this.buttonRow.add((Widget)this.installSingleButton, layout);
            this.installSingleButton.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/artofillusion/spmanager/icons/Refresh16.gif")));
            this.selectAllButton = SPMTranslate.bButton("selectAll", (Object)this, "doSelectAll");
            this.buttonRow.add((Widget)this.selectAllButton, layout);
            this.installSingleButton.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/artofillusion/spmanager/icons/Refresh16.gif")));
        } else {
            this.installAllButton = SPMTranslate.bButton("installAllSelected", (Object)this, "doInstallAll");
            this.buttonRow.add((Widget)this.installAllButton, layout);
            this.installAllButton.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/artofillusion/spmanager/icons/Import16.gif")));
            this.installSingleButton = SPMTranslate.bButton("installSingle", (Object)this, "doInstallSingle");
            this.buttonRow.add((Widget)this.installSingleButton, layout);
            this.installSingleButton.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/artofillusion/spmanager/icons/Import16.gif")));
            this.selectAllButton = SPMTranslate.bButton("selectAll", (Object)this, "doSelectAll");
            this.buttonRow.add((Widget)this.selectAllButton, layout);
            this.installSingleButton.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/artofillusion/spmanager/icons/Import16.gif")));
        }
        this.selectCB = SPMTranslate.bCheckBox("selected", false, (Object)this, "doSelectCB");
        this.buttonRow.add((Widget)this.selectCB);
        this.installSingleButton.setEnabled(false);
        this.selectCB.setEnabled(false);
        this.updateTree();
        this.modified = false;
    }

    protected void updateTree() {
        if (this.setup) {
            this.fs.getRemoteInfo(new Runnable(){

                public void run() {
                    InstallSplitPane.this.doCallbackUpdate();
                }
            });
        }
    }

    public void doCallbackUpdate() {
        this.getPlugins();
        this.getToolScripts();
        this.getObjectScripts();
        this.getStartupScripts();
        this.setup = true;
        ((DefaultTreeModel)this.tree.getModel()).reload();
    }

    public void doSetup() {
        if (!this.setup) {
            this.fs.getRemoteInfo(new Runnable(){

                public void run() {
                    InstallSplitPane.this.doCallbackUpdate();
                }
            });
        }
    }

    private void getPlugins() {
        this.getFiles(this.pluginsPath, this.fs.getPlugins(), this.getManager().fs.getPlugins());
    }

    private void getToolScripts() {
        this.getFiles(this.toolScriptsPath, this.fs.getToolScripts(), this.getManager().fs.getToolScripts());
    }

    private void getObjectScripts() {
        this.getFiles(this.objectScriptsPath, this.fs.getObjectScripts(), this.getManager().fs.getObjectScripts());
    }

    private void getStartupScripts() {
        this.getFiles(this.startupScriptsPath, this.fs.getStartupScripts(), this.getManager().fs.getStartupScripts());
    }

    private void getFiles(TreePath addTo, Vector infos, Vector managerInfoVector) {
        SPMObjectInfo info;
        TreeMap<String, SPMObjectInfo> map = new TreeMap<String, SPMObjectInfo>();
        for (int i = 0; i < infos.size(); ++i) {
            info = (SPMObjectInfo)infos.elementAt(i);
            if (info.restriction >= 4) continue;
            boolean eligible = this.workMode == 2;
            SPMObjectInfo managerInfo = null;
            String name = info.getName();
            for (int j = 0; j < managerInfoVector.size(); ++j) {
                if (!((SPMObjectInfo)managerInfoVector.elementAt(j)).getName().equals(name)) continue;
                boolean bl = eligible = this.workMode == 1;
                if (!eligible) continue;
                managerInfo = (SPMObjectInfo)managerInfoVector.elementAt(j);
                System.out.println(info.getName());
                System.out.println("major distant local :" + info.getMajor() + " " + managerInfo.getMajor());
                System.out.println("minor distant local :" + info.getMinor() + " " + managerInfo.getMinor());
                System.out.println("beta distant local :" + info.isBeta() + " " + managerInfo.isBeta());
                System.out.println("beta distant local :" + info.getBeta() + " " + managerInfo.getBeta());
                if (info.getMajor() < managerInfo.getMajor()) {
                    eligible = false;
                    continue;
                }
                if (info.getMajor() != managerInfo.getMajor()) continue;
                if (info.getMinor() < managerInfo.getMinor()) {
                    eligible = false;
                    continue;
                }
                if (info.getMinor() != managerInfo.getMinor()) continue;
                if (managerInfo.isBeta()) {
                    if (!info.isBeta() || info.getBeta() > managerInfo.getBeta()) continue;
                    eligible = false;
                    continue;
                }
                eligible = false;
            }
            if (!eligible) continue;
            map.put(info.getName(), info);
        }
        Collection col = map.values();
        if (!col.isEmpty()) {
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                info = (SPMObjectInfo)iter.next();
                DefaultMutableTreeNode tn = new DefaultMutableTreeNode(info.getName());
                tn.setAllowsChildren(false);
                tn.setUserObject(info);
                this.tree.addNode(addTo, (MutableTreeNode)tn);
            }
        }
    }

    public void doInstallAll() {
        if (!this.isDownloading) {
            this.isDownloading = true;
            this.lengthToDownload = 0L;
            this.downloadedLength = 0L;
            this.lengthToDownload = this.getInstallLength(this.pluginsPath);
            this.lengthToDownload += this.getInstallLength(this.toolScriptsPath);
            this.lengthToDownload += this.getInstallLength(this.objectScriptsPath);
            this.lengthToDownload += this.getInstallLength(this.startupScriptsPath);
            if (this.lengthToDownload > 0L) {
                this.status = new StatusDialog(SPManagerPlugin.getFrame());
                new Thread(){

                    public void run() {
                        InstallSplitPane.this.installAllSelected(InstallSplitPane.this.pluginsPath);
                        InstallSplitPane.this.installAllSelected(InstallSplitPane.this.toolScriptsPath);
                        InstallSplitPane.this.installAllSelected(InstallSplitPane.this.objectScriptsPath);
                        InstallSplitPane.this.installAllSelected(InstallSplitPane.this.startupScriptsPath);
                        InstallSplitPane.this.voidSelection();
                        InstallSplitPane.this.getManager().doUpdate();
                        InstallSplitPane.this.isDownloading = false;
                        InstallSplitPane.this.status.dispose();
                        InstallSplitPane.this.status = null;
                        SPManagerUtils.updateAllAoIWindows();
                    }
                }.start();
            }
        }
    }

    private long getInstallLength(TreePath path) {
        long length = 0L;
        int count = this.tree.getChildNodeCount(path);
        if (count > 0) {
            for (int j = count - 1; j >= 0; --j) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getChildNode(path, j).getLastPathComponent();
                SPMObjectInfo nodeInfo = (SPMObjectInfo)node.getUserObject();
                if (!nodeInfo.isSelected()) continue;
                length += nodeInfo.getTotalLength();
            }
        }
        return length;
    }

    /*
     * Unable to fully structure code
     */
    private void installAllSelected(TreePath path) {
        block8: {
            count = this.tree.getChildNodeCount(path);
            if (count <= 0) break block8;
            if (this.errors == null) {
                this.errors = new ArrayList<E>(128);
            } else {
                this.errors.clear();
            }
            ignoreErrs = false;
            err = 0;
            block4: for (j = count - 1; j >= 0; --j) {
                node = (DefaultMutableTreeNode)this.tree.getChildNode(path, j).getLastPathComponent();
                nodeInfo = (SPMObjectInfo)node.getUserObject();
                if (!nodeInfo.isSelected()) continue;
                this.installFile(nodeInfo);
                this.tree.removeNode(this.tree.getChildNode(path, j));
                if (this.errors.size() <= err || ignoreErrs) ** GOTO lbl-1000
                messg = SPMTranslate.bLabel("errMsg");
                dlg = new BStandardDialog("SPManager", (Object)messg, BStandardDialog.WARNING);
                switch (dlg.showOptionDialog(null, InstallSplitPane.CONTINUE_IGNORE, SPMTranslate.text("Continue"))) {
                    case 1: {
                        break block4;
                    }
                    case 2: {
                        ignoreErrs = true;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        err = this.errors.size();
                    }
                }
            }
            if (this.errors.size() > 0) {
                InstallSplitPane.showErrors(this.errors);
            }
        }
    }

    public void doInstallSingle() {
        this.installNodeInfo = this.getSelectedNodeInfo();
        if (this.installNodeInfo == null) {
            return;
        }
        if (!this.isDownloading) {
            this.isDownloading = true;
            this.lengthToDownload = this.installNodeInfo.getTotalLength();
            this.downloadedLength = 0L;
            if (this.lengthToDownload > 0L) {
                if (this.errors == null) {
                    this.errors = new ArrayList(128);
                } else {
                    this.errors.clear();
                }
                this.status = new StatusDialog(SPManagerPlugin.getFrame());
                new Thread(){

                    public void run() {
                        InstallSplitPane.this.installFile(InstallSplitPane.this.installNodeInfo);
                        if (InstallSplitPane.this.errors.size() > 0) {
                            InstallSplitPane.showErrors(InstallSplitPane.this.errors);
                        }
                        InstallSplitPane.this.tree.removeNode(InstallSplitPane.this.tree.getSelectedNode());
                        InstallSplitPane.this.voidSelection();
                        InstallSplitPane.this.getManager().doUpdate();
                        InstallSplitPane.this.isDownloading = false;
                        InstallSplitPane.this.status.dispose();
                        InstallSplitPane.this.status = null;
                        SPManagerUtils.updateAllAoIWindows();
                    }
                }.start();
            }
        }
    }

    private void installFile(SPMObjectInfo nodeInfo) {
        HashMap<String, File> transaction = new HashMap<String, File>(32);
        int errCount = this.errors.size();
        String fileName = null;
        switch (this.fs.getInfoType(nodeInfo)) {
            case 0: {
                fileName = SPManagerPlugin.PLUGIN_DIR + File.separatorChar + nodeInfo.getName() + ".jar";
                this.modified = true;
                break;
            }
            case 1: {
                fileName = SPManagerPlugin.TOOL_SCRIPT_DIR + File.separatorChar + nodeInfo.getName() + ".bsh";
                break;
            }
            case 2: {
                fileName = SPManagerPlugin.OBJECT_SCRIPT_DIR + File.separatorChar + nodeInfo.getName() + ".bsh";
                break;
            }
            case 3: {
                fileName = SPManagerPlugin.STARTUP_SCRIPT_DIR + File.separatorChar + nodeInfo.getName() + ".bsh";
            }
        }
        File update = new File(fileName + ".upd");
        File folder = new File(SPManagerPlugin.TEMP_DIR, update.getParentFile().getName());
        System.out.println("folder=" + folder.getAbsolutePath());
        if (!folder.exists() && !folder.mkdirs()) {
            this.errors.add(SPMTranslate.text("error") + "cannot open/create " + folder.getAbsolutePath());
            System.out.println("cannot open/create " + folder.getAbsolutePath());
        }
        update = new File(folder, update.getName());
        System.out.println("downloading to " + update.getAbsolutePath());
        if (this.status != null) {
            this.status.setText(SPMTranslate.text("downloading", nodeInfo.getName()));
        }
        this.downloadedLength = this.fs.getInfoType(nodeInfo) == 0 ? (this.downloadedLength += HttpSPMFileSystem.downloadRemoteBinaryFile(nodeInfo.httpFile, update.getAbsolutePath(), nodeInfo.length, this.status, this.lengthToDownload, this.downloadedLength, this.errors)) : (this.downloadedLength += HttpSPMFileSystem.downloadRemoteBinaryFile(nodeInfo.httpFile, update.getAbsolutePath(), nodeInfo.length, this.status, this.lengthToDownload, this.downloadedLength, this.errors));
        transaction.put(fileName, update);
        if (nodeInfo.files != null) {
            for (int j = 0; j < nodeInfo.files.length; ++j) {
                fileName = null;
                switch (this.fs.getInfoType(nodeInfo)) {
                    case 0: {
                        fileName = SPManagerPlugin.PLUGIN_DIR + File.separatorChar + nodeInfo.destination.get(j) + nodeInfo.files[j];
                        break;
                    }
                    case 1: {
                        fileName = SPManagerPlugin.TOOL_SCRIPT_DIR + File.separatorChar + nodeInfo.destination.get(j) + nodeInfo.files[j];
                        break;
                    }
                    case 2: {
                        fileName = SPManagerPlugin.OBJECT_SCRIPT_DIR + File.separatorChar + nodeInfo.destination.get(j) + nodeInfo.files[j];
                        break;
                    }
                    case 3: {
                        fileName = SPManagerPlugin.STARTUP_SCRIPT_DIR + File.separatorChar + nodeInfo.destination.get(j) + nodeInfo.files[j];
                    }
                }
                update = new File(fileName + ".upd");
                folder = new File(SPManagerPlugin.TEMP_DIR, update.getParentFile().getName());
                if (!folder.exists() && !folder.mkdirs()) {
                    this.errors.add(SPMTranslate.text("error") + "cannot open/create " + folder.getAbsolutePath());
                    System.out.println("cannot open/create " + folder.getAbsolutePath());
                }
                update = new File(folder, update.getName());
                System.out.println("downloading to " + update.getAbsolutePath());
                if (this.status != null) {
                    this.status.setText(SPMTranslate.text("downloading", nodeInfo.files[j]));
                }
                URL addFileURL = nodeInfo.getAddFileURL(j);
                this.downloadedLength += HttpSPMFileSystem.downloadRemoteBinaryFile(addFileURL, update.getAbsolutePath(), nodeInfo.fileSizes[j], this.status, this.lengthToDownload, this.downloadedLength, this.errors);
                transaction.put(fileName, update);
            }
        }
        Iterator iter = transaction.entrySet().iterator();
        while (iter.hasNext()) {
            try {
                RandomAccessFile raf;
                Map.Entry entry = iter.next();
                fileName = (String)entry.getKey();
                update = (File)entry.getValue();
                if (this.errors.size() > errCount) {
                    if (update.delete()) continue;
                    System.out.println("SPManager: tx abort:  update file not deleted: " + update.getAbsolutePath());
                    raf = new RandomAccessFile(update, "rw");
                    raf.setLength(0L);
                    raf.close();
                    continue;
                }
                folder = new File(fileName).getParentFile();
                if (!folder.exists() && !folder.mkdirs()) {
                    throw new RuntimeException("cannot open/create " + folder.getAbsolutePath());
                }
                File orig = new File(fileName);
                if (orig.exists()) {
                    orig.delete();
                }
                System.out.println("copying file to " + orig.getAbsolutePath());
                if (update.renameTo(orig)) continue;
                System.out.println("SPManager: old-style copy...");
                if (InstallSplitPane.copyFile(update, orig)) {
                    if (update.delete()) continue;
                    System.out.println("SPManager: update file not deleted: " + update.getAbsolutePath());
                    raf = new RandomAccessFile(update, "rw");
                    raf.setLength(0L);
                    raf.close();
                    continue;
                }
                System.out.println("SPManager.cleanup: could not copy " + fileName);
                this.errors.add("couldn't copy " + fileName);
            }
            catch (Exception e) {
                this.errors.add(SPMTranslate.text("error") + "(" + fileName + ")" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean copyFile(File in, File out) {
        BufferedInputStream is = null;
        OutputStream os = null;
        try {
            int b;
            is = new BufferedInputStream(new FileInputStream(in));
            os = new BufferedOutputStream(new FileOutputStream(out));
            while ((b = ((InputStream)is).read()) >= 0) {
                os.write((byte)b);
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                os.flush();
                os.close();
                ((InputStream)is).close();
            }
            catch (Exception e) {}
        }
        return true;
    }

    private void selectAllInfos(TreePath path) {
        int count = this.tree.getChildNodeCount(path);
        for (int j = 0; j < count; ++j) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getChildNode(path, j).getLastPathComponent();
            SPMObjectInfo nodeInfo = (SPMObjectInfo)node.getUserObject();
            nodeInfo.setSelected(true);
            if (this.extMap != null) {
                this.extMap.clear();
            }
            this.selectExternals(nodeInfo);
        }
    }

    public void doSelectAll() {
        this.selectAllInfos(this.pluginsPath);
        this.selectAllInfos(this.toolScriptsPath);
        this.selectAllInfos(this.objectScriptsPath);
        this.selectAllInfos(this.startupScriptsPath);
        SPMObjectInfo nodeInfo = this.getSelectedNodeInfo();
        if (nodeInfo != null) {
            this.selectCB.setState(true);
        }
        this.repaint();
    }

    public void doSelectCB() {
        SPMObjectInfo nodeInfo = this.getSelectedNodeInfo();
        if (nodeInfo != null) {
            nodeInfo.setSelected(this.selectCB.getState());
            if (this.extMap != null) {
                this.extMap.clear();
            }
            this.selectExternals(nodeInfo);
        }
        this.repaint();
    }

    protected void notifyObjectInfoSelection(SPMObjectInfo info) {
        this.selectCB.removeEventLink(ValueChangedEvent.class, (Object)this);
        this.selectCB.setState(info.isSelected());
        this.selectCB.addEventLink(ValueChangedEvent.class, (Object)this, "doSelectCB");
        super.notifyObjectInfoSelection(info);
    }

    public void scriptSelection(boolean deletable) {
        this.installSingleButton.setEnabled(true);
        this.selectCB.setEnabled(true);
        SPMObjectInfo nodeInfo = this.getSelectedNodeInfo();
        if (nodeInfo != null) {
            Collection externals;
            this.selectCB.setState(nodeInfo.isSelected());
            if (nodeInfo.restriction >= 3) {
                this.selectCB.setEnabled(false);
                this.installSingleButton.setEnabled(false);
            }
            if (nodeInfo.refcount > 0) {
                this.selectCB.setEnabled(false);
            }
            if ((externals = nodeInfo.getExternals()) != null && externals.size() > 0) {
                this.installSingleButton.setEnabled(false);
            }
        }
        super.scriptSelection(deletable);
    }

    public void pluginSelection(boolean deletable) {
        this.installSingleButton.setEnabled(true);
        this.selectCB.setEnabled(true);
        SPMObjectInfo nodeInfo = this.getSelectedNodeInfo();
        if (nodeInfo != null) {
            Collection externals;
            this.selectCB.setState(nodeInfo.isSelected());
            if (nodeInfo.restriction >= 3) {
                this.selectCB.setEnabled(false);
                this.installSingleButton.setEnabled(false);
            }
            if (nodeInfo.refcount > 0) {
                this.selectCB.setEnabled(false);
            }
            if ((externals = nodeInfo.getExternals()) != null && externals.size() > 0) {
                this.installSingleButton.setEnabled(false);
            }
        }
        super.pluginSelection(deletable);
    }

    public void voidSelection() {
        this.installSingleButton.setEnabled(false);
        this.selectCB.setEnabled(false);
        super.voidSelection();
    }

    public void setRepository(URL newRep) {
        this.repository = newRep;
        this.fs = new HttpSPMFileSystem(newRep);
        this.doSetup();
    }

    public static void showErrors(ArrayList errs) {
        BTextArea txt = new BTextArea(5, 45);
        txt.setEditable(false);
        txt.setWrapStyle(BTextArea.WRAP_WORD);
        for (int i = 0; i < errs.size(); ++i) {
            txt.append(errs.get(i) + "\n");
        }
        BScrollPane detail = new BScrollPane((Widget)txt, BScrollPane.SCROLLBAR_NEVER, BScrollPane.SCROLLBAR_AS_NEEDED);
        BLabel messg = SPMTranslate.bLabel("errMsg");
        new BStandardDialog("SPManager", (Object)new Widget[]{messg, detail}, BStandardDialog.WARNING).showMessageDialog(null);
    }
}

