/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.swing;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.antlr.xjlib.appkit.swing.XJTableDelegate;

public class XJTable
extends JTable
implements Autoscroll {
    private int margin = 12;
    public XJTableDelegate delegate;
    public int selectionRow = -1;
    public boolean ignoreSelectionEvent = false;
    public boolean allowEmptySelection = true;
    public boolean rememberSelection = false;
    public boolean autoresizeColumn = false;

    public XJTable() {
        this.init();
    }

    public XJTable(DefaultTableModel model) {
        super(model);
        this.init();
    }

    public void init() {
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (!XJTable.this.ignoreSelectionEvent) {
                    XJTable.this.setSelectedRow(XJTable.this.getSelectedRow());
                    if (XJTable.this.delegate != null) {
                        XJTable.this.delegate.tableSelectionChanged(XJTable.this, XJTable.this.selectionRow);
                    }
                }
            }
        });
    }

    public void setDelegate(XJTableDelegate delegate) {
        this.delegate = delegate;
    }

    public void setAllowEmptySelection(boolean flag) {
        this.allowEmptySelection = flag;
    }

    public void setRememberSelection(boolean flag) {
        this.rememberSelection = flag;
    }

    public void setAutoresizeColumn(boolean flag) {
        this.autoresizeColumn = flag;
    }

    public void setSelectedRow(int row) {
        if (row == -1 && !this.allowEmptySelection) {
            row = 0;
        }
        this.selectionRow = Math.min(row, this.getRowCount() - 1);
        if (this.selectionRow >= 0) {
            this.setRowSelectionInterval(this.selectionRow, this.selectionRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        this.ignoreSelectionEvent = true;
        try {
            DefaultTableModel model = (DefaultTableModel)this.getModel();
            model.fireTableDataChanged();
            this.setSelectedRow(this.selectionRow);
        }
        finally {
            this.ignoreSelectionEvent = false;
        }
    }

    public Insets getAutoscrollInsets() {
        Rectangle outer = this.getBounds();
        Rectangle inner = this.getParent().getBounds();
        return new Insets(inner.y - outer.y + this.margin, inner.x - outer.x + this.margin, outer.height - inner.height + this.margin, outer.width - inner.width + this.margin);
    }

    public void autoscroll(Point point) {
        int row = this.rowAtPoint(point);
        Rectangle outer = this.getBounds();
        Rectangle r2 = this.getCellRect(point.y + outer.y <= this.margin ? row - 1 : row + 1, 0, true);
        this.scrollRectToVisible(r2);
    }

    public void selectLastRow() {
        this.setSelectedRow(this.getRowCount() - 1);
        this.scrollRectToVisible(this.getCellRect(this.getRowCount() - 1, 0, true));
    }
}

