/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJRotableToggleButton
extends JComponent {
    public static final int ROTATE_90 = 1;
    public static final int ROTATE_270 = 2;
    private static final int SEPARATOR = 3;
    private static final int MARGIN_WIDTH = 20;
    private static final int BUTTON_HEIGHT = 22;
    private static final int ARC = 4;
    private int computedWidth = 0;
    private int computedHeight = 0;
    private int rotation = 0;
    private ImageIcon icon;
    private String title;
    private boolean selected;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private Object payload;

    public XJRotableToggleButton(String title) {
        this(title, null);
    }

    public XJRotableToggleButton(String title, ImageIcon icon) {
        this.title = title;
        this.icon = icon;
        this.addMouseListener(new MouseListener(){
            private boolean pressed;
            private Boolean previousSelected;

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                if (this.pressed) {
                    XJRotableToggleButton.this.selected = !XJRotableToggleButton.this.selected;
                    XJRotableToggleButton.this.repaint();
                }
            }

            public void mouseExited(MouseEvent e) {
                if (this.pressed) {
                    XJRotableToggleButton.this.selected = !XJRotableToggleButton.this.selected;
                    XJRotableToggleButton.this.repaint();
                }
            }

            public void mousePressed(MouseEvent e) {
                if (this.previousSelected == null) {
                    this.previousSelected = XJRotableToggleButton.this.selected;
                }
                XJRotableToggleButton.this.selected = !XJRotableToggleButton.this.selected;
                this.pressed = true;
                XJRotableToggleButton.this.repaint();
            }

            public void mouseReleased(MouseEvent e) {
                this.pressed = false;
                if (XJRotableToggleButton.this.selected != this.previousSelected) {
                    XJRotableToggleButton.this.triggerAction();
                }
                this.previousSelected = null;
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
            }

            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    public Object getPayload() {
        return this.payload;
    }

    public void setPayload(Object payload) {
        this.payload = payload;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.computedHeight == 0 || this.computedWidth == 0) {
            this.computeSize((Graphics2D)this.getGraphics());
        }
        if (this.rotation == 0) {
            return new Dimension(this.computedWidth, this.computedHeight);
        }
        return new Dimension(this.computedHeight, this.computedWidth);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private void computeSize(Graphics2D g2d) {
        TextLayout tl = new TextLayout(this.title, g2d.getFont(), g2d.getFontRenderContext());
        Rectangle2D tb = tl.getBounds();
        this.computedWidth = 0;
        if (this.icon != null) {
            this.computedWidth += this.icon.getIconWidth();
            this.computedWidth += 3;
        }
        this.computedWidth = (int)((double)this.computedWidth + tb.getWidth());
        this.computedHeight = 22;
        this.computedWidth += 20;
    }

    @Override
    public void paint(Graphics g) {
        int voffset;
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform tr = g2d.getTransform();
        switch (this.rotation) {
            case 1: {
                tr.rotate(1.5707963267948966);
                tr.translate(0.0, -this.computedHeight);
                g2d.setTransform(tr);
                break;
            }
            case 2: {
                tr.rotate(-1.5707963267948966);
                tr.translate(-this.computedWidth, 0.0);
                g2d.setTransform(tr);
            }
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawAquaBackground(g2d);
        TextLayout layout = new TextLayout(this.title, g2d.getFont(), g2d.getFontRenderContext());
        Rectangle2D r = layout.getBounds();
        int offset = 20;
        if (this.icon != null) {
            voffset = (this.computedHeight - this.icon.getIconHeight()) / 2;
            g2d.drawImage(this.icon.getImage(), offset, voffset, null);
            offset += this.icon.getIconWidth();
            offset += 3;
        } else {
            offset = (int)(((double)this.computedWidth - r.getWidth()) / 2.0);
        }
        voffset = (int)(((double)this.computedHeight - r.getHeight()) / 2.0);
        g2d.setColor(Color.black);
        layout.draw(g2d, offset, (float)(this.computedHeight - voffset) - layout.getDescent() / 2.0f);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public List<ActionListener> getActionListeners() {
        return this.actionListeners;
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    public void removeAllActionListeners() {
        this.actionListeners.clear();
    }

    public void triggerAction() {
        for (ActionListener al : this.actionListeners) {
            al.actionPerformed(new ActionEvent(this, 0, null));
        }
    }

    private void drawStandardBackground(Graphics2D g2d) {
        if (this.selected) {
            g2d.setPaint(new GradientPaint(0.0f, -10.0f, Color.gray, 0.0f, this.computedHeight + 10, Color.white, false));
            g2d.fillRoundRect(1, 0, this.computedWidth - 2, this.computedHeight - 1, 4, 4);
        } else {
            g2d.setPaint(new GradientPaint(0.0f, -20.0f, Color.lightGray, 0.0f, this.computedHeight, Color.white, false));
            g2d.fillRoundRect(1, 0, this.computedWidth - 2, this.computedHeight - 1, 4, 4);
        }
        g2d.setColor(Color.black);
        g2d.drawRoundRect(1, 0, this.computedWidth - 2, this.computedHeight - 1, 4, 4);
    }

    private void drawAquaBackground(Graphics2D g2d) {
        Color bottomColor;
        Color middleDownColor;
        Color middleUpColor;
        Color topColor;
        Color snowColor = new Color(0.95f, 0.95f, 0.95f);
        if (this.selected) {
            topColor = new Color(0.7f, 0.9f, 1.0f);
            middleUpColor = new Color(0.5f, 0.7f, 1.0f);
            middleDownColor = new Color(0.1f, 0.6f, 0.9f);
            bottomColor = new Color(0.8f, 0.9f, 1.0f);
        } else {
            topColor = new Color(0.99f, 0.99f, 0.99f);
            middleUpColor = new Color(0.9f, 0.9f, 0.9f);
            middleDownColor = new Color(0.85f, 0.85f, 0.85f);
            bottomColor = new Color(0.99f, 0.99f, 0.99f);
        }
        int x = 1;
        int y = 1;
        int width = this.computedWidth - 2;
        int height = this.computedHeight - 2;
        GradientPaint gradient = new GradientPaint(x, y, topColor, x, y + height / 2, middleUpColor);
        g2d.setPaint(gradient);
        g2d.fillRect(x, y, width, height / 2);
        g2d.setColor(snowColor);
        g2d.drawLine(x, y + 1, x + width, y + 1);
        gradient = new GradientPaint(x, y + height / 2, middleDownColor, x, y + height, bottomColor);
        g2d.setPaint(gradient);
        g2d.fillRect(x, y + height / 2, width, height / 2);
        if (this.selected) {
            g2d.setColor(Color.darkGray);
        } else {
            g2d.setColor(Color.gray);
        }
        g2d.drawRoundRect(x, y, width, height, 4, 4);
    }
}

