/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;

public class XJRollOverButtonToggle
extends JToggleButton {
    private boolean inside = false;

    public static XJRollOverButtonToggle createSmallButton(ImageIcon icon) {
        XJRollOverButtonToggle b = new XJRollOverButtonToggle(icon);
        XJRollOverButtonToggle.adjustSize(b, 16, 16);
        return b;
    }

    public static XJRollOverButtonToggle createMediumButton(ImageIcon icon) {
        XJRollOverButtonToggle b = new XJRollOverButtonToggle(icon);
        XJRollOverButtonToggle.adjustSize(b, 24, 24);
        return b;
    }

    private static void adjustSize(AbstractButton button, int width, int height) {
        Dimension d = new Dimension(width, height);
        button.setMinimumSize(d);
        button.setMaximumSize(d);
        button.setPreferredSize(d);
    }

    protected XJRollOverButtonToggle(ImageIcon icon) {
        super(icon);
        this.setBorderPainted(false);
        this.setFocusable(false);
        this.setIconTextGap(0);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setContentAreaFilled(false);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                XJRollOverButtonToggle.this.inside = true;
                XJRollOverButtonToggle.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
                XJRollOverButtonToggle.this.inside = false;
                XJRollOverButtonToggle.this.repaint();
            }
        });
    }

    protected void paintComponent(Graphics g) {
        if (this.isEnabled()) {
            if (this.inside) {
                g.setColor(Color.lightGray);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(Color.darkGray);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            } else if (this.isSelected()) {
                g.setColor(Color.lightGray);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(Color.darkGray);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
        super.paintComponent(g);
    }
}

