/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class CustomSplitPanel
extends JPanel {
    public static final int LEFT_INDEX = 0;
    public static final int MIDDLE_INDEX = 1;
    public static final int RIGHT_INDEX = 2;
    public JSplitPane leftSplitPane;
    public JSplitPane rightSplitPane;
    public Component left;
    public Component middle;
    public Component right;
    public final Map<Component, Float> widths = new HashMap<Component, Float>();

    public CustomSplitPanel() {
        super(new BorderLayout());
        this.leftSplitPane = this.createSplitPane();
        this.rightSplitPane = this.createSplitPane();
    }

    public void close() {
        this.left = null;
        this.middle = null;
        this.right = null;
        this.widths.clear();
    }

    public JSplitPane createSplitPane() {
        JSplitPane pane = new JSplitPane();
        pane.setBorder(null);
        pane.setOrientation(1);
        pane.setContinuousLayout(true);
        pane.setOneTouchExpandable(true);
        pane.setResizeWeight(0.5);
        return pane;
    }

    public void setComponents(Component leftComponent, Component middleComponent, Component rightComponent) {
        this.left = leftComponent;
        this.leftSplitPane.setLeftComponent(this.left);
        this.middle = middleComponent;
        this.leftSplitPane.setRightComponent(this.middle);
        this.rightSplitPane.setLeftComponent(this.leftSplitPane);
        this.right = rightComponent;
        this.rightSplitPane.setRightComponent(this.right);
        this.add((Component)this.rightSplitPane, "Center");
        this.resize();
    }

    public void setComponentWidth(Component c, float width) {
        this.widths.put(c, Float.valueOf(width));
    }

    public void resize() {
        if (this.left != null && this.middle != null && this.right != null) {
            this.setDividerLocationToComponentWidth(this.rightSplitPane, this.getWidth(this.left) + this.getWidth(this.middle));
            this.setDividerLocationToComponentWidth(this.leftSplitPane, this.getWidth(this.left));
        } else if (this.left != null && this.middle != null) {
            this.setDividerLocationToComponentWidth(this.rightSplitPane, this.getWidth(this.left));
        } else if (this.left != null && this.right != null) {
            this.setDividerLocationToComponentWidth(this.rightSplitPane, this.getWidth(this.left));
        } else if (this.middle != null && this.right != null) {
            this.setDividerLocationToComponentWidth(this.rightSplitPane, this.getWidth(this.middle));
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (CustomSplitPanel.this.left != null && CustomSplitPanel.this.middle != null && CustomSplitPanel.this.right != null) {
                    CustomSplitPanel.this.setDividerLocationToComponentWidth(CustomSplitPanel.this.rightSplitPane, CustomSplitPanel.this.getWidth(CustomSplitPanel.this.left) + CustomSplitPanel.this.getWidth(CustomSplitPanel.this.middle));
                    CustomSplitPanel.this.setDividerLocationToComponentWidth(CustomSplitPanel.this.leftSplitPane, CustomSplitPanel.this.getWidth(CustomSplitPanel.this.left));
                } else if (CustomSplitPanel.this.left != null && CustomSplitPanel.this.middle != null) {
                    CustomSplitPanel.this.setDividerLocationToComponentWidth(CustomSplitPanel.this.rightSplitPane, CustomSplitPanel.this.getWidth(CustomSplitPanel.this.left));
                } else if (CustomSplitPanel.this.left != null && CustomSplitPanel.this.right != null) {
                    CustomSplitPanel.this.setDividerLocationToComponentWidth(CustomSplitPanel.this.rightSplitPane, CustomSplitPanel.this.getWidth(CustomSplitPanel.this.left));
                } else if (CustomSplitPanel.this.middle != null && CustomSplitPanel.this.right != null) {
                    CustomSplitPanel.this.setDividerLocationToComponentWidth(CustomSplitPanel.this.rightSplitPane, CustomSplitPanel.this.getWidth(CustomSplitPanel.this.middle));
                }
            }
        });
    }

    public void setDividerLocationToComponentWidth(JSplitPane splitPane, int width) {
        splitPane.setDividerLocation(width);
    }

    public int getWidth(Component c) {
        Float width = this.widths.get(c);
        if (width != null) {
            return (int)width.floatValue();
        }
        return 0;
    }

    public void setComponent(Component c, int index) {
        switch (index) {
            case 0: {
                this.setLeftComponent(c);
                break;
            }
            case 1: {
                this.setMiddleComponent(c);
                break;
            }
            case 2: {
                this.setRightComponent(c);
            }
        }
    }

    public Component getComponentAtIndex(int index) {
        switch (index) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.middle;
            }
            case 2: {
                return this.right;
            }
        }
        return null;
    }

    public void setLeftComponent(Component c) {
        if (c == null) {
            this.removeLeftComponent();
            return;
        }
        if (this.middle != null && this.right != null) {
            this.rightSplitPane.setLeftComponent(null);
            this.leftSplitPane.setLeftComponent(c);
            this.leftSplitPane.setRightComponent(this.middle);
            this.rightSplitPane.setLeftComponent(this.leftSplitPane);
        } else if (this.middle != null) {
            this.remove(this.middle);
            this.rightSplitPane.setLeftComponent(c);
            this.rightSplitPane.setRightComponent(this.middle);
            this.add(this.rightSplitPane);
        } else if (this.right != null) {
            this.remove(this.right);
            this.rightSplitPane.setLeftComponent(c);
            this.rightSplitPane.setRightComponent(this.right);
            this.add(this.rightSplitPane);
        } else if (this.left == null) {
            this.add(c);
        }
        this.left = c;
        this.resize();
    }

    public void removeLeftComponent() {
        if (this.middle != null && this.right != null) {
            this.leftSplitPane.setLeftComponent(null);
            this.leftSplitPane.setRightComponent(null);
            this.rightSplitPane.setLeftComponent(this.middle);
        } else if (this.middle != null) {
            this.rightSplitPane.setLeftComponent(null);
            this.rightSplitPane.setRightComponent(null);
            this.remove(this.rightSplitPane);
            this.add(this.middle);
        } else if (this.right != null) {
            this.rightSplitPane.setLeftComponent(null);
            this.rightSplitPane.setRightComponent(null);
            this.remove(this.rightSplitPane);
            this.add(this.right);
        }
        this.left = null;
        this.resize();
    }

    public void setMiddleComponent(Component c) {
        if (c == null) {
            this.removeMiddleComponent();
            return;
        }
        if (this.left != null && this.right != null) {
            this.rightSplitPane.setLeftComponent(this.leftSplitPane);
            this.leftSplitPane.setLeftComponent(this.left);
            this.leftSplitPane.setRightComponent(c);
        } else if (this.left != null) {
            this.remove(this.left);
            this.rightSplitPane.setLeftComponent(this.left);
            this.rightSplitPane.setRightComponent(c);
            this.add(this.rightSplitPane);
        } else if (this.right != null) {
            this.remove(this.right);
            this.rightSplitPane.setLeftComponent(c);
            this.rightSplitPane.setRightComponent(this.right);
            this.add(this.rightSplitPane);
        } else if (this.middle == null) {
            this.add(c);
        }
        this.middle = c;
        this.resize();
    }

    public void removeMiddleComponent() {
        if (this.left != null && this.right != null) {
            this.leftSplitPane.setLeftComponent(null);
            this.leftSplitPane.setRightComponent(null);
            this.rightSplitPane.setLeftComponent(this.left);
        } else if (this.left != null) {
            this.rightSplitPane.setLeftComponent(null);
            this.rightSplitPane.setRightComponent(null);
            this.remove(this.rightSplitPane);
            this.add(this.left);
        } else if (this.right != null) {
            this.rightSplitPane.setLeftComponent(null);
            this.rightSplitPane.setRightComponent(null);
            this.remove(this.rightSplitPane);
            this.add(this.right);
        }
        this.middle = null;
        this.resize();
    }

    public void setRightComponent(Component c) {
        if (c == null) {
            this.removeRightComponent();
            return;
        }
        if (this.left != null && this.middle != null) {
            this.rightSplitPane.setLeftComponent(null);
            this.rightSplitPane.setRightComponent(null);
            this.leftSplitPane.setLeftComponent(this.left);
            this.leftSplitPane.setRightComponent(this.middle);
            this.rightSplitPane.setLeftComponent(this.leftSplitPane);
            this.rightSplitPane.setRightComponent(c);
        } else if (this.left != null) {
            this.remove(this.left);
            this.rightSplitPane.setLeftComponent(this.left);
            this.rightSplitPane.setRightComponent(c);
            this.add(this.rightSplitPane);
        } else if (this.middle != null) {
            this.remove(this.middle);
            this.rightSplitPane.setLeftComponent(this.middle);
            this.rightSplitPane.setRightComponent(c);
            this.add(this.rightSplitPane);
        } else if (this.right == null) {
            this.add(c);
        }
        this.right = c;
        this.resize();
    }

    public void removeRightComponent() {
        if (this.left != null && this.middle != null) {
            this.leftSplitPane.setLeftComponent(null);
            this.leftSplitPane.setRightComponent(null);
            this.rightSplitPane.setLeftComponent(this.left);
            this.rightSplitPane.setRightComponent(this.middle);
        } else if (this.left != null) {
            this.rightSplitPane.setLeftComponent(null);
            this.rightSplitPane.setRightComponent(null);
            this.remove(this.rightSplitPane);
            this.add(this.left);
        } else if (this.middle != null) {
            this.rightSplitPane.setLeftComponent(null);
            this.rightSplitPane.setRightComponent(null);
            this.remove(this.rightSplitPane);
            this.add(this.middle);
        }
        this.right = null;
        this.resize();
    }
}

