/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.stringtemplate;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stringtemplate.STWindow;
import org.antlr.works.utils.IconManager;
import org.antlr.works.utils.Toolbar;
import org.antlr.xjlib.appkit.swing.XJRollOverButton;
import org.antlr.xjlib.appkit.swing.XJRollOverButtonToggle;

public class STWindowToolbar {
    public Toolbar toolbar;
    public JButton backward;
    public JButton forward;
    public JToggleButton sort;
    public JButton find;
    public STWindow window;

    public STWindowToolbar(STWindow window) {
        this.window = window;
        this.createInterface();
        this.addActions();
    }

    public void close() {
        this.window = null;
        AWPrefs.getPreferences().unbindFromPreferences(this.sort, "PREF_TOOLBAR_ST_SORT");
    }

    public JComponent getToolbar() {
        return this.toolbar;
    }

    public void createInterface() {
        this.toolbar = Toolbar.createHorizontalToolbar();
        this.sort = this.createToggleButton(IconManager.shared().getIconSort(), "Toggle Sort rules");
        this.toolbar.addElement(this.sort);
        this.find = this.createButton(IconManager.shared().getIconFind(), "Find text");
        this.toolbar.addElement(this.find);
        this.toolbar.addGroupSeparator();
        this.backward = this.createButton(IconManager.shared().getIconBackward(), "Back");
        this.toolbar.addElement(this.backward);
        this.forward = this.createButton(IconManager.shared().getIconForward(), "Forward");
        this.toolbar.addElement(this.forward);
        AWPrefs.getPreferences().bindToPreferences(this.sort, "PREF_TOOLBAR_ST_SORT", false);
    }

    public void updateStates() {
        this.sort.setSelected(this.window.isRulesSorted());
    }

    public STWindow getSelectedEditor() {
        return this.window;
    }

    public void addActions() {
        this.backward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                STWindowToolbar.this.getSelectedEditor().goToBackward();
            }
        });
        this.forward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                STWindowToolbar.this.getSelectedEditor().goToForward();
            }
        });
        this.sort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                STWindowToolbar.this.getSelectedEditor().toggleRulesSorting();
            }
        });
        this.find.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                STWindowToolbar.this.getSelectedEditor().find();
            }
        });
    }

    public JButton createButton(ImageIcon icon, String tooltip) {
        XJRollOverButton b = XJRollOverButton.createMediumButton(icon);
        b.setToolTipText(tooltip);
        return b;
    }

    public JToggleButton createToggleButton(ImageIcon icon, String tooltip) {
        XJRollOverButtonToggle b = XJRollOverButtonToggle.createMediumButton(icon);
        b.setToolTipText(tooltip);
        return b;
    }
}

