/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.antlr.works.components.GrammarWindow;
import org.antlr.works.editor.GrammarWindowTab;
import org.antlr.works.utils.Console;
import org.antlr.works.utils.ConsoleHelper;
import org.antlr.works.utils.Toolbar;
import org.antlr.xjlib.foundation.XJUtils;

public class ConsoleTab
extends GrammarWindowTab
implements Console {
    protected JPanel panel;
    protected JTextArea textArea;
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
    protected Map<Thread, Integer> modeByThread = new HashMap<Thread, Integer>();

    public ConsoleTab(GrammarWindow window) {
        super(window);
        this.panel = new JPanel(new BorderLayout());
        Toolbar box = Toolbar.createHorizontalToolbar();
        JButton clear = new JButton("Clear All");
        clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConsoleTab.this.clear();
            }
        });
        box.addElement(clear);
        box.add(Box.createHorizontalGlue());
        this.panel.add((Component)this.createTextArea(), "Center");
        this.panel.add((Component)box, "South");
    }

    public void setMode(int mode) {
        this.modeByThread.put(Thread.currentThread(), mode);
    }

    public void close() {
        if (ConsoleHelper.getCurrent() == this) {
            ConsoleHelper.setCurrent(null);
        }
    }

    public int getMode() {
        Integer mode = this.modeByThread.get(Thread.currentThread());
        if (mode == null) {
            return 1;
        }
        return mode;
    }

    public void makeCurrent() {
        ConsoleHelper.setCurrent(this);
    }

    public Container getContainer() {
        return this.panel;
    }

    public Container createTextArea() {
        this.textArea = new JTextArea();
        JScrollPane textAreaScrollPane = new JScrollPane(this.textArea);
        textAreaScrollPane.setWheelScrollingEnabled(true);
        return textAreaScrollPane;
    }

    public void clear() {
        this.textArea.setText("");
        this.window.clearConsoleStatus();
    }

    public synchronized void println(String s) {
        this.println(s, 0);
    }

    public synchronized void println(String s, int level) {
        this.print(s + "\n", level);
    }

    public synchronized void println(Throwable e) {
        this.println(XJUtils.stackTrace(e), 2);
    }

    public synchronized void print(final String s, final int level) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConsoleTab.this.print(s, level);
                }
            });
            return;
        }
        String t = "[" + this.dateFormat.format(new Date()) + "] " + s;
        this.textArea.setText(this.textArea.getText() + t);
        this.textArea.setCaretPosition(this.textArea.getText().length());
        System.out.println(s);
        if (this.getMode() == 1) {
            this.window.consolePrint(s, level);
        }
    }

    public synchronized void print(Throwable e) {
        this.print(XJUtils.stackTrace(e), 2);
    }

    public String getTabName() {
        return "Console";
    }

    public Component getTabComponent() {
        return this.getContainer();
    }
}

