/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.tivo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.swing.SwingUtilities;
import org.antlr.runtime.Token;
import org.antlr.runtime.debug.DebugEventListener;
import org.antlr.runtime.debug.RemoteDebugEventSocketListener;
import org.antlr.works.debugger.DebuggerTab;
import org.antlr.works.debugger.events.DBEvent;
import org.antlr.works.debugger.events.DBEventConsumeHiddenToken;
import org.antlr.works.debugger.events.DBEventConsumeToken;
import org.antlr.works.debugger.events.DBEventEnterRule;
import org.antlr.works.debugger.events.DBEventExitRule;
import org.antlr.works.debugger.events.DBEventLocation;
import org.antlr.works.debugger.tivo.DBRecorderEventListener;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.NumberSet;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJDialogProgress;
import org.antlr.xjlib.appkit.utils.XJDialogProgressDelegate;
import org.antlr.xjlib.foundation.XJUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBRecorder
implements Runnable,
XJDialogProgressDelegate {
    public static final int STATUS_STOPPED = 0;
    public static final int STATUS_STOPPING = 1;
    public static final int STATUS_LAUNCHING = 2;
    public static final int STATUS_RUNNING = 3;
    public static final int STATUS_BREAK = 4;
    public static final int MAX_RETRY = 12;
    protected DebuggerTab debuggerTab;
    protected int status = 0;
    protected boolean cancelled;
    protected String address;
    protected int port;
    protected List<DBEvent> events;
    protected int position;
    protected NumberSet breakEvents = new NumberSet();
    protected int stoppedOnEvent = -1;
    protected boolean ignoreBreakpoints = false;
    protected StepOver stepOver = new StepOver();
    protected int lastTokenIndexEventNumber;
    protected int currentTokenIndexEventNumber;
    protected int currentTokenIndex;
    protected DBRecorderEventListener eventListener;
    protected RemoteDebugEventSocketListener listener;
    protected XJDialogProgress progress;
    protected boolean debuggerReceivedTerminateEvent;
    protected boolean remoteParserStateWarned = false;
    protected Stack<String> grammarNamesStack = new Stack();

    public DBRecorder(DebuggerTab debuggerTab) {
        this.debuggerTab = debuggerTab;
        this.reset();
    }

    public void close() {
        this.debuggerTab = null;
    }

    public void showProgress() {
        if (this.progress == null) {
            this.progress = new XJDialogProgress(this.debuggerTab.getContainer());
        }
        this.progress.setInfo("Connecting...");
        this.progress.setIndeterminate(true);
        this.progress.setDelegate(this);
        this.progress.display();
    }

    public void hideProgress() {
        this.progress.close();
    }

    public synchronized boolean isRunning() {
        return this.status == 3;
    }

    public synchronized boolean isAlive() {
        return this.status == 3 || this.status == 4;
    }

    public synchronized void reset() {
        this.events = Collections.synchronizedList(new ArrayList());
        this.position = -1;
        this.currentTokenIndex = -1;
        this.remoteParserStateWarned = false;
    }

    public synchronized DBEvent getEvent() {
        if (this.position < 0 || this.position >= this.events.size()) {
            return null;
        }
        return this.events.get(this.position);
    }

    public synchronized DBEvent getLastEvent() {
        return this.events.get(this.events.size() - 1);
    }

    public synchronized List<DBEvent> getCurrentEvents() {
        if (this.events.size() == 0) {
            return this.events;
        }
        int toIndex = this.position + 1;
        if (toIndex >= this.events.size()) {
            toIndex = this.events.size();
        }
        return this.events.subList(0, toIndex);
    }

    public synchronized int getCurrentEventPosition() {
        if (this.events.size() == 0) {
            return 0;
        }
        int toIndex = this.position + 1;
        if (toIndex >= this.events.size()) {
            toIndex = this.events.size();
        }
        return toIndex;
    }

    public void setPositionToEnd() {
        this.position = this.events.size() - 1;
    }

    public void setBreakEvents(Set events) {
        this.breakEvents.replaceAll(events);
    }

    public Set getBreakEvents() {
        return this.breakEvents;
    }

    public void setStoppedOnEvent(int event) {
        this.stoppedOnEvent = event;
    }

    public int getStoppedOnEvent() {
        return this.stoppedOnEvent;
    }

    public void setIgnoreBreakpoints(boolean flag) {
        this.ignoreBreakpoints = flag;
    }

    public boolean ignoreBreakpoints() {
        return this.ignoreBreakpoints;
    }

    public void queryGrammarBreakpoints() {
        this.debuggerTab.queryGrammarBreakpoints();
    }

    public boolean isOnBreakEvent() {
        int breakEvent = this.getOnBreakEvent();
        if (breakEvent != -1) {
            this.setStoppedOnEvent(breakEvent);
            this.setStatus(4);
            return true;
        }
        return false;
    }

    public int getOnBreakEvent() {
        DBEvent event = this.getEvent();
        if (event == null) {
            return -1;
        }
        if (this.stepOver.isSteppingOver()) {
            if (this.stepOver.shouldStop(event)) {
                this.stepOver.endStepOver();
                return event.getEventType();
            }
            return -1;
        }
        if (event.getEventType() == 2) {
            return event.getEventType();
        }
        if (this.breakEvents.contains(DBEvent.convertToInteger(0))) {
            return event.getEventType();
        }
        if (event.getEventType() == 4 && !this.ignoreBreakpoints() && this.debuggerTab.isBreakpointAtLine(((DBEventLocation)event).line - 1, event.getGrammarName())) {
            return event.getEventType();
        }
        if (event.getEventType() == 5 && !this.ignoreBreakpoints() && this.debuggerTab.isBreakpointAtToken(((DBEventConsumeToken)event).token)) {
            return event.getEventType();
        }
        if (event.getEventType() == 5 && this.breakEvents.contains(DBEvent.convertToInteger(5))) {
            return ((DBEventConsumeToken)event).token.getChannel() == 0 ? event.getEventType() : -1;
        }
        return this.breakEvents.contains(DBEvent.convertToInteger(event.getEventType())) ? event.getEventType() : -1;
    }

    public synchronized void setStatus(int status) {
        if (this.status != status) {
            this.status = status;
            this.debuggerTab.recorderStatusDidChange();
        }
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public boolean isAtBeginning() {
        return this.position == 0;
    }

    public boolean isAtEnd() {
        DBEvent e = this.getEvent();
        if (e == null) {
            return true;
        }
        return e.getEventType() == 3;
    }

    public void stepBackward(Set breakEvents) {
        this.setIgnoreBreakpoints(false);
        this.stepContinue(breakEvents);
        this.stepMove(-1);
        this.playEvents(true);
    }

    public synchronized void stepForward(Set breakEvents) {
        this.setIgnoreBreakpoints(false);
        this.stepContinue(breakEvents);
        if (this.stepMove(1)) {
            this.playEvents(false);
        } else if (this.debuggerReceivedTerminateEvent) {
            this.playEvents(false);
        } else {
            this.threadNotify();
        }
    }

    public void stepOver() {
        this.stepOver.beginStepOver();
        this.fastForward();
    }

    public void stepContinue(Set breakEvents) {
        this.setBreakEvents(breakEvents);
        this.queryGrammarBreakpoints();
        this.setStatus(3);
    }

    public synchronized boolean stepMove(int direction) {
        DBEvent event;
        this.position += direction;
        if (this.position < 0) {
            this.position = 0;
            return false;
        }
        if (this.position >= this.events.size()) {
            this.position = this.events.size() - 1;
            return false;
        }
        while ((event = this.getEvent()) != null && !this.isOnBreakEvent()) {
            this.position += direction;
        }
        if (event == null) {
            this.position -= direction;
        }
        return event != null;
    }

    public void goToStart() {
        this.position = 0;
        this.setIgnoreBreakpoints(false);
        this.playEvents(true);
    }

    public void goToEnd() {
        this.setIgnoreBreakpoints(true);
        this.stepContinue(new NumberSet(3));
        if (this.stepMove(1)) {
            this.playEvents(false);
        } else {
            this.threadNotify();
        }
    }

    public void fastForward() {
        this.stepForward(new NumberSet(3));
    }

    public void connect(String address, int port) {
        this.address = address;
        this.port = port;
        new Thread(this).start();
    }

    @Override
    public void run() {
        this.eventListener = new DBRecorderEventListener(this);
        this.cancelled = false;
        boolean connected = false;
        boolean showProgress = false;
        long t = System.currentTimeMillis();
        long timeout = AWPrefs.getDebugLaunchTimeout() * 1000;
        while (System.currentTimeMillis() - t < timeout && !this.cancelled) {
            this.listener = null;
            try {
                this.listener = new FixBugRemoteDebugEventSocketListener(this.eventListener, this.address, this.port);
            }
            catch (IOException e) {
                this.listener = null;
            }
            if (this.listener != null) {
                connected = true;
                break;
            }
            if (System.currentTimeMillis() - t >= 2L && !showProgress) {
                this.showProgress();
                showProgress = true;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        if (showProgress) {
            this.hideProgress();
        }
        if (this.cancelled) {
            this.setStatus(0);
            this.connectionCancelled();
        } else if (!connected) {
            this.setStatus(0);
            this.connectionFailed();
        } else {
            this.setStatus(2);
            this.debuggerReceivedTerminateEvent = false;
            this.reset();
            this.listener.start();
            this.connectionSuccess();
        }
    }

    public void connectionSuccess() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DBRecorder.this.debuggerTab.connectionSuccess();
            }
        });
    }

    public void connectionFailed() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DBRecorder.this.debuggerTab.connectionFailed();
            }
        });
    }

    public void connectionCancelled() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DBRecorder.this.debuggerTab.connectionCancelled();
            }
        });
    }

    public synchronized void requestStop() {
        this.setStatus(1);
        this.threadNotify();
        if (this.debuggerReceivedTerminateEvent) {
            this.stop();
        }
    }

    public void stop() {
        if (this.debuggerTab == null) {
            return;
        }
        this.setStatus(0);
        this.debuggerTab.recorderDidStop();
    }

    public void checkRemoteParserHeaders() {
        String remoteParserGrammarFileName;
        String grammarFileName = this.debuggerTab.getDelegate().getGrammarEngine().getGrammarFileName();
        if (!grammarFileName.equals(remoteParserGrammarFileName = XJUtils.getLastPathComponent(this.listener.grammarFileName))) {
            String message = "Warning: the grammar used by the remote parser is not the same (" + remoteParserGrammarFileName + ").";
            XJAlert.display(this.debuggerTab.getContainer(), "Grammar Mismatch", message);
        }
    }

    public boolean checkRemoteParserState() {
        if (this.remoteParserStateWarned) {
            return false;
        }
        if (this.listener.tokenIndexesAreInvalid()) {
            this.remoteParserStateWarned = true;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String message = "Invalid token indexes (current index is " + DBRecorder.this.currentTokenIndex + " at event " + DBRecorder.this.currentTokenIndexEventNumber + " while the same index was used at event " + DBRecorder.this.lastTokenIndexEventNumber + "). Make sure that the remote parser implements the getTokenIndex() method of Token. The indexes must be unique for each consumed token.";
                    XJAlert.display(DBRecorder.this.debuggerTab.getContainer(), "Invalid Token Indexes", message);
                }
            });
            return true;
        }
        return false;
    }

    public void recordIndexes(DBEvent event) {
        DBEvent e;
        Token t = null;
        if (event instanceof DBEventConsumeToken) {
            e = (DBEventConsumeToken)event;
            t = e.token;
        }
        if (event instanceof DBEventConsumeHiddenToken) {
            e = (DBEventConsumeHiddenToken)event;
            t = ((DBEventConsumeHiddenToken)e).token;
        }
        if (t != null) {
            this.lastTokenIndexEventNumber = this.currentTokenIndexEventNumber;
            this.currentTokenIndexEventNumber = this.events.size() - 1;
            this.currentTokenIndex = t.getTokenIndex();
        }
    }

    public void handleGrammarName(DBEvent event) {
        if (event instanceof DBEventEnterRule) {
            this.grammarNamesStack.push(event.getGrammarName());
        }
        if (event instanceof DBEventExitRule) {
            this.grammarNamesStack.pop();
        }
        if (this.grammarNamesStack.isEmpty()) {
            event.setGrammarName(null);
        } else {
            event.setGrammarName(this.grammarNamesStack.peek());
        }
    }

    public synchronized void listenerEvent(DBEvent event) {
        this.events.add(event);
        this.handleGrammarName(event);
        this.recordIndexes(event);
        this.setPositionToEnd();
        switch (this.getStatus()) {
            case 2: {
                this.setStatus(3);
                break;
            }
            case 1: {
                if (event.getEventType() != 3 && !this.debuggerReceivedTerminateEvent) break;
                this.stop();
            }
        }
        if (this.isRunning()) {
            switch (event.getEventType()) {
                case 3: {
                    this.setStoppedOnEvent(3);
                    this.breaksOnEvent(false);
                    this.debuggerReceivedTerminateEvent = true;
                    break;
                }
                case 2: {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DBRecorder.this.checkRemoteParserHeaders();
                        }
                    });
                    this.setStoppedOnEvent(2);
                    this.breaksOnEvent(true);
                    break;
                }
                default: {
                    if (!this.checkRemoteParserState() && !this.isOnBreakEvent()) break;
                    this.breaksOnEvent(true);
                }
            }
        }
    }

    public synchronized void threadNotify() {
        this.notify();
    }

    public synchronized void threadWait() {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            this.debuggerTab.getConsole().println("recorderThreadBreaksOnEvent: interrupted", 1);
        }
    }

    public synchronized void breaksOnEvent(boolean wait) {
        this.setStatus(4);
        this.playEvents(false);
        if (wait) {
            this.threadWait();
        }
    }

    protected synchronized void playEvents(boolean reset) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new PlayEventRunnable(reset));
        } else {
            this.debuggerTab.playEvents(this.events, this.getCurrentEventPosition(), reset);
        }
    }

    @Override
    public void dialogDidCancel() {
        this.cancelled = true;
    }

    public class PlayEventRunnable
    implements Runnable {
        public boolean reset;

        public PlayEventRunnable(boolean reset) {
            this.reset = reset;
        }

        public void run() {
            DBRecorder.this.playEvents(this.reset);
        }
    }

    public class StepOver {
        public static final int MODE_DISABLED = 0;
        public static final int MODE_WAIT_ENTER_RULE = 1;
        public static final int MODE_WAIT_EXIT_RULE = 2;
        public static final int MODE_WAIT_LOCATION = 3;
        public int mode = 0;
        public int nested;
        public String ruleName;

        public void beginStepOver() {
            this.mode = 1;
        }

        public void endStepOver() {
            this.mode = 0;
        }

        public boolean isSteppingOver() {
            return this.mode != 0;
        }

        public boolean shouldStop(DBEvent event) {
            switch (this.mode) {
                case 1: {
                    if (!(event instanceof DBEventEnterRule)) break;
                    DBEventEnterRule e = (DBEventEnterRule)event;
                    this.ruleName = e.name;
                    this.mode = 2;
                    this.nested = 0;
                    break;
                }
                case 2: {
                    if (event instanceof DBEventEnterRule) {
                        DBEventEnterRule e = (DBEventEnterRule)event;
                        if (!e.name.equals(this.ruleName)) break;
                        ++this.nested;
                        break;
                    }
                    if (!(event instanceof DBEventExitRule)) break;
                    DBEventExitRule e = (DBEventExitRule)event;
                    if (!e.name.equals(this.ruleName)) break;
                    if (this.nested == 0) {
                        this.mode = 3;
                        break;
                    }
                    --this.nested;
                    break;
                }
                case 3: {
                    if (!(event instanceof DBEventLocation)) break;
                    return true;
                }
            }
            return false;
        }
    }

    public static class FixBugRemoteDebugEventSocketListener
    extends RemoteDebugEventSocketListener {
        public FixBugRemoteDebugEventSocketListener(DebugEventListener listener, String machine, int port) throws IOException {
            super(listener, machine, port);
        }

        protected void dispatch(String line) {
            String[] elements = this.getEventElements(line);
            if (elements == null || elements[0] == null) {
                return;
            }
            if (elements[0].equals("enterDecision")) {
                line = line + "\tfalse";
            }
            super.dispatch(line);
        }
    }
}

