/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.undo;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.antlr.xjlib.appkit.undo.XJRedoAction;

public class XJUndoAction
extends AbstractAction {
    protected UndoManager undoManager;
    protected XJRedoAction redoAction;

    public XJUndoAction(UndoManager manager) {
        super("Undo");
        this.setEnabled(false);
        this.undoManager = manager;
    }

    public void setRedoAction(XJRedoAction action) {
        this.redoAction = action;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (this.undoManager.canUndo()) {
                this.undoManager.undo();
            }
        }
        catch (CannotUndoException ex) {
            ex.printStackTrace();
        }
        this.updateUndoState();
        this.redoAction.updateRedoState();
    }

    protected void updateUndoState() {
        if (this.undoManager.canUndo()) {
            this.setEnabled(true);
            this.putValue("Name", this.undoManager.getUndoPresentationName());
        } else {
            this.setEnabled(false);
            this.putValue("Name", "Undo");
        }
    }
}

