/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.antlr.xjlib.appkit.swing.XJTreeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJTree
extends JTree
implements DragGestureListener,
DropTargetListener,
DragSourceListener,
Autoscroll {
    protected XJTreeDelegate delegate;
    protected DragSource dragSource;
    protected DropTarget dt;
    protected TreePath oldSelectedPath;
    protected Timer autoExpandTimer;
    protected TreePath lastPath;
    protected Point lastPoint = new Point();
    protected Rectangle cueLine = new Rectangle();
    protected BufferedImage dragImage;
    protected Point dragImageOffset = new Point();
    protected final int AUTOSCROLL_MARGIN = 12;
    protected int dropLocation;
    public static final int DROP_ABOVE = 0;
    public static final int DROP_ONTO = 1;
    public static final int DROP_BELOW = 2;

    public XJTree() {
        this.autoExpandTimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (XJTree.this.isRootVisible() && XJTree.this.getRowForPath(XJTree.this.lastPath) == 0) {
                    return;
                }
                if (XJTree.this.isExpanded(XJTree.this.lastPath)) {
                    XJTree.this.collapsePath(XJTree.this.lastPath);
                } else {
                    XJTree.this.expandPath(XJTree.this.lastPath);
                }
            }
        });
        this.autoExpandTimer.setRepeats(false);
    }

    public void close() {
        this.autoExpandTimer.stop();
        this.autoExpandTimer = null;
        this.dragSource = null;
        this.dt = null;
    }

    public void setDelegate(XJTreeDelegate delegate) {
        this.delegate = delegate;
    }

    public void setEnableDragAndDrop() {
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, this.getDelegateConstants(), this);
        this.dt = new DropTarget(this, this);
    }

    public int getDelegateConstants() {
        return this.delegate.xjTreeDragAndDropConstants(this);
    }

    public DefaultMutableTreeNode getOldSelectedNode() {
        return (DefaultMutableTreeNode)this.oldSelectedPath.getLastPathComponent();
    }

    public DefaultMutableTreeNode getSelectedNode() {
        if (this.getSelectionPath() == null) {
            return null;
        }
        return (DefaultMutableTreeNode)this.getSelectionPath().getLastPathComponent();
    }

    public List<Object> getSelectedNodes() {
        ArrayList<Object> nodes = new ArrayList<Object>();
        if (this.getSelectionPaths() != null) {
            for (int i = 0; i < this.getSelectionPaths().length; ++i) {
                TreePath treePath = this.getSelectionPaths()[i];
                nodes.add(treePath.getLastPathComponent());
            }
        }
        return nodes;
    }

    public void modifySelectionIfNecessary(MouseEvent me) {
        boolean partOfSelection = false;
        int row = this.getRowForLocation(me.getX(), me.getY());
        if (this.getSelectionRows() != null) {
            for (int i = 0; i < this.getSelectionRows().length; ++i) {
                int selRow = this.getSelectionRows()[i];
                if (selRow != row) continue;
                partOfSelection = true;
            }
        }
        if (!partOfSelection) {
            this.setSelectionRow(row);
        }
    }

    protected void cleanUpAfterDrag() {
        this.paintImmediately(this.cueLine);
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle outer = this.getBounds();
        Rectangle inner = this.getParent().getBounds();
        return new Insets(inner.y - outer.y + 12, inner.x - outer.x + 12, outer.height - inner.height + 12, outer.width - inner.width + 12);
    }

    @Override
    public void autoscroll(Point point) {
        int row = this.getRowForLocation(point.x, point.y);
        if (row < 0) {
            return;
        }
        Rectangle outer = this.getBounds();
        row = point.y + outer.y <= 12 ? (row <= 0 ? 0 : row - 1) : (row < this.getRowCount() - 1 ? row + 1 : row);
        this.scrollRowToVisible(row);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        try {
            this.createDragImage(event);
            this.dragSource.startDrag(event, this.delegate.xjTreeDragSourceDefaultCursor(this), this.dragImage, new Point(5, 5), (Transferable)this.getSelectedNode().getUserObject(), this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createDragImage(DragGestureEvent event) {
        Point dragOrigin = event.getDragOrigin();
        TreePath path = this.getPathForLocation(dragOrigin.x, dragOrigin.y);
        Rectangle r = this.getPathBounds(path);
        this.dragImageOffset.setLocation(dragOrigin.x - r.x, dragOrigin.y - r.y);
        JLabel label = (JLabel)this.getCellRenderer().getTreeCellRendererComponent(this, path.getLastPathComponent(), false, this.isExpanded(path), this.getModel().isLeaf(path.getLastPathComponent()), 0, false);
        label.setSize(r.width, r.height);
        this.dragImage = new BufferedImage(r.width, r.height, 3);
        Graphics2D g2d = this.dragImage.createGraphics();
        g2d.setComposite(AlphaComposite.getInstance(2, 0.5f));
        label.paint(g2d);
        g2d.dispose();
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        this.oldSelectedPath = this.getSelectionPath();
        if (event.getDropAction() != this.getDelegateConstants()) {
            this.cleanUpAfterDrag();
            event.rejectDrag();
        } else {
            event.acceptDrag(this.getDelegateConstants());
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
        int x = event.getLocation().x;
        int y = event.getLocation().y;
        TreePath p = this.getClosestPathForLocation(x, y);
        if (p != this.lastPath) {
            this.lastPath = p;
            this.autoExpandTimer.restart();
        }
        if (p == null || event.getDropAction() != this.getDelegateConstants()) {
            this.cleanUpAfterDrag();
            event.rejectDrag();
        } else {
            event.acceptDrag(this.getDelegateConstants());
            Graphics2D g2d = (Graphics2D)this.getGraphics();
            Rectangle rpath = this.getPathBounds(this.lastPath);
            Rectangle oldCueLine = (Rectangle)this.cueLine.clone();
            if (y < rpath.y + rpath.height / 2) {
                if (this.getRowForPath(this.lastPath) == 0) {
                    this.cueLine.setRect(0.0, rpath.y, this.getWidth(), 2.0);
                } else {
                    this.cueLine.setRect(0.0, rpath.y - 1, this.getWidth(), 2.0);
                }
                this.dropLocation = 0;
            } else {
                this.cueLine.setRect(0.0, rpath.y + rpath.height - 1, this.getWidth(), 2.0);
                this.dropLocation = 2;
            }
            if (!oldCueLine.equals(this.cueLine)) {
                this.paintImmediately(oldCueLine);
            }
            g2d.setColor(Color.black);
            g2d.fill(this.cueLine);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
        if (event.getDropAction() != this.getDelegateConstants()) {
            this.cleanUpAfterDrag();
            event.rejectDrag();
        } else {
            event.acceptDrag(this.getDelegateConstants());
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.cleanUpAfterDrag();
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        this.autoExpandTimer.stop();
        int x = (int)event.getLocation().getX();
        int y = (int)event.getLocation().getY();
        int row = this.getRowForLocation(x, y);
        if (row == -1) {
            this.cleanUpAfterDrag();
            event.rejectDrop();
            return;
        }
        Object targetObject = ((DefaultMutableTreeNode)this.getPathForRow(row).getLastPathComponent()).getUserObject();
        if (this.delegate.xjTreeDrop(this, this.getOldSelectedNode().getUserObject(), targetObject, this.dropLocation)) {
            this.scrollPathToVisible(this.getPathForLocation(x, y));
            event.acceptDrop(this.getDelegateConstants());
            event.dropComplete(true);
        } else {
            event.rejectDrop();
        }
        this.cleanUpAfterDrag();
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }
}

