/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class XJTabbedPane
extends JPanel {
    private final List<Pane> panes = new ArrayList<Pane>();
    private final JTabbedPane tabbedPane = new JTabbedPane();

    public XJTabbedPane() {
        this.setLayout(new BorderLayout());
        this.tabbedPane.addMouseListener(new TabbedPaneMouseListener());
    }

    public void addComponent(String name, Component c) {
        this.panes.add(new Pane(name, c));
        if (this.panes.size() == 1) {
            this.add(c, "Center");
            ChangeEvent e = new ChangeEvent(this.tabbedPane);
            for (ChangeListener l : this.tabbedPane.getChangeListeners()) {
                l.stateChanged(e);
            }
        } else if (this.panes.size() == 2) {
            this.removeAll();
            this.add((Component)this.tabbedPane, "Center");
            this.tabbedPane.add(this.panes.get(0).name, this.panes.get(0).c);
            this.tabbedPane.add(name, c);
        } else if (this.panes.size() > 2) {
            this.tabbedPane.add(name, c);
        }
    }

    public void removeComponent(Component c) {
        int index = this.indexOfComponent(c);
        if (index > 0) {
            this.tabbedPane.remove(c);
            this.panes.remove(index);
            if (this.panes.size() == 1) {
                this.removeAll();
                this.tabbedPane.removeAll();
                Pane p = this.panes.get(0);
                this.add(p.c, "Center");
                ChangeEvent e = new ChangeEvent(this.tabbedPane);
                for (ChangeListener l : this.tabbedPane.getChangeListeners()) {
                    l.stateChanged(e);
                }
            }
        }
    }

    public void selectComponent(Component c) {
        if (this.panes.size() > 1) {
            this.tabbedPane.setSelectedComponent(c);
        }
    }

    public boolean hasComponent(Component component) {
        for (Pane p : this.panes) {
            if (p.c != component) continue;
            return true;
        }
        return false;
    }

    public int indexOfComponent(Component component) {
        for (int i = 0; i < this.panes.size(); ++i) {
            if (this.panes.get(i).c != component) continue;
            return i;
        }
        return -1;
    }

    public Component getSelectedComponent() {
        if (this.panes.size() > 1) {
            return this.tabbedPane.getSelectedComponent();
        }
        return this.panes.get(0).c;
    }

    public int getIndexOfSelectedComponent() {
        return this.indexOfComponent(this.getSelectedComponent());
    }

    public void setTitleAt(int index, String name) {
        this.panes.get(index).name = name;
        if (this.panes.size() > 1) {
            this.tabbedPane.setTitleAt(index, name);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.tabbedPane.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.tabbedPane.removeChangeListener(listener);
    }

    public class TabbedPaneMouseListener
    extends MouseAdapter {
        public void displayPopUp(MouseEvent event) {
            if (!event.isPopupTrigger()) {
                return;
            }
            if (XJTabbedPane.this.getIndexOfSelectedComponent() == 0) {
                return;
            }
            JPopupMenu popup = new JPopupMenu();
            JMenuItem item = new JMenuItem("Close");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    XJTabbedPane.this.removeComponent(XJTabbedPane.this.getSelectedComponent());
                }
            });
            popup.add(item);
            popup.show(event.getComponent(), event.getX(), event.getY());
        }

        public void mousePressed(MouseEvent event) {
            this.displayPopUp(event);
        }

        public void mouseReleased(MouseEvent event) {
            this.displayPopUp(event);
        }
    }

    private class Pane {
        private String name;
        private Component c;

        private Pane(String name, Component c) {
            this.name = name;
            this.c = c;
        }
    }
}

