/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.shape;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.shape.SLink;
import org.antlr.xjlib.foundation.XJXMLSerializable;

public class SLinkArc
extends SLink
implements XJXMLSerializable {
    protected transient QuadCurve2D.Double quad;
    protected transient CubicCurve2D.Double cubic;
    protected transient Shape shape;
    Vector2D vlabel;
    Vector2D pmiddle;

    public void setMouse(Point mouse) {
        this.setMouse(Vector2D.vector(mouse));
    }

    public void setMouse(Vector2D mouse) {
        this.setDirection(mouse.sub(this.end));
    }

    public void setFlatenessByMouse(Vector2D mouse) {
        Vector2D corde = this.getEndWithOffset().sub(this.getStartWithOffset());
        double dot = mouse.sub(this.getStartWithOffset()).dot(corde.normalize());
        corde.setLength(dot);
        Vector2D z = this.getStartWithOffset().add(corde);
        Vector2D f = mouse.sub(z);
        double cross = corde.cross(f);
        if (cross == 0.0) {
            this.setFlateness(0.0);
        } else {
            this.setFlateness(-2.0 * f.length() * cross / Math.abs(cross));
        }
    }

    public void setMousePosition(Vector2D position) {
        this.setFlatenessByMouse(position);
    }

    public boolean contains(PathIterator iterator, double x, double y) {
        double[] coord = new double[6];
        double oldx = -1.0;
        double oldy = -1.0;
        double flateness = 0.8;
        double inset = 4.0;
        FlatteningPathIterator i = new FlatteningPathIterator(iterator, 0.8);
        while (!i.isDone()) {
            switch (i.currentSegment(coord)) {
                case 0: {
                    oldx = coord[0];
                    oldy = coord[1];
                    break;
                }
                case 1: {
                    double nx = coord[0];
                    double ny = coord[1];
                    double rx1 = Math.min(oldx, nx);
                    double ry1 = Math.min(oldy, ny);
                    double rx2 = Math.max(oldx, nx);
                    double ry2 = Math.max(oldy, ny);
                    if (Math.abs(rx1 - rx2) < 4.0 || Math.abs(ry1 - ry2) < 4.0) {
                        rx1 -= 4.0;
                        ry1 -= 4.0;
                        rx2 += 4.0;
                        ry2 += 4.0;
                    }
                    if (x >= rx1 && x <= rx2 && y >= ry1 && y <= ry2) {
                        return true;
                    }
                    oldx = nx;
                    oldy = ny;
                }
            }
            i.next();
        }
        return false;
    }

    public boolean contains(double x, double y) {
        if (this.selfLoop && this.cubic != null) {
            return this.contains(this.cubic.getPathIterator(null), x, y);
        }
        if (!this.selfLoop && this.quad != null) {
            return this.contains(this.quad.getPathIterator(null), x, y);
        }
        return false;
    }

    public void update() {
        if (this.selfLoop) {
            if (this.cubic == null) {
                this.cubic = new CubicCurve2D.Double();
            }
            Vector2D corde = this.direction.copy();
            corde.stretch(1.7);
            if (corde.length() < 100.0) {
                corde.setLength(100.0);
            }
            corde.rotate(-40.0);
            this.cubic.ctrlx1 = this.getStartWithOffset().getX() + corde.getX();
            this.cubic.ctrly1 = this.getStartWithOffset().getY() + corde.getY();
            corde.rotate(80.0);
            this.cubic.ctrlx2 = this.getStartWithOffset().getX() + corde.getX();
            this.cubic.ctrly2 = this.getStartWithOffset().getY() + corde.getY();
            Vector2D v1 = new Vector2D(this.cubic.ctrlx1, this.cubic.ctrly1).sub(this.getStartWithOffset());
            Vector2D v2 = new Vector2D(this.cubic.ctrlx2, this.cubic.ctrly2).sub(this.getStartWithOffset());
            v1 = v1.normalize();
            v1.stretch(this.startTangentOffset);
            v2 = v2.normalize();
            v2.stretch(this.endTangentOffset);
            this.cubic.x1 = this.getStartWithOffset().getX() + v1.getX();
            this.cubic.y1 = this.getStartWithOffset().getY() + v1.getY();
            this.cubic.x2 = this.getEndWithOffset().getX() + v2.getX();
            this.cubic.y2 = this.getEndWithOffset().getY() + v2.getY();
            Vector2D vlabel = this.direction.copy();
            vlabel.setLength(vlabel.length() + 15.0);
            if (vlabel.length() < 75.0) {
                vlabel.setLength(75.0);
            }
            Vector2D plabel = this.getStartWithOffset().add(vlabel);
            this.label.setPosition(plabel);
            this.arrow.setAnchor(this.cubic.x2, this.cubic.y2);
            this.arrow.setDirection(new Vector2D(this.cubic.ctrlx2 - this.cubic.x2, this.cubic.ctrly2 - this.cubic.y2));
            this.shape = this.cubic;
        } else {
            Vector2D middle = this.getEndWithOffset().sub(this.getStartWithOffset());
            middle.stretch(0.5);
            Vector2D height = middle.normalize();
            height.rotate(-90.0);
            if (this.flateness == 0.0) {
                height.setLength(0.01);
            } else {
                height.setLength(this.flateness);
            }
            Vector2D ctrl = middle.add(height);
            if (this.quad == null) {
                this.quad = new QuadCurve2D.Double();
            }
            this.quad.x1 = this.getStartWithOffset().getX();
            this.quad.y1 = this.getStartWithOffset().getY();
            this.quad.x2 = this.getEndWithOffset().getX();
            this.quad.y2 = this.getEndWithOffset().getY();
            this.quad.ctrlx = this.getStartWithOffset().getX() + ctrl.getX();
            this.quad.ctrly = this.getStartWithOffset().getY() + ctrl.getY();
            Vector2D controlPoint = new Vector2D(this.quad.ctrlx, this.quad.ctrly);
            Vector2D v1 = controlPoint.sub(this.getStartWithOffset());
            Vector2D v2 = controlPoint.sub(this.getEndWithOffset());
            v1 = v1.normalize();
            v1.stretch(this.startTangentOffset);
            v2 = v2.normalize();
            v2.stretch(this.endTangentOffset);
            this.quad.x1 = this.getStartWithOffset().getX() + v1.getX();
            this.quad.y1 = this.getStartWithOffset().getY() + v1.getY();
            this.quad.x2 = this.getEndWithOffset().getX() + v2.getX();
            this.quad.y2 = this.getEndWithOffset().getY() + v2.getY();
            this.pmiddle = new Vector2D(this.quad.x1 + (this.quad.x2 - this.quad.x1) * 0.5, this.quad.y1 + (this.quad.y2 - this.quad.y1) * 0.5);
            this.vlabel = new Vector2D(this.quad.x2 - this.quad.x1, this.quad.y2 - this.quad.y1).rotate(90 * (this.flateness < 0.0 ? 1 : -1));
            this.vlabel.setLength(Math.abs(this.flateness) * 0.5 + 20.0);
            this.label.setPosition(this.pmiddle.add(this.vlabel));
            this.arrow.setAnchor(this.quad.x2, this.quad.y2);
            this.arrow.setDirection(controlPoint.sub(this.getEndWithOffset()));
            this.shape = this.quad;
        }
    }

    public void draw(Graphics2D g) {
        if (this.shape == null || this.arrow == null || this.label == null) {
            return;
        }
        g.setColor(this.color);
        this.drawShape(g);
        this.label.draw(g);
    }

    public void drawShape(Graphics2D g) {
        if (this.shape == null || this.arrow == null || this.label == null) {
            return;
        }
        g.draw(this.shape);
        if (this.arrowVisible) {
            this.arrow.draw(g);
        }
    }
}

