/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.event;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.antlr.xjlib.appkit.gview.GView;
import org.antlr.xjlib.appkit.gview.event.GAbstractEvent;
import org.antlr.xjlib.appkit.gview.event.GEventManager;

public class GEventDragSelection
extends GAbstractEvent {
    private boolean selecting = false;
    private Point p1 = null;
    private Point p2 = null;

    public GEventDragSelection(GView view) {
        super(view);
    }

    public void mousePressed(MouseEvent e, Point mousePosition) {
        if (this.hasExclusiveValue(GEventManager.EXCLUSIVE_DRAG_VALUE)) {
            return;
        }
        if (e.getClickCount() != 1) {
            return;
        }
        int mask = 1024;
        if ((e.getModifiersEx() & mask) == mask && this.delegate.eventQueryElementAtPoint(mousePosition) == null) {
            this.addExclusiveValue(GEventManager.EXCLUSIVE_DRAG_VALUE);
            this.selecting = true;
            this.delegate.eventSouldSelectAllElements(false);
            this.p1 = mousePosition;
        }
    }

    public void mouseReleased(MouseEvent e, Point mousePosition) {
        this.removeExclusiveValue(GEventManager.EXCLUSIVE_DRAG_VALUE);
        this.delegate.eventShouldRepaint();
        this.selecting = false;
        this.p1 = null;
        this.p2 = null;
    }

    public void mouseDragged(MouseEvent e, Point mousePosition) {
        if (!this.selecting) {
            return;
        }
        this.p2 = mousePosition;
        this.delegate.eventSelectElementsInRect(this.p1.x, this.p1.y, this.p2.x - this.p1.x, this.p2.y - this.p1.y);
        this.delegate.eventShouldRepaint();
    }

    public void draw(Graphics g) {
        if (this.selecting && this.p1 != null && this.p2 != null) {
            Graphics2D g2d = (Graphics2D)g;
            int x = Math.min(this.p1.x, this.p2.x);
            int y = Math.min(this.p1.y, this.p2.y);
            int dx = Math.abs(this.p2.x - this.p1.x);
            int dy = Math.abs(this.p2.y - this.p1.y);
            g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
            g.setColor(Color.gray);
            g.fillRect(x, y, dx, dy);
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g.setColor(Color.black);
            g.drawRect(x, y, dx, dy);
        }
    }
}

