/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.document;

import java.awt.Component;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.document.XJData;
import org.antlr.xjlib.appkit.document.XJFileMonitor;
import org.antlr.xjlib.appkit.frame.XJWindowInterface;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJFileChooser;
import org.antlr.xjlib.appkit.utils.XJLocalizable;
import org.antlr.xjlib.foundation.XJObject;
import org.antlr.xjlib.foundation.XJUtils;

public class XJDocument
extends XJObject {
    protected XJData documentData;
    protected XJWindowInterface documentWindow;
    protected String documentTitle = XJLocalizable.getXJString("DocUntitled");
    protected String documentPath;
    protected List documentFileExts;
    protected String documentFileExtDescription;
    protected boolean dirty = false;
    protected boolean firstDocument = false;
    protected boolean writing = false;
    protected Component javaContainer;
    protected static int absoluteCounter = 0;
    protected final XJFileMonitor fileMonitor = new XJFileMonitor();

    public XJDocument() {
        this.firstDocument = absoluteCounter == 0;
        ++absoluteCounter;
    }

    public void awake() {
        super.awake();
        if (this.documentWindow != null) {
            this.documentWindow.awake();
        }
    }

    public boolean isInternalOnly() {
        return false;
    }

    public boolean isFirstDocument() {
        return this.firstDocument;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void changeDone() {
        if (this.isDirty()) {
            return;
        }
        this.setDirty(true);
        if (this.documentWindow != null) {
            this.documentWindow.setDirty();
        }
    }

    public void changeReset() {
        this.setDirty(false);
        if (this.documentWindow != null) {
            this.documentWindow.resetDirty();
        }
    }

    public void setTitle(String title) {
        this.documentTitle = title;
        if (this.documentWindow != null) {
            this.documentWindow.setTitle(this.documentTitle);
        }
    }

    public void setWindow(XJWindowInterface window) {
        this.documentWindow = window;
        if (this.documentWindow != null) {
            this.documentWindow.addDocument(this);
            this.documentWindow.setTitle(this.documentTitle);
        }
    }

    public XJWindowInterface getWindow() {
        return this.documentWindow;
    }

    public void setJavaContainer(Component container) {
        this.javaContainer = container;
    }

    public Component getJavaContainer() {
        if (this.javaContainer == null) {
            return this.getWindow() == null ? null : this.getWindow().getJavaContainer();
        }
        return this.javaContainer;
    }

    public void showWindow() {
        if (this.documentWindow != null) {
            this.documentWindow.show();
        }
    }

    public void setDocumentData(XJData data) {
        this.documentData = data;
        if (this.documentData != null) {
            this.documentData.addObserver(this);
        }
    }

    public XJData getDocumentData() {
        return this.documentData;
    }

    public String getDocumentPath() {
        return this.documentPath;
    }

    public String getDocumentFolder() {
        return XJUtils.getPathByDeletingLastComponent(this.getDocumentPath());
    }

    public String getDocumentName() {
        return XJUtils.getLastPathComponent(this.documentPath);
    }

    public String getDocumentNameWithoutExtension() {
        return XJUtils.getPathByDeletingPathExtension(this.getDocumentName());
    }

    public void setDocumentFileType(List ext, String description) {
        this.documentFileExts = ext;
        this.documentFileExtDescription = description;
    }

    public void observeValueForKey(Object sender, String key, Object object) {
        if (!this.writing) {
            this.changeDone();
        }
    }

    public boolean load(String file) throws Exception {
        this.documentPath = file;
        return this.reload();
    }

    public boolean reload() throws Exception {
        this.readDocument(this.documentPath);
        this.setTitle(this.documentPath);
        this.changeReset();
        return true;
    }

    public boolean autoSave() {
        return this.getDocumentPath() == null || !this.isDirty() || this.save(false);
    }

    public boolean save(boolean saveAs) {
        if (this.documentPath == null || saveAs) {
            if (!XJFileChooser.shared().displaySaveDialog(this.getJavaContainer(), this.documentFileExts, this.documentFileExtDescription, true)) {
                return false;
            }
            this.documentPath = XJFileChooser.shared().getSelectedFilePath();
            XJApplication.shared().addRecentFile(this.documentPath);
        }
        try {
            this.writeDocument(this.documentPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            XJAlert.display(this.getJavaContainer(), XJLocalizable.getXJString("DocError"), XJLocalizable.getXJString("DocSaveError") + " " + e.toString());
            return false;
        }
        this.setTitle(this.documentPath);
        this.changeReset();
        return true;
    }

    public boolean close(boolean force) {
        if (this.performClose(force)) {
            if (!this.isInternalOnly()) {
                XJApplication.shared().addRecentFile(this.getDocumentPath());
            }
            return true;
        }
        return false;
    }

    public boolean isModifiedOnDisk() {
        return this.fileMonitor.isModifiedOnDisk(this.getDocumentPath());
    }

    public void synchronizeLastModifiedDate() {
        this.fileMonitor.synchronizeLastModifiedDate(this.getDocumentPath());
    }

    public long getDateOfModificationOnDisk() {
        return this.fileMonitor.getDateOfModificationOnDisk(this.getDocumentPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean performClose(boolean force) {
        if (force) return true;
        if (!this.isDirty()) return true;
        if (!XJApplication.shared().supportsPersistence()) {
            return true;
        }
        if (this.documentWindow != null) {
            this.documentWindow.bringToFront();
        }
        XJAlert.disableEscapeKey();
        try {
            int r = XJAlert.displayAlertYESNOCANCEL(this.getJavaContainer(), XJLocalizable.getXJString("DocCloseTitle"), XJLocalizable.getStringFormat("DocCloseMessage", this.documentTitle));
            switch (r) {
                case 0: {
                    boolean bl = this.save(false);
                    return bl;
                }
                case 1: {
                    boolean bl = true;
                    return bl;
                }
                case 2: {
                    boolean bl = false;
                    return bl;
                }
            }
            return true;
        }
        finally {
            XJAlert.enableEscapeKey();
        }
    }

    private void beginWrite() {
        this.writing = true;
    }

    private void endWrite() {
        this.writing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocument(String file) throws IOException {
        this.beginWrite();
        try {
            this.documentWillWriteData();
            this.documentData.setFile(file);
            switch (this.documentData.dataType()) {
                case 1: {
                    FileOutputStream os = new FileOutputStream(file);
                    this.documentData.writeData(os);
                    ((OutputStream)os).close();
                    break;
                }
                case 2: {
                    FileOutputStream os = new FileOutputStream(file);
                    this.documentData.writeData(new ObjectOutputStream(os));
                    ((OutputStream)os).close();
                    break;
                }
                case 3: {
                    this.documentData.writeData();
                    break;
                }
                case 4: {
                    this.documentData.writeData();
                }
            }
            this.synchronizeLastModifiedDate();
        }
        finally {
            this.endWrite();
        }
    }

    private void readDocument(String file) throws Exception {
        this.documentWillReadData();
        this.documentData.setFile(file);
        switch (this.documentData.dataType()) {
            case 1: {
                FileInputStream is = new FileInputStream(file);
                this.documentData.readData(is);
                ((InputStream)is).close();
                break;
            }
            case 2: {
                FileInputStream is = new FileInputStream(file);
                this.documentData.readData(new ObjectInputStream(is));
                ((InputStream)is).close();
                break;
            }
            case 3: {
                this.documentData.readData();
                break;
            }
            case 4: {
                this.documentData.readData();
            }
        }
        this.documentDidReadData();
        this.synchronizeLastModifiedDate();
    }

    public void documentWillWriteData() {
    }

    public void documentWillReadData() {
    }

    public void documentDidReadData() {
    }
}

