/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.skin.nfa;

import java.awt.Font;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.shape.GLink;

public class NFALink {
    public static void draw(GLink link) {
        float startOffset;
        GContext context = link.getContext();
        float sx = link.source.getX() + context.getPixelNodeWidth() / 2.0f;
        float sy = link.source.getY();
        float tx = link.target.getX() + context.getPixelNodeWidth() / 2.0f;
        float ty = link.target.getY();
        float endOffset = startOffset = context.getPixelNodeWidth() / 2.0f;
        float sloopBaseWidth = context.getPixelValue("w");
        context.setColor(context.linkColor);
        if (link.virtualPosition != null) {
            context.drawArcConnector(sx + (tx - sx) / 2.0f, link.getVirtualY(), sx, sy, startOffset, endOffset, sloopBaseWidth, 0.25f * sloopBaseWidth, link.transition.loop);
            context.drawArcConnector(sx + (tx - sx) / 2.0f, link.getVirtualY(), tx, ty, startOffset, endOffset, sloopBaseWidth, 0.25f * sloopBaseWidth, !link.transition.loop);
        } else if (sy > ty) {
            if (tx - sx > sloopBaseWidth + startOffset + 0.25f * sloopBaseWidth && sloopBaseWidth > 0.0f) {
                context.drawArcConnector(sx, sy, tx, ty, startOffset, endOffset, sloopBaseWidth, 0.25f * sloopBaseWidth, true);
            } else {
                context.drawSpline(sx, sy, tx, ty, startOffset, endOffset, 0.0f, true);
            }
        } else {
            context.drawSpline(sx, sy, tx, ty, startOffset, endOffset, 0.0f, true);
        }
        if (!link.transition.isEpsilon()) {
            Font font = link.transition.externalRuleRef ? context.getRuleFont() : context.getBoxFont();
            context.setColor(context.getColorForLabel(link.transition.label));
            context.drawString(font, link.transition.label, sx + (tx - sx) / 2.0f, sy - 2.0f, 1);
        }
    }
}

