/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.shape;

import java.awt.Point;
import java.awt.Rectangle;
import org.antlr.works.visualization.fa.FATransition;
import org.antlr.works.visualization.graphics.GObject;
import org.antlr.works.visualization.graphics.primitive.GDimension;
import org.antlr.works.visualization.graphics.primitive.GPoint;
import org.antlr.works.visualization.graphics.shape.GNode;
import org.antlr.works.visualization.serializable.SEncoder;
import org.antlr.works.visualization.serializable.SSerializable;

public class GLink
extends GObject
implements SSerializable {
    public FATransition transition;
    public GNode source;
    public GNode target;
    public GDimension branchDim;
    public GPoint virtualPosition;
    public boolean last = false;

    public GLink() {
    }

    public GLink(FATransition transition, GNode target) {
        this.transition = transition;
        this.target = target;
    }

    public void setSource(GNode source) {
        this.source = source;
    }

    public void setVirtualPosition(GPoint position) {
        this.virtualPosition = new GPoint(position);
    }

    public void setBranchDimension(GDimension dimension) {
        this.branchDim = new GDimension(dimension);
    }

    public void setLast(boolean flag) {
        this.last = flag;
    }

    public float getVirtualY() {
        return this.virtualPosition.getY(null);
    }

    public boolean containsStateNumber(int n) {
        return this.transition.containsStateNumber(n);
    }

    public boolean containsPoint(Point p) {
        return this.context.objectContainsPoint(this, p);
    }

    public void render(float ox, float oy) {
        if (this.branchDim != null) {
            this.branchDim.cache(this.context);
        }
        if (this.virtualPosition != null) {
            this.virtualPosition.cache(this.context, ox, oy);
        }
    }

    public Rectangle getBounds() {
        int x1 = (int)this.source.getBeginX();
        int y1 = (int)this.source.getBeginY();
        int x2 = (int)this.target.getEndX();
        int y2 = (int)this.target.getEndY();
        return new Rectangle(x1, y1, Math.max(1, x2 - x1), Math.max(1, y2 - y1));
    }

    public void draw() {
        this.context.drawLink(this);
    }

    public void encode(SEncoder encoder) {
        encoder.write(this.transition);
        encoder.write(this.source);
        encoder.write(this.target);
        encoder.write(this.last);
    }
}

