/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.graph;

import java.awt.Color;
import java.awt.Point;
import java.util.List;
import org.antlr.analysis.NFAState;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.graph.GGraphAbstract;
import org.antlr.works.visualization.graphics.primitive.GDimension;
import org.antlr.works.visualization.graphics.shape.GLink;
import org.antlr.works.visualization.graphics.shape.GNode;
import org.antlr.works.visualization.serializable.SEncoder;
import org.antlr.works.visualization.serializable.SSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GGraph
extends GGraphAbstract
implements SSerializable {
    private GDimension dimension;
    public List<GNode> nodes;
    public String name;
    public String nameWidth;
    public float offsetX = 0.0f;
    public float offsetY = 0.0f;
    public static final int TITLE_OFFSET = 100;

    @Override
    public void setEnable(boolean flag) {
    }

    @Override
    public void setContext(GContext context) {
        super.setContext(context);
        for (GNode node : this.nodes) {
            node.setContext(context);
        }
    }

    public void setName(String name) {
        this.name = name;
        this.nameWidth = GContext.getStringWidth(name);
    }

    public void setDimension(GDimension dimension) {
        this.dimension = dimension;
    }

    public void setNodes(List<GNode> nodes) {
        this.nodes = nodes;
    }

    @Override
    public GDimension getDimension() {
        GDimension d = new GDimension(this.dimension);
        if (this.context.isShowRuleName()) {
            d.addWidth(this.nameWidth);
        }
        return d;
    }

    @Override
    public float getHeight() {
        return Math.max(this.getDimension().getPixelHeight(this.context), this.context.getPixelArrowHeight());
    }

    @Override
    public float getWidth() {
        return this.getDimension().getPixelWidth(this.context);
    }

    @Override
    public void render(float ox, float oy) {
        oy += this.getDimension().getPixelUp(this.context);
        float titleOffset = this.context.isShowRuleName() ? this.context.getPixelValue(this.nameWidth) : 0.0f;
        for (GNode node : this.nodes) {
            node.render(ox + titleOffset, oy);
        }
        this.offsetX = ox;
        this.offsetY = oy;
        this.setRendered(true);
    }

    @Override
    public void draw() {
        this.context.nodeColor = Color.black;
        this.context.linkColor = Color.black;
        this.context.setLineWidth(1.0f);
        this.context.setColor(Color.black);
        if (this.context.isShowRuleName()) {
            this.context.drawString(this.context.getRuleFont(), this.name, this.offsetX, this.offsetY, 3);
        }
        for (GNode node : this.nodes) {
            node.drawNodeAndLink();
        }
        if (this.context.drawdimension) {
            this.context.setColor(Color.lightGray);
            float width = this.getDimension().getPixelWidth(this.context);
            float up = this.getDimension().getPixelUp(this.context);
            float down = this.getDimension().getPixelDown(this.context);
            if (up + down > 0.0f) {
                this.context.drawRect(this.offsetX, this.offsetY - up, width, up + down, false);
            }
        }
    }

    public GLink findLinkAtPosition(int x, int y) {
        for (GNode node : this.nodes) {
            for (GLink link : node.links) {
                if (!link.containsPoint(new Point(x, y)) || link.transition.label == null) continue;
                return link;
            }
        }
        return null;
    }

    public GNode findNodeForStateNumber(int stateNumber) {
        for (GNode node : this.nodes) {
            if (node.state.stateNumber != stateNumber) continue;
            return node;
        }
        return null;
    }

    public boolean containsAtLeastOneState(List states) {
        for (GNode node : this.nodes) {
            for (Object state1 : states) {
                NFAState state = (NFAState)state1;
                if (!node.containsStateNumber(state.stateNumber)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void encode(SEncoder encoder) {
        encoder.write(this.dimension);
        for (GNode node : this.nodes) {
            encoder.write(node);
        }
    }
}

