/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.fa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.analysis.NFAState;
import org.antlr.works.visualization.fa.FATransition;
import org.antlr.works.visualization.serializable.SEncoder;
import org.antlr.works.visualization.serializable.SSerializable;

public class FAState
implements SSerializable {
    public int stateNumber = -1;
    public boolean acceptedState = false;
    public String enclosingRuleName = null;
    public List<FATransition> transitions = new ArrayList<FATransition>();
    public String externalRuleRefName = null;
    public boolean loop = false;

    public FAState(int stateNumber) {
        this.stateNumber = stateNumber;
    }

    public FAState(NFAState state) {
        this.stateNumber = state.stateNumber;
        this.acceptedState = state.isAcceptState();
        this.enclosingRuleName = state.enclosingRule.name;
    }

    public FAState(String externalRuleRefName) {
        this.externalRuleRefName = externalRuleRefName;
    }

    public void addTransition(FATransition transition) {
        transition.setSourceState(this);
        this.transitions.add(transition);
        this.sortTransitions();
    }

    public void addTransition(FATransition transition, boolean loop) {
        transition.setSourceState(this);
        transition.setLoop(loop);
        this.transitions.add(transition);
        this.sortTransitions();
    }

    private void sortTransitions() {
        if (this.transitions.size() <= 1) {
            return;
        }
        for (int t = 0; t < this.transitions.size(); ++t) {
            FATransition transition = this.transitions.get(t);
            if (!transition.loop || t >= this.transitions.size() - 1) continue;
            Collections.swap(this.transitions, t, this.transitions.size() - 1);
            break;
        }
    }

    public FATransition getFirstTransition() {
        if (this.transitions.isEmpty()) {
            return null;
        }
        return this.transitions.get(0);
    }

    public FATransition transition(int index) {
        return this.transitions.get(index);
    }

    public int getNumberOfTransitions() {
        return this.transitions.size();
    }

    public FAState getNextFirstState() {
        return this.getFirstTransition().target;
    }

    public FATransition getTransitionToStateNumber(int stateNumber) {
        for (FATransition transition : this.transitions) {
            if (transition.target.stateNumber != stateNumber) continue;
            return transition;
        }
        return null;
    }

    public FATransition getTransitionToExternalStateRule(String externalRule) {
        for (FATransition tr : this.transitions) {
            if (tr.target == null) continue;
            for (FATransition targetTr : tr.target.transitions) {
                if (targetTr.label == null || !targetTr.label.equals(externalRule)) continue;
                return tr;
            }
        }
        return null;
    }

    public boolean isAlternative() {
        return this.getNumberOfTransitions() > 1;
    }

    public boolean isSingle() {
        return this.getNumberOfTransitions() == 1;
    }

    public int hashCode() {
        return this.stateNumber;
    }

    public boolean equals(Object o) {
        if (o instanceof FAState) {
            FAState otherState = (FAState)o;
            return this.stateNumber == otherState.stateNumber;
        }
        return false;
    }

    public String toString() {
        if (this.externalRuleRefName == null) {
            return String.valueOf(this.stateNumber);
        }
        return "<" + this.externalRuleRefName + ">";
    }

    public void encode(SEncoder encoder) {
        encoder.write(this.stateNumber);
        encoder.write(this.acceptedState);
        encoder.write(this.enclosingRuleName);
        for (FATransition t : this.transitions) {
            encoder.write(t);
        }
        encoder.write(this.externalRuleRefName);
        encoder.write(this.loop);
    }
}

