/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.stringtemplate;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.print.PrinterException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPopupMenu;
import org.antlr.works.ate.ATEPanel;
import org.antlr.works.ate.ATEPanelAdapter;
import org.antlr.works.ate.syntax.misc.ATELine;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.editor.ComponentEditor;
import org.antlr.works.editor.completion.AutoCompletionMenu;
import org.antlr.works.editor.completion.AutoCompletionMenuDelegate;
import org.antlr.works.editor.navigation.GoToHistory;
import org.antlr.works.editor.navigation.GoToRule;
import org.antlr.works.find.FindAndReplace;
import org.antlr.works.grammar.element.Jumpable;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.stringtemplate.ComponentContainerStringTemplate;
import org.antlr.works.stringtemplate.STRulePanel;
import org.antlr.works.stringtemplate.element.ElementTemplateReference;
import org.antlr.works.stringtemplate.element.ElementTemplateRule;
import org.antlr.works.stringtemplate.menu.ContextualStringTemplateMenuFactory;
import org.antlr.works.stringtemplate.syntax.ATEStringTemplateSyntaxEngine;
import org.antlr.works.stringtemplate.syntax.ATEStringTemplateSyntaxParser;
import org.antlr.xjlib.appkit.menu.XJMenuItemCheck;
import org.antlr.xjlib.appkit.undo.XJUndo;
import org.antlr.xjlib.appkit.undo.XJUndoDelegate;
import org.antlr.xjlib.appkit.utils.XJAlert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentEditorStringTemplate
extends ComponentEditor
implements AutoCompletionMenuDelegate,
XJUndoDelegate {
    public AutoCompletionMenu autoCompletionMenu;
    public ATEPanel textEditor;
    public STRulePanel rulesPanel;
    public FindAndReplace findAndReplace;
    public GoToHistory goToHistory;
    public GoToRule goToRule;

    @Override
    public void create() {
        this.createInterface();
        this.initAutoCompletion();
        this.initComponents();
        this.initTools();
        this.register();
    }

    protected void createInterface() {
        this.createTextEditor();
    }

    protected void createTextEditor() {
        this.textEditor = new ATEPanel(this.getXJFrame());
        this.textEditor.setParserEngine(new ATEStringTemplateSyntaxEngine());
        this.textEditor.setSyntaxColoring(true);
        this.textEditor.setAnalysisColumnVisible(false);
        this.applyPrefs();
        this.textEditor.setDelegate(new TextPanelDelegate());
    }

    public STRulePanel getComponentRules() {
        return this.rulesPanel;
    }

    @Override
    public ComponentContainerStringTemplate getContainer() {
        return (ComponentContainerStringTemplate)this.container;
    }

    protected void initComponents() {
        this.rulesPanel = new STRulePanel(this);
    }

    protected void initAutoCompletion() {
        if (this.autoCompletionMenu != null) {
            this.autoCompletionMenu.close();
        }
        this.autoCompletionMenu = new AutoCompletionMenu(this, this.getTextPane(), this.getXJFrame());
    }

    protected void initTools() {
        this.goToHistory = new GoToHistory();
        this.findAndReplace = new FindAndReplace(this);
        this.goToRule = new GoToRule(this, this.getXJFrame(), this.getTextPane());
    }

    protected void register() {
        this.getXJFrame().registerUndo(this, this.getTextPane());
    }

    @Override
    public void assemble() {
        this.mainPanel.add(this.textEditor);
    }

    public void applyPrefs() {
        this.textEditor.setFoldingEnabled(AWPrefs.getFoldingEnabled());
        this.textEditor.setLineNumberEnabled(AWPrefs.getLineNumberEnabled());
        this.textEditor.setHighlightCursorLine(AWPrefs.getHighlightCursorEnabled());
        this.textEditor.getTextPane().setFont(new Font(AWPrefs.getEditorFont(), 0, AWPrefs.getEditorFontSize()));
        this.textEditor.getTextPane().setTabSize(AWPrefs.getEditorTabSize());
        this.textEditor.refresh();
        this.initAutoCompletion();
        this.applyFont();
    }

    public void applyFont() {
        this.getTextPane().setFont(new Font(AWPrefs.getEditorFont(), 0, AWPrefs.getEditorFontSize()));
        this.getTextPane().setTabSize(AWPrefs.getEditorTabSize());
    }

    @Override
    public void close() {
        this.goToRule.close();
        this.findAndReplace.close();
        this.autoCompletionMenu.close();
        this.rulesPanel = null;
        this.textEditor.close();
        this.getXJFrame().unregisterUndo(this);
        super.close();
    }

    @Override
    public String getText() {
        return this.textEditor.getText();
    }

    @Override
    public ATEPanel getTextEditor() {
        return this.textEditor;
    }

    @Override
    public void setCaretPosition(int pos) {
        this.textEditor.setCaretPosition(pos);
    }

    @Override
    public void goToHistoryRememberCurrentPosition() {
        this.goToHistory.addPosition(this.getCaretPosition());
        this.refreshMainMenuBar();
    }

    public ElementTemplateReference getCurrentReference() {
        return this.getReferenceAtPosition(this.getCaretPosition());
    }

    public ElementTemplateReference getReferenceAtPosition(int pos) {
        for (ElementTemplateReference ref : this.getReferences()) {
            if (!ref.containsIndex(pos)) continue;
            return ref;
        }
        return null;
    }

    public List<ElementTemplateReference> getReferences() {
        return ((ATEStringTemplateSyntaxParser)this.getTextEditor().getParserEngine().getParser()).references;
    }

    public List<ATEToken> getDeclarations() {
        return ((ATEStringTemplateSyntaxParser)this.getTextEditor().getParserEngine().getParser()).decls;
    }

    @Override
    public void goToBackward() {
        if (this.goToHistory.canGoBack()) {
            this.setCaretPosition(this.goToHistory.getBackPosition(this.getCaretPosition()));
            this.refreshMainMenuBar();
        }
    }

    @Override
    public void goToForward() {
        if (this.goToHistory.canGoForward()) {
            this.setCaretPosition(this.goToHistory.getForwardPosition());
            this.refreshMainMenuBar();
        }
    }

    @Override
    public List<ATELine> getLines() {
        return this.textEditor.getLines();
    }

    @Override
    public void find() {
        StatisticsAW.shared().recordEvent(10);
        this.findAndReplace.find();
    }

    @Override
    public FindAndReplace getFindAndReplace() {
        return this.findAndReplace;
    }

    @Override
    public GoToRule getGoToRule() {
        return this.goToRule;
    }

    @Override
    public boolean goToRule(String ruleName) {
        for (ElementTemplateRule r : this.getRules()) {
            if (!r.name.equals(ruleName)) continue;
            this.goToHistoryRememberCurrentPosition();
            this.setCaretPosition(r.start.getStartIndex());
            return true;
        }
        return false;
    }

    @Override
    public List<String> getRulesStartingWith(String match) {
        ArrayList<String> matches = new ArrayList<String>();
        if (this.getRules() == null) {
            return matches;
        }
        for (ElementTemplateRule r : this.getRules()) {
            String rname = r.name.toLowerCase();
            if (!rname.startsWith(match) || matches.contains(r.name)) continue;
            matches.add(r.name);
        }
        return matches;
    }

    @Override
    public void goToDeclaration() {
        ElementTemplateReference ref = this.getCurrentReference();
        this.container.getActionGoTo().goToDeclaration(ref);
    }

    @Override
    public void goToDeclaration(Jumpable ref) {
        if (ref == null) {
            return;
        }
        this.goToHistoryRememberCurrentPosition();
        int index = this.getFirstDeclarationPosition(ref.getName());
        if (index != -1) {
            this.setCaretPosition(index);
        }
    }

    public int getFirstDeclarationPosition(String name) {
        ATEToken token = this.getFirstDeclaration(name);
        if (token != null) {
            return token.start;
        }
        return -1;
    }

    private ATEToken getFirstDeclaration(String name) {
        for (ATEToken decl : this.getDeclarations()) {
            if (!decl.getAttribute().equals(name)) continue;
            return decl;
        }
        return null;
    }

    @Override
    public ATEToken getCurrentToken() {
        return this.getTokenAtPosition(this.getCaretPosition(), false);
    }

    public List<ElementTemplateRule> getRules() {
        return ((ATEStringTemplateSyntaxParser)this.getTextEditor().getParserEngine().getParser()).templateRules;
    }

    public ATEToken getTokenAtPosition(int pos, boolean fromRight) {
        List<ATEToken> tokens = this.getTokens();
        if (tokens == null) {
            return null;
        }
        if (fromRight) {
            for (int i = tokens.size() - 1; i >= 0; --i) {
                ATEToken token = tokens.get(i);
                if (!token.containsIndex(pos)) continue;
                return token;
            }
        } else {
            for (ATEToken token : tokens) {
                if (!token.containsIndex(pos)) continue;
                return token;
            }
        }
        return null;
    }

    public boolean isRulesSorted() {
        return this.rulesPanel.isRulesSorted();
    }

    public void toggleRulesSorting() {
        StatisticsAW.shared().recordEvent(123);
        this.rulesPanel.toggleSorting();
        this.getContainer().getToolbar().updateStates();
        this.getComponentRules().refreshRules();
    }

    public JPopupMenu rulesGetContextualMenu() {
        ContextualStringTemplateMenuFactory factory = this.getContainer().createContextualStringTemplateMenuFactory();
        XJMenuItemCheck item = (XJMenuItemCheck)factory.addItem(110);
        item.setSelected(this.isRulesSorted());
        return factory.menu;
    }

    @Override
    public void componentDocumentContentChanged() {
        if (!this.isFileExists()) {
            XJAlert.display(this.getWindowContainer(), "Warning", "The document cannot be found on the disk anymore.");
            return;
        }
        if (AWPrefs.isAlertFileChangesDetected()) {
            XJAlert alert = XJAlert.createInstance();
            alert.setDisplayDoNotShowAgainButton(true);
            int result = alert.showCustom(this.getWindowContainer(), "File Changes", "The file \"" + this.getFileName() + "\" changed on the disk. Do you want to reload it?", "Cancel", "Reload", 1, 0);
            AWPrefs.setAlertFileChangesDetected(!alert.isDoNotShowAgain());
            if (result == 0) {
                return;
            }
        }
        int oldCursorPosition = this.textEditor.getCaretPosition();
        try {
            this.getDocument().reload();
        }
        catch (Exception e) {
            e.printStackTrace();
            XJAlert.display(this.getWindowContainer(), "Error Reloading Document", "An error occurred when reloading the document:\n" + e.toString());
        }
        this.textEditor.setCaretPosition(Math.min(oldCursorPosition, this.getText().length()), true, AWPrefs.getSmoothScrolling());
    }

    @Override
    public void loadText(String text) {
        this.textEditor.loadText(text);
    }

    @Override
    public void beginGroupChange(String name) {
        this.disableTextPane(false);
        this.beginTextPaneUndoGroup(name);
    }

    @Override
    public void endGroupChange() {
        this.endTextPaneUndoGroup();
        this.enableTextPane(false);
        this.textEditor.parse();
        this.changeDone();
    }

    public void enableTextPane(boolean undo) {
        this.textEditor.setEnableRecordChange(true);
        if (undo) {
            this.enableTextPaneUndo();
        }
    }

    public void disableTextPane(boolean undo) {
        this.textEditor.setEnableRecordChange(false);
        if (undo) {
            this.disableTextPaneUndo();
        }
    }

    public void beginTextPaneUndoGroup(String name) {
        XJUndo undo = this.getXJFrame().getUndo(this.getTextPane());
        if (undo != null) {
            undo.beginUndoGroup(name);
        }
    }

    public void endTextPaneUndoGroup() {
        XJUndo undo = this.getXJFrame().getUndo(this.getTextPane());
        if (undo != null) {
            undo.endUndoGroup();
        }
    }

    @Override
    public void disableTextPaneUndo() {
        this.textEditor.disableUndo();
    }

    @Override
    public void enableTextPaneUndo() {
        this.textEditor.enableUndo();
    }

    @Override
    public void undoManagerWillUndo(boolean redo) {
    }

    public void changeDone() {
        this.getDocument().changeDone();
    }

    @Override
    public void undoManagerDidUndo(boolean redo) {
        this.changeDone();
    }

    @Override
    public void notificationPrefsChanged() {
        this.applyPrefs();
    }

    @Override
    public List<String> autoCompletionMenuGetMatchingWordsForPartialWord(String partialWord) {
        partialWord = partialWord.toLowerCase();
        ArrayList<String> matchingArgs = new ArrayList<String>();
        ArrayList<String> matchingRules = new ArrayList<String>();
        List<ElementTemplateRule> rules = ((ATEStringTemplateSyntaxParser)this.textEditor.getParserEngine().getParser()).templateRules;
        int index = this.getCaretPosition();
        if (rules == null || rules.size() == 0) {
            return null;
        }
        for (ElementTemplateRule rule : rules) {
            if (rule.name.toLowerCase().startsWith(partialWord) && !matchingRules.contains(rule.name)) {
                matchingRules.add(rule.name);
            }
            if (!rule.containsIndex(index)) continue;
            for (ATEToken arg : rule.args) {
                if (!arg.getAttribute().toLowerCase().startsWith(partialWord) || matchingArgs.contains(arg.getAttribute())) continue;
                matchingArgs.add(arg.getAttribute());
            }
        }
        Collections.sort(matchingRules);
        Collections.sort(matchingArgs);
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(matchingArgs);
        ret.addAll(matchingRules);
        return ret;
    }

    @Override
    public void autoCompletionMenuWillDisplay() {
    }

    public synchronized boolean isFileExists() {
        String path = this.getFilePath();
        if (path == null) {
            return false;
        }
        File f = new File(path);
        return f.exists();
    }

    public synchronized boolean isFileWritable() {
        String path = this.getFilePath();
        if (path == null) {
            return true;
        }
        File f = new File(path);
        return !f.exists() || f.canWrite();
    }

    public synchronized String getFilePath() {
        return this.getDocument().getDocumentPath();
    }

    public synchronized String getFileName() {
        return this.getDocument().getDocumentName();
    }

    public Container getWindowContainer() {
        return this.getXJFrame().getJavaContainer();
    }

    public void print() {
        try {
            this.textEditor.print();
        }
        catch (PrinterException e) {
            XJAlert.display(this.getWindowContainer(), "Print Error", "An error occurred while printing:\n" + e.toString());
        }
    }

    private class TextPanelDelegate
    extends ATEPanelAdapter {
        private TextPanelDelegate() {
        }

        public void ateChangeUpdate(int offset, int length, boolean insert) {
            ComponentEditorStringTemplate.this.getDocument().changeDone();
        }

        public void ateEngineDidParse() {
            ComponentEditorStringTemplate.this.getComponentRules().refreshRules();
        }

        public void ateCaretUpdate(int index) {
            ComponentEditorStringTemplate.this.autoCompletionMenu.updateAutoCompleteList();
        }

        public void ateInvokePopUp(Component component, int x, int y) {
            JPopupMenu m = ComponentEditorStringTemplate.this.container.getContextualMenu(ComponentEditorStringTemplate.this.textEditor.getTextIndexAtPosition(x, y));
            if (m != null) {
                m.show(component, x, y);
            }
        }
    }
}

