/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.menu;

import java.util.Set;
import javax.swing.JOptionPane;
import org.antlr.works.ate.syntax.misc.ATELine;
import org.antlr.works.components.container.ComponentContainer;
import org.antlr.works.components.editor.ComponentEditor;
import org.antlr.works.components.editor.ComponentEditorGrammar;
import org.antlr.works.grammar.element.Jumpable;
import org.antlr.works.menu.ActionAbstract;
import org.antlr.works.stats.StatisticsAW;

public class ActionGoTo
extends ActionAbstract {
    public ActionGoTo(ComponentContainer editor) {
        super(editor);
    }

    public ComponentEditor getSelectedEditor() {
        return super.getSelectedEditor();
    }

    public void goToRule() {
        StatisticsAW.shared().recordEvent(20);
        this.getSelectedEditor().getGoToRule().display();
    }

    public void goToDeclaration() {
        this.getSelectedEditor().goToDeclaration();
    }

    public void goToDeclaration(Jumpable ref) {
        StatisticsAW.shared().recordEvent(21);
        this.getSelectedEditor().goToDeclaration(ref);
    }

    public void goToBreakpoint(int direction) {
        if (direction == -1) {
            StatisticsAW.shared().recordEvent(26);
        } else {
            StatisticsAW.shared().recordEvent(27);
        }
        Set<Integer> breakpoints = ((ComponentEditorGrammar)this.getSelectedEditor()).getBreakpoints();
        int line = this.getSelectedEditor().getTextEditor().getLineIndexAtTextPosition(this.getCaretPosition());
        if (line == -1) {
            return;
        }
        while ((line += direction) >= 0 && line <= ((ComponentEditorGrammar)this.getSelectedEditor()).getGrammarEngine().getNumberOfLines() - 1) {
            if (!breakpoints.contains(line)) continue;
            this.moveCursorToLine(line);
            break;
        }
    }

    public void goToLine() {
        StatisticsAW.shared().recordEvent(22);
        String s = (String)JOptionPane.showInputDialog(this.getSelectedEditor().getJavaContainer(), "Line number:", "Go To Line", 3, null, null, null);
        if (s != null) {
            this.moveCursorToLine(Integer.parseInt(s) - 1);
        }
    }

    public void goToCharacter() {
        StatisticsAW.shared().recordEvent(23);
        String s = (String)JOptionPane.showInputDialog(this.getSelectedEditor().getJavaContainer(), "Character number:", "Go To Character", 3, null, null, null);
        if (s != null) {
            int character = Integer.parseInt(s);
            if (character < 0 || character > this.getTextPane().getDocument().getLength() - 1) {
                return;
            }
            this.getSelectedEditor().goToHistoryRememberCurrentPosition();
            this.setCaretPosition(character);
        }
    }

    public void goToBackward() {
        this.getSelectedEditor().goToBackward();
    }

    public void goToForward() {
        this.getSelectedEditor().goToForward();
    }

    public void moveCursorToLine(int lineIndex) {
        if (lineIndex < 0 || lineIndex > this.getSelectedEditor().getLines().size() - 1) {
            return;
        }
        ATELine line = this.getSelectedEditor().getLines().get(lineIndex);
        this.getSelectedEditor().goToHistoryRememberCurrentPosition();
        this.setCaretPosition(line.position);
    }
}

