/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.grammar;

import java.util.ArrayList;
import java.util.List;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.editor.ComponentEditorGrammar;
import org.antlr.works.grammar.GrammarDOTTab;
import org.antlr.works.grammar.element.ElementReference;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.xjlib.appkit.utils.XJAlert;

public class RulesDependency
extends GrammarDOTTab {
    protected List<String> visitedRules = new ArrayList<String>();
    protected List<String> visitedRefs = new ArrayList<String>();
    protected StringBuilder dependency;
    protected boolean includeLexerRefs;

    public RulesDependency(ComponentEditorGrammar editor) {
        super(editor);
    }

    protected boolean willLaunch() {
        if (!this.checkForCurrentRule()) {
            return false;
        }
        ElementRule rule = this.editor.getCurrentRule();
        List<ElementReference> refs = this.editor.rules.getReferencesInRule(rule);
        if (refs == null || refs.isEmpty()) {
            XJAlert.display(this.editor.getWindowContainer(), "Error", "The selected rule doesn't contain any references");
            return false;
        }
        this.includeLexerRefs = true;
        if (!rule.lexer && this.editor.getGrammarEngine().isCombinedGrammar()) {
            this.includeLexerRefs = XJAlert.displayAlertYESNO(this.editor.getWindowContainer(), "Rule Dependency Graph", "Do you want to include lexer references ?") == 0;
        }
        return true;
    }

    public String getDOTString() throws Exception {
        ElementRule rule = this.editor.getCurrentRule();
        this.visitedRules.clear();
        this.visitedRefs.clear();
        this.dependency = new StringBuilder();
        this.dependency.append("digraph {\n");
        this.buildGraph(rule);
        this.dependency.append("}");
        return this.dependency.toString();
    }

    protected void buildGraph(ElementRule rule) {
        if (rule == null) {
            return;
        }
        this.visitedRules.add(rule.name);
        List<ElementReference> refs = this.editor.rules.getReferencesInRule(rule);
        if (refs == null || refs.isEmpty()) {
            return;
        }
        for (ElementReference reference : refs) {
            String refRuleName = reference.token.getAttribute();
            String visitedRef = rule.name + " -> " + refRuleName;
            if (this.visitedRefs.contains(visitedRef) || ATEToken.isLexerName(reference.token.getAttribute()) && !this.includeLexerRefs) continue;
            this.visitedRefs.add(visitedRef);
            this.dependency.append(visitedRef);
            this.dependency.append(";\n");
            if (this.visitedRules.contains(refRuleName)) continue;
            this.buildGraph(this.editor.getGrammarEngine().getRuleWithName(refRuleName));
        }
    }

    public String getTabName() {
        return "Dependency of \"" + this.rule.name + "\"";
    }
}

