/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.grammar;

import org.antlr.works.components.editor.ComponentEditorGrammar;
import org.antlr.works.grammar.CheckGrammarDelegate;
import org.antlr.works.grammar.antlr.GrammarResult;

public class CheckGrammar
implements Runnable {
    private volatile CheckGrammarDelegate delegate;
    private volatile ComponentEditorGrammar editor;
    private volatile boolean cancelled = false;

    public CheckGrammar(ComponentEditorGrammar editor, CheckGrammarDelegate delegate) {
        this.editor = editor;
        this.delegate = delegate;
    }

    public void close() {
        this.editor.hideProgress();
        this.editor = null;
        this.delegate = null;
    }

    public void check() {
        new Thread(this).start();
    }

    public void cancel() {
        this.cancelled = true;
        this.editor.getGrammarEngine().cancelAnalyze();
    }

    public void run() {
        GrammarResult result;
        this.editor.getConsole().setMode(1);
        this.delegate.checkGrammarDidBegin(this);
        try {
            result = this.editor.getGrammarEngine().analyze();
        }
        catch (Exception e) {
            this.editor.getConsole().println(e);
            result = new GrammarResult(e);
        }
        if (!this.cancelled) {
            this.delegate.checkGrammarDidEnd(this, result);
        }
    }
}

